/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.SupOrderItemBomMapper;
import com.els.base.purchase.entity.SupOrderItemBom;
import com.els.base.purchase.entity.SupOrderItemBomExample;
import com.els.base.purchase.service.SupOrderItemBomService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupOrderItemBomService")
public class SupOrderItemBomServiceImpl
implements SupOrderItemBomService {
    @Resource
    protected SupOrderItemBomMapper supOrderItemBomMapper;

    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void addObj(SupOrderItemBom t) {
        this.supOrderItemBomMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void addAll(List<SupOrderItemBom> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.supOrderItemBomMapper.insertBatch(list);
    }

    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supOrderItemBomMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void modifyObj(SupOrderItemBom t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.supOrderItemBomMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public SupOrderItemBom queryObjById(String id) {
        return this.supOrderItemBomMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public List<SupOrderItemBom> queryAllObjByExample(SupOrderItemBomExample example) {
        return this.supOrderItemBomMapper.selectByExample(example);
    }

    @Cacheable(value={"supOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public PageView<SupOrderItemBom> queryObjByPage(SupOrderItemBomExample example) {
        PageView<SupOrderItemBom> pageView = example.getPageView();
        pageView.setQueryResult(this.supOrderItemBomMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        Assert.isNotBlank((String)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        SupOrderItemBomExample example = new SupOrderItemBomExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        this.supOrderItemBomMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void addByPurOrderId(String orderId) {
        this.supOrderItemBomMapper.insertByPurOrderItemBom(orderId);
    }

    @Override
    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void insertHisByOrderId(String hisOrderId, String orderId, String cause) {
        this.supOrderItemBomMapper.insertHisByOrderId(hisOrderId, orderId, cause);
    }

    @Override
    @Cacheable(value={"supOrderItemBom"}, keyGenerator="redisKeyGenerator")
    public List<SupOrderItemBom> queryByOrderId(String orderId) {
        SupOrderItemBomExample example = new SupOrderItemBomExample();
        example.createCriteria().andOrderIdEqualTo(orderId);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        return this.supOrderItemBomMapper.selectByExample(example);
    }

    @CacheEvict(value={"supOrderItemBom"}, allEntries=true)
    public void deleteByExample(SupOrderItemBomExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supOrderItemBomMapper.deleteByExample(example);
    }
}

