/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.core.utils.Constant;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderIsEnableEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.utils.reflect.ReflectUtils;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public abstract class PurchaseOrderChangeUtils {
    public static final String CHANGE_QUANTITY = "\u53d8\u66f4\u6570\u91cf";
    public static final String CHANGE_TAX_UNIT_PRICE = "\u53d8\u66f4\u542b\u7a0e\u5355\u4ef7";
    public static final String CHANGE_TAX_TOTAL_PRICE = "\u53d8\u66f4\u542b\u7a0e\u603b\u4ef7";
    public static final String CHANGE_IS_OFFICAL_PRICE = "\u53d8\u66f4\u6682\u4f30\u4ef7\u6807\u8bc6";
    public static final String CHAGE_DELIVERY_DATE = "\u53d8\u66f4\u4ea4\u671f\u65f6\u95f4";
    private static List<String> fieldList = Arrays.asList("materialCode", "purReqNo", "purReqItemNo", "isJit", "returnFlag", "orderUnit", "priceUnit", "taxCode", "taxRate", "warehouseLocation", "warehouseName", "deliveryLocation", "factory", "factoryName", "bomDesc", "orderType", "masterOrderNo", "masterOrderItemNo", "materialUnitPrice", "materialTotalPirce");

    public static boolean isChangeDeliveryDate(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        Date purItemDeliveryDate = DateUtils.truncate((Date)purItem.getDeliveredDate(), (int)5);
        Date supItemDeliveryDate = DateUtils.truncate((Date)supItem.getDeliveredDate(), (int)5);
        return purItemDeliveryDate.getTime() != supItemDeliveryDate.getTime() || purItem.getQuantity().compareTo(supItem.getQuantity()) != 0 || !purItem.getIsEnable().equals(supItem.getIsEnable()) || !purItem.getFinishFlag().equals(supItem.getFinishFlag()) || !purItem.getIsJit().equals(supItem.getIsJit());
    }

    public static List<PurchaseOrderChange> compareItemForMainProperty(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        PurchaseOrderChange deliveryDate;
        PurchaseOrderChange price;
        PurchaseOrderChange quantity;
        PurchaseOrderChange isEnable;
        ArrayList<PurchaseOrderChange> changeList = new ArrayList<PurchaseOrderChange>();
        PurchaseOrderChange finishFlag = PurchaseOrderChangeUtils.buildChangeForFinishFlag(purItem, supItem);
        if (finishFlag != null) {
            changeList.add(finishFlag);
        }
        if ((isEnable = PurchaseOrderChangeUtils.buildChangeForIsEnable(purItem, supItem)) != null) {
            changeList.add(isEnable);
        }
        if ((quantity = PurchaseOrderChangeUtils.buildChangeForQuantity(purItem, supItem)) != null) {
            changeList.add(quantity);
        }
        if ((price = PurchaseOrderChangeUtils.buildChangeForPriceTaxTotal(purItem, supItem)) != null) {
            changeList.add(price);
        }
        if ((deliveryDate = PurchaseOrderChangeUtils.buildChangeForDeliveryDate(purItem, supItem)) != null) {
            changeList.add(deliveryDate);
        }
        return changeList;
    }

    public static List<PurchaseOrderChange> compareItemForOtherProperty(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        ArrayList<PurchaseOrderChange> changeList = new ArrayList<PurchaseOrderChange>();
        for (String fieldName : fieldList) {
            Object supfieldValue;
            String supfieldValueString;
            PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
            change.setChangeType(ChangeTypeEnum.MODIFY_ITEM.getValue());
            String changeField = String.format("\u5176\u4ed6\u53d8\u66f4:%s", fieldName);
            ApiModelProperty annotation = null;
            try {
                annotation = purItem.getClass().getDeclaredField(fieldName).getAnnotation(ApiModelProperty.class);
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            if (annotation != null) {
                changeField = String.format("\u53d8\u66f4%s", annotation.value());
            }
            change.setChangeField(changeField);
            Object purfieldValue = ReflectUtils.getValue((Object)purItem, (String)fieldName);
            String purfieldValueString = purfieldValue == null ? "" : purfieldValue.toString().trim();
            if (purfieldValueString.equals(supfieldValueString = (supfieldValue = ReflectUtils.getValue((Object)supItem, (String)fieldName)) == null ? "" : supfieldValue.toString().trim())) continue;
            change.setOriginData(supfieldValueString);
            change.setChangedData(purfieldValueString);
            changeList.add(change);
        }
        PurchaseOrderChange isOfficalPrice = PurchaseOrderChangeUtils.buildChangeForIsOfficialPrice(purItem, supItem);
        if (isOfficalPrice != null) {
            changeList.add(isOfficalPrice);
        }
        return changeList;
    }

    public static PurchaseOrderChange buildChangeByPurOrderItem(PurchaseOrderItem purItem) {
        PurchaseOrderChange change = new PurchaseOrderChange();
        change.setOrderId(purItem.getOrderId());
        change.setOrderItemId(purItem.getId());
        change.setOrderNo(purItem.getOrderNo());
        change.setOrderItemNo(purItem.getOrderItemNo());
        change.setMaterialCode(purItem.getMaterialCode());
        change.setMaterialDesc(purItem.getMaterialName());
        change.setMaterialId(purItem.getMaterialId());
        change.setCreateTime(new Date());
        change.setPurUserId(purItem.getPurUserId());
        change.setPurUserName(purItem.getPurUserName());
        change.setProjectId(purItem.getProjectId());
        change.setConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        change.setSendStatus(PurchaseOrderSendStatusEnum.NOTSEND.getValue().toString());
        return change;
    }

    public static PurchaseOrderChange buildChangeByNewOrderItem(PurchaseOrderItem item) {
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(item);
        change.setChangeType(ChangeTypeEnum.ADD_ITEM.getValue());
        return change;
    }

    public static PurchaseOrderChange buildChangeByNewItem(PurchaseOrderItem purItem) {
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        change.setChangeType(ChangeTypeEnum.ADD_ITEM.getValue());
        change.setChangeField(ChangeTypeEnum.ADD_ITEM.getDesc());
        return change;
    }

    public static PurchaseOrderChange buildChangeForFinishFlag(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        if (purItem.getFinishFlag().equals(supItem.getFinishFlag())) {
            return null;
        }
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        if ("Y".equals(supItem.getFinishFlag()) && !"Y".equals(purItem.getFinishFlag())) {
            change.setChangeType(ChangeTypeEnum.OPEN_ITEM.getValue());
            change.setChangeField(ChangeTypeEnum.OPEN_ITEM.getDesc());
        }
        if (!"Y".equals(supItem.getFinishFlag()) && "Y".equals(purItem.getFinishFlag())) {
            change.setChangeType(ChangeTypeEnum.CANCEL_ITEM.getValue());
            change.setChangeField(ChangeTypeEnum.CANCEL_ITEM.getDesc());
        }
        return change;
    }

    public static PurchaseOrderChange buildChangeForIsEnable(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        if (supItem.getIsEnable().equals(purItem.getIsEnable())) {
            return null;
        }
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        if (PurchaseOrderIsEnableEnum.ENABLE.getValue().equals(supItem.getIsEnable()) && PurchaseOrderIsEnableEnum.DELETED.getValue().equals(purItem.getIsEnable())) {
            change.setChangeType(ChangeTypeEnum.DELETE_ITEM.getValue());
            change.setChangeField(ChangeTypeEnum.DELETE_ITEM.getDesc());
        }
        if (PurchaseOrderIsEnableEnum.ENABLE.getValue().equals(supItem.getIsEnable()) && PurchaseOrderIsEnableEnum.FREEZE.getValue().equals(purItem.getIsEnable())) {
            change.setChangeType(ChangeTypeEnum.FROZEN_ITEM.getValue());
            change.setChangeField(ChangeTypeEnum.FROZEN_ITEM.getDesc());
        }
        if (!PurchaseOrderIsEnableEnum.ENABLE.getValue().equals(supItem.getIsEnable()) && PurchaseOrderIsEnableEnum.ENABLE.getValue().equals(purItem.getIsEnable())) {
            change.setChangeType(ChangeTypeEnum.RECOVER_ITEM.getValue());
            change.setChangeField(ChangeTypeEnum.RECOVER_ITEM.getDesc());
        }
        return change;
    }

    public static PurchaseOrderChange buildChangeForQuantity(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        if (purItem.getQuantity().compareTo(supItem.getQuantity()) == 0) {
            return null;
        }
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        change.setChangeType(ChangeTypeEnum.MODIFY_ITEM.getValue());
        change.setChangeField(CHANGE_QUANTITY);
        change.setOriginData(supItem.getQuantity().toString());
        change.setChangedData(purItem.getQuantity().toString());
        return change;
    }

    public static PurchaseOrderChange buildChangeForPriceTaxTotal(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        if (purItem.getTaxUnitPrice() == null && supItem.getTaxUnitPrice() == null && purItem.getTaxTotalPrice() == null && supItem.getTaxTotalPrice() == null) {
            return null;
        }
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        change.setChangeType(ChangeTypeEnum.MODIFY_ITEM.getValue());
        if (purItem.getTaxUnitPrice() == null && supItem.getTaxUnitPrice() != null || purItem.getTaxUnitPrice() != null && supItem.getTaxUnitPrice() == null || purItem.getTaxUnitPrice().compareTo(supItem.getTaxUnitPrice()) != 0) {
            change.setChangeField(CHANGE_TAX_UNIT_PRICE);
            change.setOriginData(String.valueOf(supItem.getTaxUnitPrice()));
            change.setChangedData(String.valueOf(purItem.getTaxUnitPrice()));
            return change;
        }
        if (purItem.getTaxTotalPrice() == null && supItem.getTaxTotalPrice() != null || purItem.getTaxTotalPrice() != null && supItem.getTaxTotalPrice() == null || purItem.getTaxTotalPrice().compareTo(supItem.getTaxTotalPrice()) != 0) {
            change.setChangeField(CHANGE_TAX_TOTAL_PRICE);
            change.setOriginData(String.valueOf(supItem.getTaxTotalPrice()));
            change.setChangedData(String.valueOf(purItem.getTaxTotalPrice()));
            return change;
        }
        return null;
    }

    public static PurchaseOrderChange buildChangeForIsOfficialPrice(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        if (purItem.getIsOfficialPrice().equals(supItem.getIsOfficialPrice())) {
            return null;
        }
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        change.setChangeType(ChangeTypeEnum.MODIFY_ITEM.getValue());
        if (!purItem.getIsOfficialPrice().equals(supItem.getIsOfficialPrice())) {
            change.setChangeField(CHANGE_IS_OFFICAL_PRICE);
            change.setOriginData(Constant.YES_INT.equals(supItem.getIsOfficialPrice()) ? "\u5426" : "\u662f");
            change.setChangedData(Constant.YES_INT.equals(purItem.getIsOfficialPrice()) ? "\u5426" : "\u662f");
        }
        return change;
    }

    public static PurchaseOrderChange buildChangeForDeliveryDate(PurchaseOrderItem purItem, SupplierOrderItem supItem) {
        if (purItem.getDeliveredDate() == null && supItem.getDeliveredDate() == null) {
            return null;
        }
        if (purItem.getDeliveredDate() != null && supItem.getDeliveredDate() != null) {
            Date purItemDeliveryDate = DateUtils.truncate((Date)purItem.getDeliveredDate(), (int)5);
            Date supItemDeliveryDate = DateUtils.truncate((Date)supItem.getDeliveredDate(), (int)5);
            if (purItemDeliveryDate.getTime() == supItemDeliveryDate.getTime()) {
                return null;
            }
        }
        PurchaseOrderChange change = PurchaseOrderChangeUtils.buildChangeByPurOrderItem(purItem);
        change.setChangeType(ChangeTypeEnum.MODIFY_ITEM.getValue());
        change.setChangeField(CHAGE_DELIVERY_DATE);
        change.setChangedData(DateFormatUtils.format((Date)purItem.getDeliveredDate(), (String)"yyyy-MM-dd"));
        change.setOriginData(DateFormatUtils.format((Date)supItem.getDeliveredDate(), (String)"yyyy-MM-dd"));
        return change;
    }

    private PurchaseOrderChangeUtils() {
    }
}

