/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.common;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.utils.uuid.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="orderComandInvoker")
public class OrderCommandInvoker
implements ICommandInvoker {
    private static Logger logger = LoggerFactory.getLogger(OrderCommandInvoker.class);

    @Override
    @Transactional
    public <Result> Result invoke(AbstractCommand<Result> command) {
        command.setMdcId(UUIDGenerator.generateUUID());
        long t1 = System.currentTimeMillis();
        logger.debug("EVENT=\u5f00\u59cb\u6267\u884c\u547d\u4ee4|COMMAND={}|KEY={}", (Object)command.getClass().getName(), (Object)command.getMdcId());
        command.setContext(this);
        Result result = command.execute(this);
        logger.debug("EVENT=\u7ed3\u675f\u6267\u884c\u547d\u4ee4|COMMAND={}|KEY={}|COST={} ms", new Object[]{command.getClass().getName(), command.getMdcId(), System.currentTimeMillis() - t1});
        return result;
    }
}

