/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryPackage;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PreviewDelieryPackageCmd
extends AbstractCommand<List<DeliveryPackage>> {
    private static final long serialVersionUID = 1L;
    private List<DeliveryOrderItem> items;

    public PreviewDelieryPackageCmd(List<DeliveryOrderItem> items) {
        this.items = items;
    }

    @Override
    public List<DeliveryPackage> execute(ICommandInvoker context) {
        List<DeliveryPackage> packageList = this.items.stream().map(item -> this.complete((DeliveryOrderItem)item)).collect(Collectors.toList());
        Map<String, List<DeliveryPackage>> materialAndPackageList = packageList.stream().collect(Collectors.groupingBy(DeliveryPackage::getMaterialDesc));
        packageList = this.group(materialAndPackageList);
        return packageList;
    }

    private List<DeliveryPackage> group(Map<String, List<DeliveryPackage>> materialAndPackageList) {
        return materialAndPackageList.keySet().stream().map(materialDesc -> {
            List deliveryPackageList = (List)materialAndPackageList.get(materialDesc);
            DeliveryPackage deliveryPackage = (DeliveryPackage)deliveryPackageList.get(0);
            Integer totalQuantity = deliveryPackageList.stream().map(DeliveryPackage::getTotalQuantity).reduce(Integer::sum).orElseGet(() -> 0);
            deliveryPackage.setTotalQuantity(totalQuantity);
            return deliveryPackage;
        }).collect(Collectors.toList());
    }

    private DeliveryPackage complete(DeliveryOrderItem item) {
        DeliveryPackage deliveryPackage = new DeliveryPackage();
        deliveryPackage.setProjectId(item.getProjectId());
        deliveryPackage.setUserId(this.getSupUser().getId());
        deliveryPackage.setUserName(this.getSupUser().getNickName());
        deliveryPackage.setCompanyId(this.getSupCompany().getId());
        deliveryPackage.setCompanyName(this.getSupCompany().getCompanyFullName());
        deliveryPackage.setCompanyCode(item.getCompanyCode());
        deliveryPackage.setDeliveryOrderNo(item.getDeliveryOrderNo());
        deliveryPackage.setDeliveryQuantity(item.getDeliveredQuantity().intValue());
        deliveryPackage.setPackageQuantity(1);
        deliveryPackage.setTotalQuantity(item.getDeliveredQuantity().intValue());
        deliveryPackage.setMaterialId(item.getMaterialId());
        deliveryPackage.setMaterialDesc(item.getMaterialDesc());
        deliveryPackage.setOrderUnit(item.getOrderUnit());
        deliveryPackage.setHeight(BigDecimal.ZERO);
        deliveryPackage.setWidth(BigDecimal.ZERO);
        deliveryPackage.setLength(BigDecimal.ZERO);
        deliveryPackage.setGrossWeight(BigDecimal.ZERO);
        deliveryPackage.setVolume("0");
        return deliveryPackage;
    }
}

