/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.jit.plan.CreateJitChangeRecordCmd;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.google.common.collect.ArrayListMultimap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class DeleteJitPlanCommand
extends AbstractCommand {
    private List<DeliveryPlan> deletePlans;

    public DeleteJitPlanCommand(List<DeliveryPlan> deletePlans) {
        this.deletePlans = deletePlans;
    }

    public Object execute(ICommandInvoker context) {
        this.vaidUsedStatus(this.deletePlans);
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (DeliveryPlan plan : this.deletePlans) {
            String key2 = plan.getId();
            arrayListMultiMap.put((Object)key2, (Object)plan);
        }
        Set keySet = arrayListMultiMap.keySet();
        List deleteDeliveryPlan = keySet.stream().map(key -> {
            List plans = arrayListMultiMap.get(key);
            DeliveryPlan deliveryPlan = (DeliveryPlan)plans.get(0);
            if (plans.size() == 1 && ((DeliveryPlan)plans.get(0)).getIsAllocated() == 0) {
                deliveryPlan.setIsEnable(Constant.NO_INT);
                ContextUtils.getDeliveryPlanService().modifyObj(deliveryPlan);
            } else {
                BigDecimal deleteQuantity = plans.stream().map(plan -> plan.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
                List<String> deleteItemIds = plans.stream().map(plan -> plan.getItemId()).collect(Collectors.toList());
                if (deleteQuantity.compareTo(deliveryPlan.getConsumeMunber()) < 0 && this.getItemNum(plans).booleanValue()) {
                    deliveryPlan.setConsumeMunber(deliveryPlan.getConsumeMunber().subtract(deleteQuantity));
                } else {
                    deliveryPlan.setConsumeMunber(BigDecimal.ZERO);
                    deliveryPlan.setIsEnable(Constant.NO_INT);
                }
                this.deletePlanAndPlanItem(deliveryPlan, deleteItemIds);
            }
            return deliveryPlan;
        }).collect(Collectors.toList());
        List itemIds = this.deletePlans.stream().filter(deliveryPlan -> deliveryPlan.getItemId() != null).map(deliveryPlan -> deliveryPlan.getItemId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemIds)) {
            SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
            supExample.createCriteria().andIdIn(itemIds);
            List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)supExample);
            if (CollectionUtils.isNotEmpty((Collection)lists)) {
                CreateJitChangeRecordCmd command = new CreateJitChangeRecordCmd(lists);
                context.invoke(command);
            }
        }
        return null;
    }

    private void vaidUsedStatus(List<DeliveryPlan> deletePlans) {
        deletePlans.stream().forEach(plan -> {
            SupDeliveryPlanItem item;
            if (StringUtils.isNotBlank((String)plan.getItemId()) && (item = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(plan.getItemId())) != null && item.getCanDeliveryQuantity() != null && item.getCanDeliveryQuantity().compareTo(item.getDeliveryQuantity()) != 0) {
                throw new CommonException("\u5de5\u5382\u4ee3\u7801\uff1a" + plan.getFactoryCode() + "\uff0c\u7269\u6599\u7f16\u7801\uff1a" + plan.getMaterialCode() + "\uff0c\u8981\u6c42\u9001\u8fbe\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)plan.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\uff0c\u5b58\u5728\u53d1\u8d27\u5355\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        });
    }

    private void deletePlanAndPlanItem(DeliveryPlan deliveryPlan, List<String> ids) {
        ContextUtils.getDeliveryPlanService().modifyObj(deliveryPlan);
        ContextUtils.getSupDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), deliveryPlan.getConsumeMunber());
        ContextUtils.getPurDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), deliveryPlan.getConsumeMunber());
        SupDeliveryPlanItem supDeliveryPlanItem = new SupDeliveryPlanItem();
        supDeliveryPlanItem.setIsEnable(Constant.NO_INT);
        SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
        supExample.createCriteria().andIdIn((List)ids);
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supDeliveryPlanItem, supExample);
        PurDeliveryPlanItem purDeliveryPlanItem = new PurDeliveryPlanItem();
        purDeliveryPlanItem.setIsEnable(Constant.NO_INT);
        PurDeliveryPlanItemExample purExample = new PurDeliveryPlanItemExample();
        purExample.createCriteria().andIdIn((List)ids);
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purDeliveryPlanItem, purExample);
    }

    private Boolean getItemNum(List<DeliveryPlan> plans) {
        int itemNum;
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPlanIdEqualTo(plans.get(0).getId());
        List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        int n = itemNum = lists == null ? 0 : lists.size();
        if (itemNum - plans.size() > 0) {
            return true;
        }
        return false;
    }
}

