/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.plan.command.jit.plan.CreateJitChangeRecordCmd;
import com.els.base.plan.command.jit.planItem.ModifyItemByImportCommand;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.JitPlanUtils;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.utils.UserOrganizationUtils;
import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class ImportJitPlanCommand
extends AbstractCommand {
    private List<SupDeliveryPlanItem> itemList;
    private List<String> roleCodes;

    public ImportJitPlanCommand(List<SupDeliveryPlanItem> itemList, List<String> roleCodes) {
        this.itemList = itemList;
        this.roleCodes = roleCodes;
    }

    public Object execute(ICommandInvoker context) {
        this.init(this.itemList);
        this.vaidFactory(this.itemList);
        this.vaidIsJit(this.itemList);
        List<SupDeliveryPlanItem> lists = this.mergerItems(this.itemList);
        this.vaidIsUsed(lists);
        lists = this.exclusionCoveragePlan(lists);
        if (CollectionUtils.isEmpty(lists)) {
            return null;
        }
        this.vaidDistributableNum(lists);
        List<DeliveryPlan> deliveryPlans = this.mergerPlanItem(lists);
        ArrayList<SupDeliveryPlanItem> itemLog = new ArrayList<SupDeliveryPlanItem>();
        deliveryPlans.stream().forEach(deliveryPlan -> {
            if (StringUtils.isNotBlank((String)deliveryPlan.getId())) {
                ContextUtils.getDeliveryPlanService().modifyObj((Serializable)deliveryPlan);
            } else {
                ContextUtils.getDeliveryPlanService().addObj((Serializable)deliveryPlan);
            }
            if (CollectionUtils.isNotEmpty(deliveryPlan.getPlanItemList())) {
                itemLog.addAll(deliveryPlan.getPlanItemList());
            }
        });
        if (CollectionUtils.isNotEmpty(itemLog)) {
            CreateJitChangeRecordCmd command = new CreateJitChangeRecordCmd(itemLog);
            context.invoke(command);
        }
        deliveryPlans.stream().forEach(deliveryPlan -> {
            if (CollectionUtils.isNotEmpty(deliveryPlan.getPlanItemList())) {
                ModifyItemByImportCommand planItemCmd = new ModifyItemByImportCommand((DeliveryPlan)deliveryPlan);
                planItemCmd.copyProperties(this);
                context.invoke(planItemCmd);
            }
        });
        return null;
    }

    private void vaidFactory(List<SupDeliveryPlanItem> itemList) {
        List factorys = itemList.stream().map(SupDeliveryPlanItem::getFactoryCode).distinct().collect(Collectors.toList());
        List factoryCodeList = UserOrganizationUtils.getUserFactoryCode((String)this.getPurUser().getId());
        if (CollectionUtils.isEmpty(this.roleCodes) || !this.roleCodes.contains("systemManager")) {
            Assert.isNotEmpty((Collection)factoryCodeList, (String)"\u5bfc\u5165\u5931\u8d25\uff1a\u8d26\u53f7\u672a\u5206\u914d\u5de5\u5382\u6743\u9650");
            factorys.stream().forEach(factory -> {
                if (!factoryCodeList.contains(factory)) {
                    throw new CommonException(MessageFormat.format("\u5bfc\u5165\u5931\u8d25\uff1a\u8d26\u53f7\u672a\u5206\u914d{0}\u5de5\u5382\u6743\u9650", factory));
                }
            });
        }
    }

    private void vaidIsJit(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String planKey = planItem.getFactoryCode() + planItem.getMaterialNo();
            arrayListMultiMap.put((Object)planKey, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(quotaKey -> {
            List planItems = arrayListMultiMap.get(quotaKey);
            String jitItem = JitPlanUtils.getMaterialJitItem(((SupDeliveryPlanItem)planItems.get(0)).getMaterialNo(), ((SupDeliveryPlanItem)planItems.get(0)).getFactoryCode());
            planItems.stream().forEach(item -> item.setJitItem(jitItem));
        });
    }

    private void vaidIsUsed(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String planKey = planItem.getFactoryCode() + planItem.getMaterialNo() + planItem.getDeliveryDate() + planItem.getSupCompanySapCode();
            arrayListMultiMap.put((Object)planKey, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(quotaKey -> {
            List planItems = arrayListMultiMap.get(quotaKey);
            SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
            example.createCriteria().andFactoryCodeEqualTo(((SupDeliveryPlanItem)planItems.get(0)).getFactoryCode()).andMaterialNoEqualTo(((SupDeliveryPlanItem)planItems.get(0)).getMaterialNo()).andDeliveryDateEqualTo(((SupDeliveryPlanItem)planItems.get(0)).getDeliveryDate()).andUsedStatusEqualTo("Y").andSupCompanyIdEqualTo(((SupDeliveryPlanItem)planItems.get(0)).getSupCompanySapCode());
            List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)lists)) {
                throw new CommonException("\u5bfc\u5165\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + ((SupDeliveryPlanItem)planItems.get(0)).getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + ((SupDeliveryPlanItem)planItems.get(0)).getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)((SupDeliveryPlanItem)planItems.get(0)).getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u5df2\u5168\u90e8\u53d1\u8d27");
            }
        });
    }

    private void vaidDistributableNum(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String orderKey2 = planItem.getSupCompanySapCode() + "," + planItem.getFactoryCode() + "," + planItem.getMaterialNo();
            arrayListMultiMap.put((Object)orderKey2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(orderKey -> {
            List planItems = arrayListMultiMap.get(orderKey);
            BigDecimal quantityTatol = planItems.stream().map(item -> item.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
            if (quantityTatol.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            BigDecimal undistributNum = JitPlanUtils.getUndistributNum(orderKey.split(",")[0], orderKey.split(",")[1], orderKey.split(",")[2], ((SupDeliveryPlanItem)arrayListMultiMap.get(orderKey).get(0)).getSupCompanyName());
            BigDecimal CoverNum = this.getCoverNum(planItems);
            BigDecimal num = undistributNum.add(CoverNum);
            BigDecimal[] nums = new BigDecimal[]{num};
            planItems.stream().forEach(planItem -> {
                if (planItem.getDeliveryQuantity().compareTo(nums[0]) > 0) {
                    throw new CommonException("\u5bfc\u5165\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + orderKey.split(",")[1] + "\u7269\u6599\u7f16\u7801\uff1a" + orderKey.split(",")[2] + "\u4f9b\u5e94\u5546\uff1a" + ((SupDeliveryPlanItem)arrayListMultiMap.get(orderKey).get(0)).getSupCompanyName() + "\u5206\u914d\u91cf\u5927\u4e8e\u53ef\u5206\u914d\u6570\u91cf\uff08" + num.toString() + "\uff09");
                }
                nums[0] = nums[0].subtract(planItem.getDeliveryQuantity());
            });
        });
    }

    private BigDecimal getCoverNum(List<SupDeliveryPlanItem> planItems) {
        List<Date> dateList = planItems.stream().map(item -> item.getDeliveryDate()).collect(Collectors.toList());
        SupDeliveryPlanItem item2 = planItems.get(0);
        BigDecimal num = ContextUtils.getSupDeliveryPlanItemService().getCoverNum(item2.getSupCompanySapCode(), item2.getMaterialNo(), item2.getFactoryCode(), dateList);
        return num;
    }

    private List<DeliveryPlan> mergerPlanItem(List<SupDeliveryPlanItem> itemList) {
        ArrayList<DeliveryPlan> deliveryPlans = new ArrayList<DeliveryPlan>();
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String planKey = planItem.getFactoryCode() + planItem.getMaterialNo() + planItem.getDeliveryDate();
            arrayListMultiMap.put((Object)planKey, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(quotaKey -> {
            List planItems = arrayListMultiMap.get(quotaKey);
            DeliveryPlan plan = this.buildPlan(planItems);
            deliveryPlans.add(plan);
        });
        return deliveryPlans;
    }

    private DeliveryPlan buildPlan(List<SupDeliveryPlanItem> planItems) {
        List exitList = planItems.stream().map(item -> this.getSupDeliveryPlanItem((SupDeliveryPlanItem)item)).filter(item -> item != null).collect(Collectors.toList());
        BigDecimal quantity = planItems.stream().map(supDeliveryPlanItem -> supDeliveryPlanItem.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
        DeliveryPlan plan = null;
        if (CollectionUtils.isNotEmpty(exitList)) {
            BigDecimal exitQuantity = exitList.stream().map(supDeliveryPlanItem -> supDeliveryPlanItem.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
            plan = (DeliveryPlan)ContextUtils.getDeliveryPlanService().queryObjById(((SupDeliveryPlanItem)exitList.get(0)).getPlanId());
            plan.setConsumeMunber(plan.getConsumeMunber().add(quantity).subtract(exitQuantity));
            plan.setPlanItemList(planItems);
        } else {
            plan = this.getplan(planItems.get(0).getFactoryCode(), planItems.get(0).getMaterialNo(), planItems.get(0).getDeliveryDate());
            if (plan != null) {
                plan.setConsumeMunber(plan.getConsumeMunber().add(quantity));
                plan.setPlanItemList(planItems);
            } else {
                plan = new DeliveryPlan();
                plan.setArryvalTime(planItems.get(0).getDeliveryDate());
                plan.setConsumeMunber(quantity);
                plan.setStatus(Constant.NO_INT);
                plan.setIsEnable(Constant.YES_INT);
                if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                    plan.setIsEnable(Constant.NO_INT);
                }
                plan.setCreateTime(new Date());
                plan.setLastUpdateTime(new Date());
                plan.setPurUserId(this.getPurUser().getId());
                plan.setPurUserName(this.getPurUser().getNickName());
                plan.setFactoryCode(planItems.get(0).getFactoryCode());
                plan.setFactoryName(planItems.get(0).getFactoryName());
                plan.setMaterialCode(planItems.get(0).getMaterialNo());
                plan.setMaterialDescride(planItems.get(0).getMaterialDesc());
                plan.setMaterialGroup(planItems.get(0).getMaterialGroup());
                plan.setExternalMaterialGroup(planItems.get(0).getExternalMaterialGroup());
                plan.setUnit(planItems.get(0).getOrderUnit());
                plan.setIsLock("N");
                plan.setJitItem(planItems.get(0).getJitItem());
                plan.setPlanItemList(planItems);
                plan.setUsedStatus("N");
            }
        }
        if (BigDecimal.ZERO.compareTo(plan.getConsumeMunber()) >= 0) {
            plan.setIsEnable(Constant.NO_INT);
        } else {
            plan.setIsEnable(Constant.YES_INT);
        }
        return plan;
    }

    private DeliveryPlan getplan(String factoryCode, String materialNo, Date deliveryDate) {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.createCriteria().andMaterialCodeEqualTo(materialNo).andFactoryCodeEqualTo(factoryCode).andArryvalTimeEqualTo(deliveryDate).andIsEnableEqualTo(Constant.YES_INT);
        List plans = ContextUtils.getDeliveryPlanService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)plans)) {
            return (DeliveryPlan)plans.get(0);
        }
        return null;
    }

    private SupDeliveryPlanItem getSupDeliveryPlanItem(SupDeliveryPlanItem item) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andMaterialNoEqualTo(item.getMaterialNo()).andFactoryCodeEqualTo(item.getFactoryCode()).andDeliveryDateEqualTo(item.getDeliveryDate()).andIsEnableEqualTo(Constant.YES_INT).andIsJitEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(item.getSupCompanySapCode());
        List items = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        items.stream().forEach(i -> {
            if (DeliveryPlanUesdStatusEnum.PART_USED.getValue().equals(i.getUsedStatus()) || DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(i.getUsedStatus())) {
                item.setId(i.getId());
                if (item.getDeliveryQuantity().compareTo(i.getOnwayQuantity().add(i.getReceivedQuantity())) > 0) {
                    item.setUsedStatus(DeliveryPlanUesdStatusEnum.PART_USED.getValue());
                    item.setIsCanDelivery(Constant.YES_INT);
                }
                if (item.getDeliveryQuantity().compareTo(i.getOnwayQuantity().add(i.getReceivedQuantity())) == 0) {
                    item.setUsedStatus(DeliveryPlanUesdStatusEnum.ALL_USED.getValue());
                    item.setIsCanDelivery(Constant.NO_INT);
                }
                if (item.getDeliveryQuantity().compareTo(i.getOnwayQuantity().add(i.getReceivedQuantity())) < 0) {
                    throw new CommonException("\u5bfc\u5165\u5931\u8d25\uff1b\u5de5\u5382\u4ee3\u7801\uff1a" + i.getFactoryCode() + "\u7269\u6599\u7f16\u7801\uff1a" + i.getMaterialNo() + "\u8981\u6c42\u5230\u8d27\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)i.getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + "\u5206\u914d\u6570\u91cf\u5c0f\u4e8e\u5df2\u53d1\u8d27\u6570\u91cf");
                }
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            return (SupDeliveryPlanItem)items.get(0);
        }
        return null;
    }

    private List<SupDeliveryPlanItem> mergerItems(List<SupDeliveryPlanItem> list) {
        ArrayList<SupDeliveryPlanItem> items = new ArrayList<SupDeliveryPlanItem>();
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : list) {
            String key2 = planItem.getFactoryCode() + planItem.getMaterialNo() + planItem.getDeliveryDate() + planItem.getSupCompanySapCode();
            arrayListMultiMap.put((Object)key2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(key -> {
            List planItems = arrayListMultiMap.get(key);
            SupDeliveryPlanItem item = (SupDeliveryPlanItem)planItems.get(0);
            if (planItems.size() > 1) {
                BigDecimal consumeQuantity = planItems.stream().map(supDeliveryPlanItem -> supDeliveryPlanItem.getDeliveryQuantity()).reduce((x, y) -> x.add((BigDecimal)y)).get();
                if (consumeQuantity.compareTo(BigDecimal.ZERO) == 0) {
                    item.setIsEnable(Constant.NO_INT);
                }
                item.setDeliveryQuantity(consumeQuantity);
            }
            items.add(item);
        });
        return items;
    }

    private void init(List<SupDeliveryPlanItem> itemList) {
        this.initFactory(itemList);
        this.initMaterial(itemList);
        this.initSupCompany(itemList);
    }

    private void initSupCompany(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String supCompanyName2 = planItem.getSupCompanyName();
            arrayListMultiMap.put((Object)supCompanyName2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(supCompanyName -> {
            CompanySapRelationExample example = new CompanySapRelationExample();
            example.createCriteria().andCompanyNameEqualTo(supCompanyName);
            List lists = ContextUtils.getCompanySapRelationService().queryAllObjByExample((IExample)example);
            if (lists.size() != 1) {
                throw new CommonException("\u4f9b\u5e94\u5546\u7b80\u79f0<" + supCompanyName + ">\u9519\u8bef");
            }
            CompanySapRelation companySapRelation = (CompanySapRelation)lists.get(0);
            arrayListMultiMap.get(supCompanyName).stream().forEach(planItem -> {
                planItem.setSupCompanyId(companySapRelation.getCompanyId());
                planItem.setSupCompanyName((String)supCompanyName);
                planItem.setSupCompanySapCode(companySapRelation.getCompanySapCode());
                planItem.setSupCompanySrmCode(companySapRelation.getCompanyCode());
            });
        });
    }

    private void initMaterial(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String materialCode2 = planItem.getMaterialNo();
            arrayListMultiMap.put((Object)materialCode2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(materialCode -> {
            MaterialExample example = new MaterialExample();
            example.createCriteria().andMaterialCodeEqualTo(materialCode);
            List lists = ContextUtils.getMaterialService().queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)lists, (String)("\u7269\u6599\u7f16\u7801<" + materialCode + ">\u4e0d\u5b58\u5728"));
            Material material = (Material)lists.get(0);
            arrayListMultiMap.get(materialCode).stream().forEach(planItem -> {
                planItem.setMaterialId(material.getId());
                planItem.setMaterialDesc(material.getDescription());
                planItem.setMaterialGroup(material.getMaterialGroup());
                planItem.setExternalMaterialGroup(material.getExternalMaterialGroup());
                planItem.setOrderUnit(material.getBasicUnit());
            });
        });
    }

    private void initFactory(List<SupDeliveryPlanItem> itemList) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (SupDeliveryPlanItem planItem : itemList) {
            String factoryCode2 = planItem.getFactoryCode();
            arrayListMultiMap.put((Object)factoryCode2, (Object)planItem);
        }
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(factoryCode -> {
            OrganizationExample example = new OrganizationExample();
            example.createCriteria().andCodeEqualTo(factoryCode).andOrganizationTypeEqualTo("T001W");
            List lists = ContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)lists, (String)("\u5de5\u5382\u4ee3\u7801<" + factoryCode + ">\u4e0d\u5b58\u5728"));
            arrayListMultiMap.get(factoryCode).stream().forEach(planItem -> planItem.setFactoryName(((Organization)lists.get(0)).getDescription()));
        });
    }

    private List<SupDeliveryPlanItem> exclusionCoveragePlan(List<SupDeliveryPlanItem> lists) {
        List<SupDeliveryPlanItem> planItems = lists.stream().map(item -> {
            if (!this.isOver((SupDeliveryPlanItem)item).booleanValue()) {
                return item;
            }
            return null;
        }).filter(item -> item != null).collect(Collectors.toList());
        return planItems;
    }

    private Boolean isOver(SupDeliveryPlanItem item) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andMaterialNoEqualTo(item.getMaterialNo()).andFactoryCodeEqualTo(item.getFactoryCode()).andDeliveryDateEqualTo(item.getDeliveryDate()).andIsEnableEqualTo(Constant.YES_INT).andDeliveryQuantityEqualTo(item.getDeliveryQuantity()).andIsJitEqualTo(Constant.YES_INT).andSupCompanySapCodeEqualTo(item.getSupCompanySapCode());
        List items = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            this.logger.debug("\u5b58\u5728\u91cd\u590d\u7684\u4ea4\u8d27\u8ba1\u5212company={}|factory={}|material={}|DeliveryDate={}", new Object[]{item.getSupCompanySapCode(), item.getFactoryCode(), item.getMaterialNo(), DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd hh:MM:ss")});
            return true;
        }
        return false;
    }
}

