/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.plan.command.jit.merge.CreateJITDemandMergeCommand;
import com.els.base.plan.command.jit.merge.DeleteJITDemandMergeCommand;
import com.els.base.plan.command.jit.merge.GetJITDemandMergeCommand;
import com.els.base.plan.command.jit.merge.ModifyJITDemandMergeCommand;
import com.els.base.plan.entity.JITDemandMerge;
import com.els.base.plan.entity.JITDemandMergeExample;
import com.els.base.plan.service.JITDemandMergeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="JIT\u9700\u6c42\u5408\u5e76\u8868")
@Controller
@RequestMapping(value={"jITDemandMerge"})
public class JITDemandMergeController {
    @Resource
    private OrderCommandInvoker invoker;
    @Resource
    protected JITDemandMergeService jITDemandMergeService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaJIT\u9700\u6c42\u5408\u5e76\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody JITDemandMerge jITDemandMerge) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        jITDemandMerge.setCreateTime(new Date());
        jITDemandMerge.setCreateUserId(loginUser.getId());
        jITDemandMerge.setCreateUserName(loginUser.getNickName());
        jITDemandMerge.setUpdateTime(new Date());
        jITDemandMerge.setUpdateUserId(loginUser.getId());
        jITDemandMerge.setUpdateUserName(loginUser.getNickName());
        CreateJITDemandMergeCommand command = new CreateJITDemandMergeCommand(jITDemandMerge);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91JIT\u9700\u6c42\u5408\u5e76\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody JITDemandMerge jITDemandMerge) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        jITDemandMerge.setUpdateTime(new Date());
        jITDemandMerge.setUpdateUserId(loginUser.getId());
        jITDemandMerge.setUpdateUserName(loginUser.getNickName());
        ModifyJITDemandMergeCommand command = new ModifyJITDemandMergeCommand(jITDemandMerge);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664JIT\u9700\u6c42\u5408\u5e76\u8868")
    @RequestMapping(value={"service/deleteByfactoryCodes"})
    @ResponseBody
    public ResponseResult<String> deleteByfactoryCodes(@RequestBody List<String> factoryCodes) {
        Assert.isNotEmpty(factoryCodes, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteJITDemandMergeCommand command = new DeleteJITDemandMergeCommand(factoryCodes);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2JIT\u9700\u6c42\u5408\u5e76\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 JITDemandMerge", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<JITDemandMerge>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        JITDemandMergeExample example = new JITDemandMergeExample();
        example.setOrderByClause("FACTORY_CODE,TO_CHAR(START_TIME, 'hh24:mi:ss') ASC");
        example.setPageView((PageView<JITDemandMerge>)new PageView(pageNo, pageSize));
        JITDemandMergeExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.jITDemandMergeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6JIT\u9700\u6c42\u5408\u5e76\u8868:\u6839\u636e\u7269\u6599\u7f16\u53f7\u548c\u5de5\u5382\u7f16\u53f7")
    @RequestMapping(value={"service/getJITDemandMerge"})
    @ResponseBody
    public ResponseResult<JITDemandMerge> getJITDemandMerge(@RequestParam(required=true) String factoryCode) {
        Assert.isNotBlank((String)factoryCode, (String)"\u83b7\u53d6\u5931\u8d25\uff0c\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        GetJITDemandMergeCommand command = new GetJITDemandMergeCommand(factoryCode);
        JITDemandMerge merge = this.invoker.invoke(command);
        return ResponseResult.success((Object)merge);
    }
}

