/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.plan.command.jit.CompositeDataCommand;
import com.els.base.plan.command.jit.plan.CreateJitPlanCommand;
import com.els.base.plan.command.jit.plan.DeleteJitPlanCommand;
import com.els.base.plan.command.jit.plan.ImportJitPlanCommand;
import com.els.base.plan.command.jit.plan.JITIsLockCommand;
import com.els.base.plan.command.jit.plan.ModifyJitPlanCommand;
import com.els.base.plan.command.jit.plan.SendJitPlanCommand;
import com.els.base.plan.command.jit.planItem.CloseJitPlanItemAndOrderItemCommand;
import com.els.base.plan.command.jit.planItem.CloseJitPlanItemCommand;
import com.els.base.plan.command.jit.planItem.CreateJitPlanItemCommand;
import com.els.base.plan.entity.DeliveryChangePlan;
import com.els.base.plan.entity.DeliveryChangePlanExample;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.JITSupRef;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.service.DeliveryChangePlanService;
import com.els.base.plan.service.DeliveryPlanService;
import com.els.base.plan.service.PurDeliveryPlanItemService;
import com.els.base.plan.service.SupDeliveryPlanItemService;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.JITDeliveryPlanHeadExeclUtil;
import com.els.base.plan.utils.JitPlanImportUtilsCp;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import com.els.liby.organization.utils.UserOrganizationUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="JIT\u4ea4\u8d27\u8ba1\u5212")
@RestController
@RequestMapping(value={"JitPlan"})
public class JITPlanController {
    private static final Logger logger = LoggerFactory.getLogger(JITPlanController.class);
    @Resource
    protected SupDeliveryPlanItemService supDeliveryPlanItemService;
    @Resource
    protected PurDeliveryPlanItemService purDeliveryPlanItemService;
    @Resource
    protected DeliveryPlanService deliveryPlanService;
    @Resource
    protected DeliveryChangePlanService deliveryChangePlanService;
    @Resource
    private OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2JIT\u53d1\u8d27\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryPlan", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryPlan>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.setOrderByClause("USED_STATUS ASC, ARRYVAL_TIME ASC");
        example.setPageView((PageView<DeliveryPlan>)new PageView(pageNo, pageSize));
        DeliveryPlanExample.Criteria criteria = example.createCriteria();
        List roleCodes = SpringSecurityUtils.getLoginUserRoleList().stream().map(Role::getRoleCode).distinct().collect(Collectors.toList());
        if (!roleCodes.contains("systemManager")) {
            List factoryCodes = UserOrganizationUtils.getUserFactoryCode((String)SpringSecurityUtils.getLoginUserId());
            Assert.isNotEmpty((Collection)factoryCodes, (String)"\u8d26\u53f7\u672a\u5206\u914d\u5de5\u5382\u6743\u9650");
            criteria.andFactoryCodeIn(factoryCodes);
        }
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<DeliveryPlan> pageData = this.deliveryPlanService.queryPlanAndItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2JIT\u9001\u8d27\u8ba1\u5212\u884c(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupDeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupDeliveryPlanItem>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setPageView((PageView<SupDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("DELIVERY_DATE ASC");
        Company currentCompany = CompanyUtils.currentCompany();
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPlanSendStatusEqualTo("Y");
        criteria.andSupCompanySapCodeIn(currentCompany.getCompanySapCodeList());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supDeliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6APS\u7269\u6599\u9700\u6c42\u6570\u636e")
    @RequestMapping(value={"service/getApsMaterial"})
    @ResponseBody
    public ResponseResult<String> getApsMaterial() {
        this.deliveryPlanService.getDeliveryPlan();
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaJIT\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DeliveryPlan deliveryPlan) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        CreateJitPlanCommand command = new CreateJitPlanCommand(deliveryPlan);
        command.setPurUser((com.els.base.core.entity.user.User)loginUser);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91JIT\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DeliveryPlan deliveryPlan) {
        Assert.isNotBlank((String)deliveryPlan.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyJitPlanCommand command = new ModifyJitPlanCommand(deliveryPlan);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664JIT\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/deleteByPlans"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<DeliveryPlan> deliveryPlans) {
        Assert.isNotEmpty(deliveryPlans, (String)"\u5220\u9664\u5931\u8d25,\u52fe\u9009\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteJitPlanCommand command = new DeleteJitPlanCommand(deliveryPlans);
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9501\u5b9a\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/lockPlan"})
    @ResponseBody
    public ResponseResult<String> lockPlan(@RequestBody List<String> ids) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        JITIsLockCommand command = new JITIsLockCommand(ids, true);
        command.setSupUser((com.els.base.core.entity.user.User)loginUser);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u89e3\u9501\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/unlockPlan"})
    @ResponseBody
    public ResponseResult<String> unlockPlan(@RequestBody List<String> ids) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        JITIsLockCommand command = new JITIsLockCommand(ids, false);
        command.setSupUser((com.els.base.core.entity.user.User)loginUser);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u7f16\u7801\u548c\u5de5\u5382\u4ee3\u7801\u548c\u4ea4\u8d27\u65e5\u671f\uff08\u53ef\u9009\uff09\u67e5\u627e\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/getSupByMaterialAndFactory"})
    @ResponseBody
    public ResponseResult<List<JITSupRef>> getSupByMaterialAndFactory(@RequestParam String materialCode, @RequestParam String factoryCode, String planId) {
        List<Object> datas = new ArrayList();
        if (!StringUtils.isBlank((String)planId) && !this.deliveryPlanService.isCanDistribute(planId)) {
            throw new CommonException("\u5df2\u5206\u914d\u5b8c\u4e14\u53d1\u9001\uff0c\u4e0d\u53ef\u5206\u914d");
        }
        CompositeDataCommand command = new CompositeDataCommand(materialCode, factoryCode, planId);
        datas = this.invoker.invoke(command);
        return ResponseResult.success(datas);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u914d\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/saveSup"})
    @ResponseBody
    public ResponseResult<String> saveSup(@RequestBody DeliveryPlan deliveryPlan) {
        CreateJitPlanItemCommand command = new CreateJitPlanItemCommand(deliveryPlan);
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2JIT\u4ea4\u8d27\u8ba1\u5212\u53d8\u66f4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryChangePlan", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForChangePur"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryChangePlan>> findChangeByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryChangePlanExample example = new DeliveryChangePlanExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.setPageView((PageView<DeliveryChangePlan>)new PageView(pageNo, pageSize));
        DeliveryChangePlanExample.Criteria criteria = example.createCriteria();
        Company company = CompanyUtils.currentCompany();
        criteria.andSupCompanyIdEqualTo(company.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryChangePlanService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/sendPlan"})
    @ResponseBody
    public ResponseResult<String> sendPlan(@RequestBody List<String> ids) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        SendJitPlanCommand command = new SendJitPlanCommand(ids);
        command.setSupUser((com.els.base.core.entity.user.User)loginUser);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u4ea4\u8d27\u8ba1\u5212\u4fe1\u606f\uff0c\u5bfc\u51faExcel\uff08\u91c7\u8d2d\u65b9\uff09", httpMethod="GET")
    @RequestMapping(value={"service/pur/exportPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> purExportPlan(@RequestParam(required=false) String queryParams, @RequestParam(required=false) String planIdList, HttpServletRequest request, HttpServletResponse response) throws IOException {
        QueryParamWapper wapper = null;
        if (StringUtils.isNotBlank((String)queryParams)) {
            wapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
        }
        List deliveryPlanList = new ArrayList();
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.setOrderByClause("CREATE_TIME DESC");
        DeliveryPlanExample.Criteria criteria = example.createCriteria();
        List roleCodes = SpringSecurityUtils.getLoginUserRoleList().stream().map(Role::getRoleCode).distinct().collect(Collectors.toList());
        if (!roleCodes.contains("systemManager")) {
            List factoryCodes = UserOrganizationUtils.getUserFactoryCode((String)SpringSecurityUtils.getLoginUserId());
            Assert.isNotEmpty((Collection)factoryCodes, (String)"\u8d26\u53f7\u672a\u5206\u914d\u5de5\u5382\u6743\u9650");
            criteria.andFactoryCodeIn(factoryCodes);
        }
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (StringUtils.isNotBlank((String)planIdList)) {
            criteria.andIdIn((List)Arrays.asList(planIdList.split(",")));
        }
        deliveryPlanList = this.deliveryPlanService.queryAllPlanAndItem(example).getQueryResult();
        boolean isPur = true;
        List<TitleAndModelKey> titleAndModelKeys = JITDeliveryPlanHeadExeclUtil.getTitleAndModelKeys(isPur);
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        this.setDownLoadHeader(response, MessageFormat.format("jit\u9001\u8d27\u901a\u77e5\u5355-{0}.xls", dateStr));
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, deliveryPlanList, (String)"jit\u9001\u8d27\u901a\u77e5\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        return null;
    }

    @ApiOperation(httpMethod="GET", value="\u4e0b\u8f7d\u65b0\u5efa\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(value={"service/exportJitPlanTemplateFile"})
    @ResponseBody
    public void exportJitPlanTemplateFile(HttpServletResponse response, HttpServletRequest request) throws IOException {
        response.reset();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("template/product.xlsx");
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("jit\u9001\u8d27\u901a\u77e5\u5355\u65b0\u5efa\u6a21\u677f.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        BufferedInputStream fis = new BufferedInputStream(in);
        byte[] buffer = new byte[((InputStream)fis).available()];
        ((InputStream)fis).read(buffer);
        ((InputStream)fis).close();
        BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)toClient).write(buffer);
        ((OutputStream)toClient).flush();
        ((OutputStream)toClient).close();
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7excel\u5bfc\u5165\u65b0\u5efa\u9001\u8d27\u901a\u77e5\u5355")
    @ResponseBody
    @RequestMapping(value={"service/importNewJitPlanByExcel"})
    public ResponseResult<String> importNewJitPlanByExcel(MultipartFile file) {
        if (file != null && file.getSize() > 0x100000L) {
            throw new CommonException("excel\u6587\u4ef6\u5927\u4e8e1M");
        }
        Company company = CompanyUtils.currentCompany();
        List<SupDeliveryPlanItem> supDeliveryPlanItems = JitPlanImportUtilsCp.importJITExcelDataToMap(file, company);
        List<String> roleCodes = SpringSecurityUtils.getLoginUserRoleList().stream().map(Role::getRoleCode).distinct().collect(Collectors.toList());
        ImportJitPlanCommand command = new ImportJitPlanCommand(supDeliveryPlanItems, roleCodes);
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u6240\u6709\u90e8\u5206\u53d1\u8d27\u7684\u91c7\u8d2d\u8ba2\u5355")
    @ResponseBody
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 purDeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPageByPart"})
    public ResponseResult<PageView<PurDeliveryPlanItem>> findByPageByPart(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.setPageView((PageView<PurDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("DELIVERY_DATE ASC");
        PurDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        List roleCodes = SpringSecurityUtils.getLoginUserRoleList().stream().map(Role::getRoleCode).distinct().collect(Collectors.toList());
        if (!roleCodes.contains("systemManager")) {
            List factoryCodes = UserOrganizationUtils.getUserFactoryCode((String)SpringSecurityUtils.getLoginUserId());
            Assert.isNotEmpty((Collection)factoryCodes, (String)"\u8d26\u53f7\u672a\u5206\u914d\u5de5\u5382\u6743\u9650");
            criteria.andFactoryCodeIn(factoryCodes);
        }
        criteria.andIsJitEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andUsedStatusIn((List)Arrays.asList(DeliveryPlanUesdStatusEnum.PART_USED.getValue(), DeliveryPlanUesdStatusEnum.COLSE_FAIL.getValue(), DeliveryPlanUesdStatusEnum.UN_USED.getValue()));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List list = criteria.getCriteria();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PurDeliveryPlanItemExample.Criterion criterion = (PurDeliveryPlanItemExample.Criterion)iterator.next();
            if (!criterion.getCondition().contains("PUR_ORDER_NO")) continue;
            example.setPurOrderNo(String.valueOf(criterion.getValue()));
            iterator.remove();
        }
        PageView<PurDeliveryPlanItem> pageData = this.purDeliveryPlanItemService.queryClosePlanByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5173\u95ed\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/closePlan"})
    @ResponseBody
    public ResponseResult<String> closePlan(@RequestBody List<String> ids) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        Assert.isNotEmpty(ids, (String)"ID\u4e3a\u7a7a");
        CloseJitPlanItemCommand command = new CloseJitPlanItemCommand(ids);
        command.setSupUser((com.els.base.core.entity.user.User)loginUser);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5173\u95ed\u4ea4\u8d27\u8ba1\u5212\u53ca\u91c7\u8d2d\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/closePlanAndOrderItem"})
    @ResponseBody
    public ResponseResult<String> closePlanAndOrderItem(@RequestBody List<PurDeliveryPlanItem> planItems) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        Assert.isNotEmpty(planItems, (String)"\u5173\u95ed\u8bb0\u5f55\u4e3a\u7a7a");
        CloseJitPlanItemAndOrderItemCommand command = new CloseJitPlanItemAndOrderItemCommand(planItems);
        command.setSupUser((com.els.base.core.entity.user.User)loginUser);
        Map<String, Integer> result = this.invoker.invoke(command);
        if (result.get("success") == 0) {
            return ResponseResult.fail((ResponseCode)ResponseCode.Fail, (Object)"\u5173\u95ed\u5931\u8d25");
        }
        if (result.get("fail") == 0) {
            return ResponseResult.success((Object)"\u5173\u95ed\u6210\u529f");
        }
        return ResponseResult.success((Object)("\u90e8\u5206\u5173\u95ed\u6210\u529f\uff0c\u6210\u529f\uff1a" + result.get("success") + "\u6761\uff0c\u5931\u8d25\uff1a" + result.get("fail")));
    }

    @ApiOperation(value="\u4ea4\u8d27\u8ba1\u5212\u4fe1\u606f\uff0c\u5bfc\u51faExcel\uff08\u4f9b\u5e94\u5546\uff09", httpMethod="GET")
    @RequestMapping(value={"service/sup/exportPlan"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> supExportPlan(@RequestParam(required=false) String queryParams, @RequestParam(required=false) String ids, HttpServletRequest request, HttpServletResponse response) throws IOException {
        QueryParamWapper wapper = null;
        if (StringUtils.isNotBlank((String)queryParams)) {
            wapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
        }
        List deliveryPlanItemList = new ArrayList();
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setOrderByClause("DELIVERY_DATE ASC");
        Company currentCompany = CompanyUtils.currentCompany();
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPlanSendStatusEqualTo("Y");
        criteria.andSupCompanySapCodeIn(currentCompany.getCompanySapCodeList());
        if (StringUtils.isNotBlank((String)ids)) {
            criteria.andIdIn((List)Arrays.asList(ids.split(",")));
        } else if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        deliveryPlanItemList = this.supDeliveryPlanItemService.queryAllObjByExample((IExample)example);
        boolean isPur = false;
        List<TitleAndModelKey> titleAndModelKeys = JITDeliveryPlanHeadExeclUtil.getTitleAndModelKeys(isPur);
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        this.setDownLoadHeader(response, MessageFormat.format("jit\u9001\u8d27\u901a\u77e5\u5355\uff08\u4f9b\u5e94\u5546\uff09-{0}.xls", dateStr));
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, deliveryPlanItemList, (String)"jit\u9001\u8d27\u901a\u77e5\u5355\uff08\u4f9b\u5e94\u5546\uff09", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        return null;
    }

    private void setDownLoadHeader(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-msdownload;");
    }
}

