/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.utils.DeliveryOrderItemIsEnableConverter;
import com.els.base.delivery.utils.ExcelFileDataUtils;
import com.els.base.file.entity.FileData;
import com.els.base.purchase.command.order.pur.ConfirmOrderItemPriceCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.utils.ConfirmStatusConverter;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.SendStatusConverter;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.excel.YesOrNoIntegerConverter;
import com.els.base.utils.excel.YesOrNoStringConverter;
import com.els.liby.organization.utils.UserOrganizationUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.collect.Lists;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u8ba2\u5355\u884c")
@Controller
@RequestMapping(value={"purchaseOrderItem"})
public class PurchaseOrderItemController {
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u4ef7\u683c\u7684\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/confirmOrderItemForPrice"})
    @ResponseBody
    public ResponseResult<String> confirmOrderItemPrice(@RequestBody List<String> orderItemIdList) {
        Assert.isNotEmpty(orderItemIdList, (String)"\u8ba2\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        ConfirmOrderItemPriceCommand cmd = new ConfirmOrderItemPriceCommand(orderItemIdList);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9700\u8981\u786e\u8ba4\u4ef7\u683c\u7684\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findTodoItemForPrice"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findTodoItemForPrice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsRefusePriceEqualTo(Constant.YES_INT).andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u62d2\u7edd\u6570\u91cf\u7684\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findTodoItemForQuantity"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findTodoItemForQuantity(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        example.createCriteria().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsRefuseQuantityEqualTo(Constant.YES_INT);
        example.or().andPurPlanerIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsRefuseDeliveredDateNotEqualTo(Constant.YES_INT).andIsRefusePriceNotEqualTo(Constant.YES_INT).andIsRefuseQuantityNotEqualTo(Constant.YES_INT).andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u91c7\u8d2d\u8ba2\u5355\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPurchaseOrder"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPurchaseOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderId) {
        if (StringUtils.isBlank((String)orderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u91c7\u8d2d\u8ba2\u5355\u53f7"});
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
        criteria.andIsEnableNotEqualTo(0);
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7id\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\u5386\u53f2")
    @RequestMapping(value={"service/findItemHisById"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findItemHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderNo, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u884c\u53f7") String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        if (StringUtils.isBlank((String)orderNo)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(orderNo);
        criteria.andOrderItemNoEqualTo(orderItemNo);
        example.setOrderByClause("version DESC,UPDATE_TIME DESC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryHisAllObjByExample(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=true) QueryParamWapper wapper) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        PageView pageData = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e0b\u53d1\u7684\u8ba1\u5212\u5458\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\u660e\u7ec6")
    @RequestMapping(value={"service/findForPlaner"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findForPlaner(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        List companySapCodeList = UserOrganizationUtils.getUserCompanyCode((String)SpringSecurityUtils.getLoginUserId());
        if (CollectionUtils.isEmpty((Collection)companySapCodeList)) {
            return ResponseResult.success((Object)new PageView());
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView((PageView<PurchaseOrderItem>)new PageView(pageNo, pageSize));
        List group = Lists.partition((List)companySapCodeList, (int)999);
        for (List list : group) {
            example.or().andPurCompanySapCodeIn(list);
        }
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        PageView page = this.purchaseOrderItemService.queryObjByPage((IExample)example);
        if (CollectionUtils.isEmpty((Collection)page.getQueryResult())) {
            return ResponseResult.success((Object)page);
        }
        page.getQueryResult().forEach(orderItem -> {
            PurchaseOrder order = (PurchaseOrder)this.purchaseOrderService.queryObjById(orderItem.getOrderId());
            orderItem.setOrder(order);
        });
        return ResponseResult.success((Object)page);
    }

    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u5bfc\u51fa", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        List companyCodeList = UserOrganizationUtils.getUserCompanyCode((String)SpringSecurityUtils.getLoginUserId());
        List<PurchaseOrder> orderList = null;
        if (CollectionUtils.isNotEmpty((Collection)companyCodeList)) {
            orderList = this.queryOrder(companyCodeList, queryParams);
        }
        List<PurchaseOrderItem> orderItemList = new ArrayList<PurchaseOrderItem>();
        if (CollectionUtils.isNotEmpty(orderList)) {
            List purOrderIdList = orderList.stream().map(PurchaseOrder::getId).collect(Collectors.toList());
            PurchaseOrderItemExample example = new PurchaseOrderItemExample();
            example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
            List group = Lists.partition(purOrderIdList, (int)999);
            for (List list : group) {
                example.or().andOrderIdIn(list);
            }
            orderItemList = this.purchaseOrderItemService.queryAllObjByExample((IExample)example);
        }
        List<Map<String, Object>> orderAndItemMap = this.transfer(orderList, orderItemList);
        List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKeys();
        FileData fileData = ExcelFileDataUtils.createExcelFileOutputStream(titleAndModelKeys, orderAndItemMap, "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", "\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<PurchaseOrder> queryOrder(List<String> companyCodeList, String queryParams) throws JsonParseException, IOException, Exception {
        PurchaseOrderExample purchaseOrderExample = new PurchaseOrderExample();
        PurchaseOrderExample.Criteria criteria = purchaseOrderExample.createCriteria();
        criteria.andPurCompanySapCodeIn((List)companyCodeList);
        if (StringUtils.isNotBlank((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)purchaseOrderExample, (QueryParamWapper)queryParamWapper);
        }
        List purOrderList = this.purchaseOrderService.queryAllObjByExample((IExample)purchaseOrderExample);
        return purOrderList;
    }

    private List<TitleAndModelKey> createTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        ConfirmStatusConverter converter = new ConfirmStatusConverter();
        YesOrNoIntegerConverter yesNoIntConverter = new YesOrNoIntegerConverter();
        YesOrNoStringConverter yesNoStringConverter = new YesOrNoStringConverter();
        SendStatusConverter sendStatusConverter = new SendStatusConverter();
        DeliveryOrderItemIsEnableConverter isEnableConverter = new DeliveryOrderItemIsEnableConverter();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"order.orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u7c7b\u522b", (String)"order.orderType"));
        TitleAndModelKey orderSendStatus = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u5e03\u72b6\u6001", (String)"order.orderSendStatus");
        orderSendStatus.setToObjConverter((StrToObjConverter)sendStatusConverter);
        orderSendStatus.setToStrConverter((ObjToStrConverter)sendStatusConverter);
        titleAndModelKeys.add(orderSendStatus);
        TitleAndModelKey orderStatus = ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u72b6\u6001", (String)"order.orderStatus");
        orderStatus.setToObjConverter((StrToObjConverter)converter);
        orderStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(orderStatus);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"order.supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"order.supCompanyName"));
        TitleAndModelKey orderDate = ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u51ed\u8bc1\u65e5\u671f", (String)"order.orderDate");
        orderDate.setToObjConverter((StrToObjConverter)dateConverter);
        orderDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(orderDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"order.purCompanySapCode"));
        TitleAndModelKey sendTime = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u5e03\u65e5\u671f", (String)"order.sendTime");
        sendTime.setToObjConverter((StrToObjConverter)dateConverter);
        sendTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(sendTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0b\u5355\u8d1f\u8d23\u4eba", (String)"order.purPlanerName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"order.payTerms"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5907\u6ce8", (String)"orderItem.supRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u9879\u76ee", (String)"orderItem.orderItemNo"));
        TitleAndModelKey deliveredDate = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u4ea4\u8d27\u65e5\u671f", (String)"orderItem.deliveredDate");
        deliveredDate.setToObjConverter((StrToObjConverter)dateConverter);
        deliveredDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(deliveredDate);
        TitleAndModelKey finishFlag = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u5173\u95ed", (String)"orderItem.finishFlag");
        finishFlag.setToObjConverter((StrToObjConverter)yesNoStringConverter);
        finishFlag.setToStrConverter((ObjToStrConverter)yesNoStringConverter);
        titleAndModelKeys.add(finishFlag);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7", (String)"orderItem.purReqNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u53f7", (String)"orderItem.purReqItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"orderItem.materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"orderItem.materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u6570\u91cf", (String)"orderItem.quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"orderItem.orderUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)"orderItem.purCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b58\u5e93\u5730\u70b9", (String)"orderItem.warehouseLocation"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed3\u5e93\u63cf\u8ff0", (String)"orderItem.warehouseName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387%", (String)"orderItem.taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387\u63cf\u8ff0", (String)"orderItem.taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"orderItem.priceUnit"));
        TitleAndModelKey isOfficialPrice = ExcelUtils.createTitleAndModelKey((String)"\u6682\u4f30\u4ef7\u6807\u8bc6", (String)"orderItem.isOfficialPrice");
        isOfficialPrice.setToObjConverter((StrToObjConverter)yesNoIntConverter);
        isOfficialPrice.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        titleAndModelKeys.add(isOfficialPrice);
        TitleAndModelKey isEnable = ExcelUtils.createTitleAndModelKey((String)"\u5220\u9664\u6807\u8bc6", (String)"orderItem.isEnable");
        isEnable.setToObjConverter((StrToObjConverter)isEnableConverter);
        isEnable.setToStrConverter((ObjToStrConverter)isEnableConverter);
        titleAndModelKeys.add(isEnable);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5730\u5740", (String)"orderItem.deliveryLocation"));
        TitleAndModelKey returnFlag = ExcelUtils.createTitleAndModelKey((String)"\u9000\u8d27\u6807\u8bc6", (String)"order.returnFlag");
        returnFlag.setToObjConverter((StrToObjConverter)yesNoStringConverter);
        returnFlag.setToStrConverter((ObjToStrConverter)yesNoStringConverter);
        titleAndModelKeys.add(returnFlag);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u5355\u4ef7", (String)"orderItem.materialUnitPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6750\u6599\u91d1\u989d", (String)"orderItem.materialTotalPirce"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u4ef7", (String)"orderItem.totalPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"BOM\u7684\u6587\u672c\u63cf\u8ff0", (String)"orderItem.bomDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u63a7\u8ba2\u5355\u53f7", (String)"orderItem.masterOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u63a7\u8ba2\u5355\u884c\u53f7", (String)"orderItem.masterOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u6536\u8d27\u6570\u91cf", (String)"orderItem.receivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5728\u9014\u6570\u91cf", (String)"orderItem.onwayQuantity"));
        TitleAndModelKey freeFlag = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u514d\u8d39", (String)"order.freeFlag");
        freeFlag.setToObjConverter((StrToObjConverter)yesNoStringConverter);
        freeFlag.setToStrConverter((ObjToStrConverter)yesNoStringConverter);
        titleAndModelKeys.add(freeFlag);
        return titleAndModelKeys;
    }

    private List<Map<String, Object>> transfer(List<PurchaseOrder> orders, List<PurchaseOrderItem> orderItems) {
        List<Map<String, Object>> orderAndItemMap = orderItems.stream().map(orderItem -> {
            HashMap<String, Serializable> orderAndItem = new HashMap<String, Serializable>();
            PurchaseOrder order = this.filterOrder(orders, (PurchaseOrderItem)orderItem);
            orderAndItem.put("order", order);
            orderAndItem.put("orderItem", (Serializable)orderItem);
            return orderAndItem;
        }).collect(Collectors.toList());
        return orderAndItemMap;
    }

    private PurchaseOrder filterOrder(List<PurchaseOrder> orders, PurchaseOrderItem orderItem) {
        return orders.stream().filter(order -> order.getId().equals(orderItem.getOrderId())).findAny().orElseGet(null);
    }
}

