/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;

public class RevokeSendJitPlanCommand
extends AbstractCommand {
    private static final String IS_LOCK = "F";
    private List<String> ids;

    public RevokeSendJitPlanCommand(List<String> ids) {
        this.ids = ids;
    }

    public Object execute(ICommandInvoker context) {
        ArrayList planIds = new ArrayList();
        this.ids.stream().distinct().forEach(id -> {
            SupDeliveryPlanItemExample supPlanItemExample = new SupDeliveryPlanItemExample();
            supPlanItemExample.createCriteria().andPlanIdEqualTo((String)id).andIsJitEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT);
            List lists = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)supPlanItemExample);
            if (lists.stream().anyMatch(item -> !DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(item.getUsedStatus()))) {
                throw new CommonException("\u7269\u6599\u7f16\u7801\uff1a" + ((SupDeliveryPlanItem)lists.get(0)).getMaterialNo() + ",\u5de5\u5382\u4ee3\u7801\uff1a" + ((SupDeliveryPlanItem)lists.get(0)).getFactoryCode() + "\uff0c\u8981\u6c42\u9001\u8fbe\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)((SupDeliveryPlanItem)lists.get(0)).getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + ";\u5df2\u53d1\u8d27\uff0c\u65e0\u6cd5\u64a4\u9500\u53d1\u9001\uff01");
            }
            if (lists.stream().anyMatch(item -> IS_LOCK.equals(item.getIsLock()))) {
                throw new CommonException("\u7269\u6599\u7f16\u7801\uff1a" + ((SupDeliveryPlanItem)lists.get(0)).getMaterialNo() + ",\u5de5\u5382\u4ee3\u7801\uff1a" + ((SupDeliveryPlanItem)lists.get(0)).getFactoryCode() + "\uff0c\u8981\u6c42\u9001\u8fbe\u65f6\u95f4\uff1a" + DateFormatUtils.format((Date)((SupDeliveryPlanItem)lists.get(0)).getDeliveryDate(), (String)"yyyy-MM-dd HH:mm:ss") + ";\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u64a4\u9500\u53d1\u9001\uff01");
            }
            planIds.add(id);
        });
        DeliveryPlan plan = new DeliveryPlan();
        plan.setStatus(Constant.NO_INT);
        DeliveryPlanExample planExample = new DeliveryPlanExample();
        planExample.createCriteria().andIdIn((List)this.ids);
        ContextUtils.getDeliveryPlanService().modifyByExample(plan, planExample);
        SupDeliveryPlanItem supplanItem = new SupDeliveryPlanItem();
        supplanItem.setPlanSendStatus("N");
        SupDeliveryPlanItemExample supPlanItemExample = new SupDeliveryPlanItemExample();
        supPlanItemExample.createCriteria().andPlanIdIn((List)this.ids);
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supplanItem, supPlanItemExample);
        PurDeliveryPlanItem purPlanItem = new PurDeliveryPlanItem();
        purPlanItem.setPlanSendStatus("N");
        PurDeliveryPlanItemExample purPlanItemExample = new PurDeliveryPlanItemExample();
        purPlanItemExample.createCriteria().andPlanIdIn((List)this.ids);
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purPlanItem, purPlanItemExample);
        return null;
    }
}

