/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSupConfirmCmd;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSupRefuseCmd;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class NoneJitPlanSendToPurCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<SupDeliveryPlanItem> planList;
    private PlanDataSourceEnum sourceEnum;

    public NoneJitPlanSendToPurCmd(List<SupDeliveryPlanItem> planList, PlanDataSourceEnum sourceEnum) {
        this.planList = planList;
        this.sourceEnum = sourceEnum;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.planList);
        Map orderItemIdAndPlanListMap = this.planList.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderItemId, Collectors.toList()));
        for (String orderItemId : orderItemIdAndPlanListMap.keySet()) {
            this.sendNoneJitByOrderItemId(orderItemId, orderItemIdAndPlanListMap.get(orderItemId));
        }
        return null;
    }

    private void sendNoneJitByOrderItemId(String orderItemId, List<SupDeliveryPlanItem> list) {
        this.confirmOrRefusePlanItem(list);
        this.checkPlanNum(orderItemId);
        this.sendPlanToPur(orderItemId);
    }

    private void sendPlanToPur(String orderItemId) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderItemIdEqualTo(orderItemId);
        ContextUtils.getPurDeliveryPlanItemService().deleteByExample(example);
        ContextUtils.getPurDeliveryPlanItemService().addBySupDeliveryPlanItem(orderItemId);
    }

    private void checkPlanNum(String orderItemId) {
        SupplierOrderItem orderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(orderItemId);
        if (Constant.YES_INT.equals(orderItem.getIsJit())) {
            this.logger.debug("JIT \u8ba2\u5355\u884c\uff0c\u4e0d\u505a\u53ef\u53d1\u8d27\u6570\u91cf\u7684\u6821\u9a8c");
            return;
        }
        if (Constant.NO_INT.equals(orderItem.getIsEnable()) || "Y".equals(orderItem.getFinishFlag())) {
            this.logger.debug("\u8ba2\u5355\u884c\u5df2\u5220\u9664\u6216\u5df2\u5173\u95ed\uff0c\u4e0d\u505a\u53ef\u53d1\u8d27\u6570\u91cf\u6821\u9a8c");
            return;
        }
        SupDeliveryPlanItemExample planItemExample = new SupDeliveryPlanItemExample();
        planItemExample.createCriteria().andPurOrderItemIdEqualTo(orderItem.getId()).andIsCanDeliveryEqualTo(Constant.YES_INT);
        List planItemList = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)planItemExample);
        BigDecimal sumQuantity = planItemList.stream().filter(planItem -> Constant.YES_INT.equals(planItem.getIsCanDelivery())).map(planItem -> planItem.getDeliveryQuantity().subtract(planItem.getOnwayQuantity()).subtract(planItem.getReceivedQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (orderItem.getCanDeliveryQuantity().compareTo(sumQuantity) > 0) {
            BigDecimal q = orderItem.getCanDeliveryQuantity().subtract(sumQuantity);
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf \u6bd4\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u5c11 [%s]", orderItem.getOrderNo(), orderItem.getOrderItemNo(), q.toString()));
        }
        if (orderItem.getCanDeliveryQuantity().compareTo(sumQuantity) < 0) {
            BigDecimal q = sumQuantity.subtract(orderItem.getCanDeliveryQuantity());
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf \u6bd4\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u591a [%s]", orderItem.getOrderNo(), orderItem.getOrderItemNo(), q.toString()));
        }
    }

    private void confirmOrRefusePlanItem(List<SupDeliveryPlanItem> list) {
        List<SupDeliveryPlanItem> refusePlanList;
        ArrayList<SupDeliveryPlanItem> allChangeList = new ArrayList<SupDeliveryPlanItem>();
        List<SupDeliveryPlanItem> confirmPlanList = list.stream().filter(plan -> PlanChangeStatusEnum.SUP_CONFIRM.getValue().equals(plan.getChangeStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(confirmPlanList)) {
            NoneJitPlanSupConfirmCmd confirmCmd = new NoneJitPlanSupConfirmCmd(confirmPlanList);
            confirmCmd.copyProperties(this);
            confirmPlanList = this.context.invoke(confirmCmd);
            allChangeList.addAll(confirmPlanList);
        }
        if (CollectionUtils.isNotEmpty(refusePlanList = list.stream().filter(plan -> PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(plan.getChangeStatus())).collect(Collectors.toList()))) {
            NoneJitPlanSupRefuseCmd refuseCmd = new NoneJitPlanSupRefuseCmd(refusePlanList);
            refuseCmd.copyProperties(this);
            refusePlanList = this.context.invoke(refuseCmd);
            allChangeList.addAll(refusePlanList);
        }
        if (CollectionUtils.isEmpty(allChangeList)) {
            return;
        }
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        if (PlanDataSourceEnum.EXCEL.equals((Object)this.sourceEnum)) {
            Map<String, List<SupDeliveryPlanItem>> group = list.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderNo));
            group.keySet().forEach(orderNo -> {
                List tmpOrderItemNoList = ((List)group.get(orderNo)).stream().map(SupDeliveryPlanItem::getDeliveryOrderItemNo).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(tmpOrderItemNoList)) {
                    return;
                }
                example.or().andPurOrderNoEqualTo((String)orderNo).andPurOrderItemNoIn(tmpOrderItemNoList).andIsJitEqualTo(Constant.NO_INT);
            });
            ContextUtils.getSupDeliveryPlanItemService().deleteByExample(example);
        }
        if (PlanDataSourceEnum.UI.equals((Object)this.sourceEnum)) {
            List planIdList = list.stream().filter(plan -> StringUtils.isNotBlank((String)plan.getId())).map(SupDeliveryPlanItem::getId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(planIdList)) {
                throw new CommonException("\u63d0\u4ea4\u7684\u9001\u8d27\u901a\u77e5\u5355\u6570\u636e\u5f02\u5e38");
            }
            example.createCriteria().andIdIn(planIdList).andIsJitEqualTo(Constant.NO_INT);
            ContextUtils.getSupDeliveryPlanItemService().deleteByExample(example);
        }
        refusePlanList.forEach(plan -> plan.setId(null));
        ContextUtils.getSupDeliveryPlanItemService().addAll(allChangeList);
    }

    private void valid(List<SupDeliveryPlanItem> planList) {
        for (SupDeliveryPlanItem plan : this.planList) {
            Assert.isNotBlank((String)plan.getPurOrderId(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8ba2\u5355\u5934Id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemId(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getChangeStatus(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getChangeReason(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8d23\u4efb\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)plan.getDeliveryDate(), (String)"\u8ba1\u5212\u53d1\u8d27\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)plan.getDeliveryQuantity(), (String)"\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            if (!DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(plan.getUsedStatus())) {
                boolean isEqual = false;
                if (StringUtils.isNotBlank((String)plan.getId())) {
                    SupDeliveryPlanItem tmp = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(plan.getId());
                    isEqual = DeliveryPlanUtils.isEqual(plan, tmp);
                }
                if (!isEqual) {
                    String msg = String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u5df2\u7ecf\u751f\u6210\u9001\u8d27\u5355\uff0c\u4e0d\u80fd\u53d8\u66f4", plan.getPurOrderNo(), plan.getPurOrderItemNo());
                    throw new CommonException(msg);
                }
            }
            if (!PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(plan.getChangeStatus())) continue;
            if (!DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(plan.getUsedStatus())) {
                String msg = String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u5df2\u7ecf\u751f\u6210\u9001\u8d27\u5355\uff0c\u4e0d\u80fd\u53d8\u66f4", plan.getPurOrderNo(), plan.getPurOrderItemNo());
                throw new CommonException(msg);
            }
            Assert.isNotBlank((String)plan.getSupRemark(), (String)String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u53d8\u66f4\u65f6\u9700\u8981\u586b\u5199\u5907\u6ce8", plan.getPurOrderNo(), plan.getPurOrderItemNo()));
            Assert.isNotBlank((String)plan.getChangeReason(), (String)String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u9700\u8981\u8bbe\u7f6e\u62d2\u7edd\u7684\u8d23\u4efb\u65b9", plan.getPurOrderNo(), plan.getPurOrderItemNo()));
        }
    }
}

