/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.delivery.command.PreviewDelieryPackageCmd;
import com.els.base.delivery.command.PreviewDeliveryOrderItemByPlanCmd;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PreviewDeliveryOrderByPlanCmd
extends AbstractCommand<DeliveryOrder> {
    private static final long serialVersionUID = 1L;
    private List<SupDeliveryPlanItem> deliveryPlanItemList;

    public PreviewDeliveryOrderByPlanCmd(List<SupDeliveryPlanItem> deliveryPlanItemList) {
        this.deliveryPlanItemList = deliveryPlanItemList;
    }

    @Override
    public DeliveryOrder execute(ICommandInvoker context) {
        PreviewDeliveryOrderItemByPlanCmd previewItemCmd = new PreviewDeliveryOrderItemByPlanCmd(this.deliveryPlanItemList);
        previewItemCmd.copyProperties(this);
        List<DeliveryOrderItem> items = context.invoke(previewItemCmd);
        PreviewDelieryPackageCmd previewPackageCmd = new PreviewDelieryPackageCmd(items);
        previewPackageCmd.copyProperties(this);
        List<DeliveryPackage> packageList = context.invoke(previewPackageCmd);
        DeliveryOrder deliveryOrder = this.completeDeliveryOrder(items);
        deliveryOrder.setItems(items);
        deliveryOrder.setDeliveryPackageLists(packageList);
        GenerateCodeService generateCodeService = ContextUtils.getGenerateCodeService();
        String deliveryOrderNo = generateCodeService.getNextCode("DELIVERY_NO_GENERATOR");
        deliveryOrder.setDeliveryOrderNo(deliveryOrderNo);
        for (DeliveryOrderItem deliveryOrderItem : items) {
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrderNo);
        }
        for (DeliveryPackage deliveryPackage : packageList) {
            deliveryPackage.setDeliveryOrderNo(deliveryOrderNo);
        }
        return deliveryOrder;
    }

    public BigDecimal sumDeliveryQuantity(List<SupDeliveryPlanItem> deliveryPlanItemList, String purOrderNo, String purOrderItemNo) {
        BigDecimal sumQuantity = deliveryPlanItemList.stream().filter(planItem -> purOrderNo.equals(planItem.getPurOrderNo()) && purOrderItemNo.equals(planItem.getPurOrderItemNo())).map(SupDeliveryPlanItem::getDeliveryQuantity).reduce(BigDecimal::add).orElseGet(() -> null);
        return sumQuantity;
    }

    private String getVoucherType(List<DeliveryOrderItem> items) {
        List purOrderIdList = items.stream().map(DeliveryOrderItem::getPurOrderId).collect(Collectors.toList());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andIdIn(purOrderIdList).andOrderTypeIsNotNull();
        example.setPageView((PageView<SupplierOrder>)new PageView(1, 1));
        example.setOrderByClause("ORDER_TYPE DESC");
        PageView pageView = ContextUtils.getSupplierOrderService().queryObjByPage((IExample)example);
        if (CollectionUtils.isEmpty((Collection)pageView.getQueryResult())) {
            return null;
        }
        return ((SupplierOrder)pageView.getQueryResult().get(0)).getOrderType();
    }

    private DeliveryOrder completeDeliveryOrder(List<DeliveryOrderItem> items) {
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        List orderNos = items.stream().map(DeliveryOrderItem::getPurOrderNo).distinct().collect(Collectors.toList());
        deliveryOrder.setPurchaseOrderNo(StringUtils.abbreviate((String)StringUtils.join(orderNos, (String)","), (int)1000));
        deliveryOrder.setFactoryCode(items.get(0).getFactoryCode());
        deliveryOrder.setFactoryName(items.get(0).getFactoryName());
        deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_SENT.getValue());
        deliveryOrder.setVoucherType(this.getVoucherType(items));
        if (this.getSupUser() != null) {
            deliveryOrder.setUserId(this.getSupUser().getId());
            deliveryOrder.setUserName(this.getSupUser().getNickName());
        }
        if (this.getSupCompany() != null) {
            deliveryOrder.setCompanyId(items.get(0).getCompanyId());
            deliveryOrder.setCompanyName(items.get(0).getCompanyName());
            deliveryOrder.setCompanyCode(items.get(0).getCompanyCode());
        }
        if (this.getPurUser() == null) {
            String purUserId = items.stream().map(DeliveryOrderItem::getPurUserId).distinct().collect(Collectors.joining(","));
            deliveryOrder.setPurUserName(purUserId);
            if (purUserId.length() > 255) {
                purUserId = StringUtils.abbreviate((String)purUserId, (int)255);
            }
            String purUser = items.stream().map(DeliveryOrderItem::getPurUserName).distinct().collect(Collectors.joining(","));
            deliveryOrder.setPurUserName(purUser);
            if (purUser.length() > 255) {
                purUser = StringUtils.abbreviate((String)purUser, (int)255);
            }
        } else {
            deliveryOrder.setPurUserId(this.getPurUser().getId());
            deliveryOrder.setPurUserName(this.getPurUser().getNickName());
        }
        if (this.getPurCompany() == null) {
            deliveryOrder.setPurCompanyId(items.get(0).getPurCompanyId());
            deliveryOrder.setPurCompanyCode(items.get(0).getPurCompanyCode());
            deliveryOrder.setPurCompanyName(items.get(0).getPurCompanyName());
        } else {
            deliveryOrder.setPurCompanyId(this.getPurCompany().getId());
            deliveryOrder.setPurCompanyCode(this.getPurCompany().getCompanyCode());
            deliveryOrder.setPurCompanyName(this.getPurCompany().getCompanyFullName());
        }
        return deliveryOrder;
    }
}

