/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.planItem;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.sap.ZSRMRFCGETELIKZ2;
import com.els.base.plan.sap.ZSRMRFCGETELIKZResponse;
import com.els.base.plan.utils.PlanSapConfUtils;
import com.els.liby.quota.service.SoapServiceRequestText;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseOrderBackSapCommand
extends AbstractCommand<List<ZSRMRFCGETELIKZ2>> {
    private static final Logger log = LoggerFactory.getLogger(CloseOrderBackSapCommand.class);
    private static String username = PlanSapConfUtils.getServiceUsername();
    private static String password = PlanSapConfUtils.getServicePassword();
    private static String serviceUrl = PlanSapConfUtils.getJitPlanUrl();
    private static String serviceNameSpace = PlanSapConfUtils.getNameSpace();
    private static String serviceMethod = PlanSapConfUtils.getJitPlanServiceMethod();
    private List<PurDeliveryPlanItem> purDeliveryPlanItems;

    public CloseOrderBackSapCommand(List<PurDeliveryPlanItem> purDeliveryPlanItems) {
        this.purDeliveryPlanItems = purDeliveryPlanItems;
    }

    @Override
    public List<ZSRMRFCGETELIKZ2> execute(ICommandInvoker context) {
        ZSRMRFCGETELIKZResponse response = this.getDataFromSap(this.purDeliveryPlanItems);
        List<ZSRMRFCGETELIKZ2> lists = response.getCTDATA().getItem();
        return lists;
    }

    private ZSRMRFCGETELIKZResponse getDataFromSap(List<PurDeliveryPlanItem> purDeliveryPlanItems) {
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(purDeliveryPlanItems);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u91c7\u8d2d\u8ba2\u5355\u884c\u5173\u95ed\u56de\u5199SAP\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCGETELIKZResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u91c7\u8d2d\u8ba2\u5355\u884c\u5173\u95ed\u56de\u5199SAP\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u884c\u5173\u95ed\u56de\u5199SAP\u63a5\u53e3\u5f02\u5e38");
        }
        log.debug("\u3010\u91c7\u8d2d\u8ba2\u5355\u884c\u5173\u95ed\u56de\u5199SAP\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCGETELIKZResponse respone = (ZSRMRFCGETELIKZResponse)vo.getResult();
        if (respone == null) {
            throw new CommonException("\u7532\u4f9b\u6599\u56de\u5199SAP,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        return respone;
    }

    private String getXmlParams(List<PurDeliveryPlanItem> purDeliveryPlanItems) {
        List<PurDeliveryPlanItem> list = this.distinctOrder(purDeliveryPlanItems);
        StringBuffer sb = new StringBuffer();
        sb.append(" <CT_DATA>");
        list.stream().forEach(o -> {
            sb.append(" <item>");
            sb.append(" <EBELN>0" + o.getPurOrderNo() + "</EBELN>");
            sb.append(" <EBELP>" + o.getPurOrderItemNo() + "</EBELP>");
            sb.append(" <ELIKZ>X</ELIKZ>");
            sb.append(" </item>");
        });
        sb.append(" </CT_DATA>");
        return sb.toString();
    }

    private List<PurDeliveryPlanItem> distinctOrder(List<PurDeliveryPlanItem> purDeliveryPlanItems) {
        ArrayList orderItemIds = new ArrayList();
        List<PurDeliveryPlanItem> list = purDeliveryPlanItems.stream().filter(item -> {
            boolean flag = !orderItemIds.contains(item.getPurOrderItemId());
            orderItemIds.add(item.getPurOrderItemId());
            return flag;
        }).collect(Collectors.toList());
        return list;
    }
}

