/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.JITLeadTimeDetailMapper;
import com.els.base.plan.entity.JITLeadTimeDetail;
import com.els.base.plan.entity.JITLeadTimeDetailExample;
import com.els.base.plan.service.JITLeadTimeDetailService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultJITLeadTimeDetailService")
public class JITLeadTimeDetailServiceImpl
implements JITLeadTimeDetailService {
    @Resource
    protected JITLeadTimeDetailMapper jITLeadTimeDetailMapper;

    @CacheEvict(value={"jITLeadTimeDetail"}, allEntries=true)
    public void addObj(JITLeadTimeDetail t) {
        this.jITLeadTimeDetailMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"jITLeadTimeDetail"}, allEntries=true)
    public void addAll(List<JITLeadTimeDetail> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.jITLeadTimeDetailMapper.insertBatch(list);
    }

    @CacheEvict(value={"jITLeadTimeDetail"}, allEntries=true)
    public void deleteObjById(String id) {
        this.jITLeadTimeDetailMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"jITLeadTimeDetail"}, allEntries=true)
    public void modifyObj(JITLeadTimeDetail t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.jITLeadTimeDetailMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"jITLeadTimeDetail"}, keyGenerator="redisKeyGenerator")
    public JITLeadTimeDetail queryObjById(String id) {
        return this.jITLeadTimeDetailMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"jITLeadTimeDetail"}, keyGenerator="redisKeyGenerator")
    public List<JITLeadTimeDetail> queryAllObjByExample(JITLeadTimeDetailExample example) {
        return this.jITLeadTimeDetailMapper.selectByExample(example);
    }

    @Cacheable(value={"jITLeadTimeDetail"}, keyGenerator="redisKeyGenerator")
    public PageView<JITLeadTimeDetail> queryObjByPage(JITLeadTimeDetailExample example) {
        PageView<JITLeadTimeDetail> pageView = example.getPageView();
        pageView.setQueryResult(this.jITLeadTimeDetailMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"jITLeadTimeDetail"}, allEntries=true)
    public void deleteObjByExampl(JITLeadTimeDetailExample example) {
        this.jITLeadTimeDetailMapper.deleteByExample(example);
    }

    @CacheEvict(value={"jITLeadTimeDetail"}, allEntries=true)
    public void deleteByExample(JITLeadTimeDetailExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.jITLeadTimeDetailMapper.deleteByExample(example);
    }
}

