/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanPurConfirmCmd;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanPurRefuseCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.command.log.CreateOperationLogCommand;
import com.els.base.purchase.command.order.pur.IsAllOrderItemHandledCommand;
import com.els.base.purchase.command.order.pur.SendOrderCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.IsRefuseStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderOperationTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class NoneJitPlanSendToSupCmd
extends AbstractCommand<String> {
    public static final String DATA_SOURCE_EXCEL = "DATA_SOURCE_EXCEL";
    public static final String DATA_SOURCE_UI = "DATA_SOURCE_UI";
    private static final long serialVersionUID = 1L;
    private List<PurDeliveryPlanItem> planList;
    private PlanDataSourceEnum sourceEnum;

    public NoneJitPlanSendToSupCmd(List<PurDeliveryPlanItem> planList, PlanDataSourceEnum sourceEnum) {
        this.planList = planList;
        this.sourceEnum = sourceEnum;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.planList);
        Map orderNoAndPlanListMap = this.planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderNo, Collectors.toList()));
        for (String orderNo : orderNoAndPlanListMap.keySet()) {
            this.sendNoneJitByOrder(orderNo, orderNoAndPlanListMap.get(orderNo));
        }
        if (PlanDataSourceEnum.UI.equals((Object)this.sourceEnum)) {
            CreateOperationLogCommand createLogCmd = new CreateOperationLogCommand(this.planList, PurchaseOrderOperationTypeEnum.PLAN_CHANGE);
            createLogCmd.copyProperties(this);
            this.context.invoke(createLogCmd);
        }
        return null;
    }

    private void sendNoneJitByOrder(String orderNo, List<PurDeliveryPlanItem> list) {
        PurchaseOrder order = this.getPurOrder(orderNo);
        Assert.isNotNull((Object)order, (String)String.format("\u8ba2\u5355[%s]\u4e0d\u5b58\u5728", orderNo));
        if (PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(order.getOrderStatus())) {
            this.handleForConfirmedOrder(order, list);
            return;
        }
        this.handleForUnConfirmOrder(order, list);
    }

    private void handleForUnConfirmOrder(PurchaseOrder order, List<PurDeliveryPlanItem> list) {
        this.isExistUnConfirmPlan(order, list);
        this.confirmOrRefusePlanItem(order, list);
        this.checkPlanNum(list);
        this.updateOrderItemStatus(list);
        if (this.isAllOrderItemConfirm(order)) {
            this.confirmAllOrder(order);
        } else if (this.isAllOrderItemNoRefuse(order)) {
            this.sendOrderToSup(order);
        }
    }

    private void handleForConfirmedOrder(PurchaseOrder order, List<PurDeliveryPlanItem> planList) {
        this.confirmOrRefusePlanItem(order, planList);
        this.checkPlanNum(planList);
        this.sendPlanToSup(order.getId());
    }

    private PurchaseOrder getPurOrder(String orderNo) {
        List list;
        PurchaseOrderExample example = new PurchaseOrderExample();
        PurchaseOrderExample.Criteria cri = example.createCriteria();
        cri.andOrderNoEqualTo(orderNo);
        if (this.getPurCompany() != null) {
            cri.andProjectIdEqualTo(this.getPurCompany().getProjectId());
        }
        if (CollectionUtils.isEmpty((Collection)(list = ContextUtils.getPurchaseOrderService().queryAllObjByExample((IExample)example)))) {
            return null;
        }
        return (PurchaseOrder)list.get(0);
    }

    private boolean isAllHandled(String orderItemId) {
        PurDeliveryPlanItemExample purPlanItemEx = new PurDeliveryPlanItemExample();
        purPlanItemEx.createCriteria().andPurOrderItemIdEqualTo(orderItemId).andChangeStatusEqualTo(PlanChangeStatusEnum.SUP_CHANGE.getValue());
        List notConfirmPlanList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)purPlanItemEx);
        return CollectionUtils.isEmpty((Collection)notConfirmPlanList);
    }

    private boolean isAllOrderItemNoRefuse(PurchaseOrder order) {
        IsAllOrderItemHandledCommand command = new IsAllOrderItemHandledCommand(order.getId());
        command.copyProperties(this);
        return this.context.invoke(command);
    }

    private void checkPlanNum(List<PurDeliveryPlanItem> planList) {
        Map orderItemIdAndPlanList = planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderItemId, Collectors.toList()));
        for (String orderItemId : orderItemIdAndPlanList.keySet()) {
            PurDeliveryPlanItemExample planItemExample = new PurDeliveryPlanItemExample();
            planItemExample.createCriteria().andPurOrderItemIdEqualTo(orderItemId);
            List planItemList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)planItemExample);
            BigDecimal sumQuantity = planItemList.stream().filter(planItem -> Constant.YES_INT.equals(planItem.getIsCanDelivery())).map(planItem -> planItem.getDeliveryQuantity().subtract(planItem.getOnwayQuantity()).subtract(planItem.getReceivedQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
            PurchaseOrderItem purOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(orderItemId);
            if (purOrderItem.getCanDeliveryQuantity().compareTo(sumQuantity) > 0) {
                BigDecimal q = purOrderItem.getCanDeliveryQuantity().subtract(sumQuantity);
                throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf \u6bd4\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u5c11 [%s]", purOrderItem.getOrderNo(), purOrderItem.getOrderItemNo(), q.toString()));
            }
            if (purOrderItem.getCanDeliveryQuantity().compareTo(sumQuantity) >= 0) continue;
            BigDecimal q = sumQuantity.subtract(purOrderItem.getCanDeliveryQuantity());
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf \u6bd4\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u591a [%s]", purOrderItem.getOrderNo(), purOrderItem.getOrderItemNo(), q.toString()));
        }
    }

    private void sendPlanToSup(String orderId) {
        ContextUtils.getSupDeliveryPlanItemService().deleteByOrderId(orderId);
        ContextUtils.getSupDeliveryPlanItemService().addByPurDeliveryPlanItem(orderId);
    }

    private void sendOrderToSup(PurchaseOrder order) {
        PurchaseOrder temPurOrder = new PurchaseOrder();
        temPurOrder.setId(order.getId());
        temPurOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue());
        temPurOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        ContextUtils.getPurchaseOrderService().modifyObj(temPurOrder);
        SupplierOrder temSupOrder = new SupplierOrder();
        temSupOrder.setId(order.getId());
        temSupOrder.setOrderSendStatus(temPurOrder.getOrderSendStatus());
        temSupOrder.setOrderStatus(temPurOrder.getOrderStatus());
        ContextUtils.getSupplierOrderService().modifyObj(temSupOrder);
        SendOrderCommand command = new SendOrderCommand(order.getId());
        command.copyProperties(this);
        this.context.invoke(command);
    }

    private void confirmAllOrder(PurchaseOrder order) {
        PurchaseOrder temPurOrder = new PurchaseOrder();
        temPurOrder.setId(order.getId());
        temPurOrder.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue());
        temPurOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        ContextUtils.getPurchaseOrderService().modifyObj(temPurOrder);
        ContextUtils.getPurDeliveryPlanItemService().confirmAllPlan(order.getId());
        ContextUtils.getSupDeliveryPlanItemService().confirmAllPlan(order.getId());
        SendOrderCommand command = new SendOrderCommand(order.getId());
        command.copyProperties(this);
        this.context.invoke(command);
    }

    private void updateOrderItemStatus(List<PurDeliveryPlanItem> list) {
        Map orderItemIdAndPlanList = list.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderItemId, Collectors.toList()));
        for (String orderItemId : orderItemIdAndPlanList.keySet()) {
            boolean isAllPlanHandled = this.isAllHandled(orderItemId);
            if (!isAllPlanHandled) continue;
            boolean isAllConfirm = orderItemIdAndPlanList.get(orderItemId).stream().allMatch(planItem -> PlanChangeStatusEnum.PUR_CONFIRM.getValue().equals(planItem.getChangeStatus()));
            PurchaseOrderItem tmpPurItem = new PurchaseOrderItem();
            PurchaseOrderItem item = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(orderItemId);
            if (IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefusePrice()) || IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefuseQuantity())) {
                tmpPurItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
            } else if (!isAllConfirm || IsRefuseStatusEnum.HANDLED.getValue().equals(item.getIsRefusePrice())) {
                tmpPurItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            } else {
                tmpPurItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            }
            tmpPurItem.setId(orderItemId);
            tmpPurItem.setIsRefuseDeliveredDate(IsRefuseStatusEnum.HANDLED.getValue());
            tmpPurItem.setHaveChange(ChangeTypeEnum.MODIFY_ITEM.getValue());
            ContextUtils.getPurchaseOrderItemService().modifyObj(tmpPurItem);
        }
    }

    private boolean isNoRefusePriceAndQuantity(String orderItemId) {
        PurchaseOrderItem item = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(orderItemId);
        if (IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefusePrice()) || IsRefuseStatusEnum.HANDLED.getValue().equals(item.getIsRefusePrice())) {
            return false;
        }
        return !IsRefuseStatusEnum.REFUSE.getValue().equals(item.getIsRefuseQuantity());
    }

    private boolean isAllOrderItemConfirm(PurchaseOrder order) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderIdEqualTo(order.getId()).andOrderStatusNotEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        List unConfirmItemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        return CollectionUtils.isEmpty((Collection)unConfirmItemList);
    }

    private void isExistUnConfirmPlan(PurchaseOrder order, List<PurDeliveryPlanItem> list) {
        List orderItemIdList = list.stream().map(PurDeliveryPlanItem::getPurOrderItemId).collect(Collectors.toList());
        PurchaseOrderItemExample itemExample = new PurchaseOrderItemExample();
        itemExample.createCriteria().andOrderIdEqualTo(order.getId()).andIsRefuseDeliveredDateEqualTo(Constant.YES_INT).andIdNotIn(orderItemIdList);
        List unHandleItem = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)itemExample);
        if (CollectionUtils.isNotEmpty((Collection)unHandleItem)) {
            PurchaseOrderItem item = (PurchaseOrderItem)unHandleItem.get(0);
            String errMsg = String.format("\u91c7\u8d2d\u8ba2\u5355 [%s] \u672a\u786e\u8ba4\uff0c\u6240\u6709\u672a\u786e\u8ba4\u7684\u8ba1\u5212\uff0c\u9700\u8981\u5168\u90e8\u53d1\u9001\u5904\u7406", item.getOrderNo(), item.getOrderItemNo());
            throw new CommonException(errMsg);
        }
    }

    private void confirmOrRefusePlanItem(PurchaseOrder order, List<PurDeliveryPlanItem> list) {
        List<PurDeliveryPlanItem> refusePlanList;
        ArrayList allChangeList = new ArrayList();
        List<PurDeliveryPlanItem> confirmPlanList = list.stream().filter(plan -> PlanChangeStatusEnum.PUR_CONFIRM.getValue().equals(plan.getChangeStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(confirmPlanList)) {
            NoneJitPlanPurConfirmCmd confirmCmd = new NoneJitPlanPurConfirmCmd(confirmPlanList);
            confirmCmd.copyProperties(this);
            allChangeList.addAll(this.context.invoke(confirmCmd));
        }
        if (CollectionUtils.isNotEmpty(refusePlanList = list.stream().filter(plan -> PlanChangeStatusEnum.PUR_CHANGE.getValue().equals(plan.getChangeStatus())).collect(Collectors.toList()))) {
            NoneJitPlanPurRefuseCmd refuseCmd = new NoneJitPlanPurRefuseCmd(refusePlanList);
            refuseCmd.copyProperties(this);
            allChangeList.addAll(this.context.invoke(refuseCmd));
        }
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        if (PlanDataSourceEnum.EXCEL.equals((Object)this.sourceEnum)) {
            List orderNoList = list.stream().map(PurDeliveryPlanItem::getPurOrderNo).collect(Collectors.toList());
            List orderItemNoList = list.stream().map(PurDeliveryPlanItem::getPurOrderItemNo).collect(Collectors.toList());
            example.createCriteria().andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList).andIsJitEqualTo(Constant.NO_INT).andDeliveryOrderIdIsNull();
            ContextUtils.getPurDeliveryPlanItemService().deleteByExample(example);
        }
        if (PlanDataSourceEnum.UI.equals((Object)this.sourceEnum)) {
            List planIdList = list.stream().filter(plan -> StringUtils.isNotBlank((String)plan.getId())).map(PurDeliveryPlanItem::getId).distinct().collect(Collectors.toList());
            example.createCriteria().andIdIn(planIdList).andIsJitEqualTo(Constant.NO_INT).andUsedStatusEqualTo(DeliveryPlanUesdStatusEnum.UN_USED.getValue());
            ContextUtils.getPurDeliveryPlanItemService().deleteByExample(example);
        }
        allChangeList.forEach(plan -> {
            plan.setId(null);
            plan.setPurOrderStatus(order.getOrderStatus());
        });
        ContextUtils.getPurDeliveryPlanItemService().addAll(allChangeList);
    }

    private void valid(List<PurDeliveryPlanItem> planList) {
        for (PurDeliveryPlanItem plan : planList) {
            Assert.isNotBlank((String)plan.getPurOrderNo(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u4e2d\u7684\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemNo(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8ba2\u5355\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemId(), (String)"\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getChangeStatus(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getChangeReason(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8d23\u4efb\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)plan.getDeliveryDate(), (String)"\u8ba1\u5212\u53d1\u8d27\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)plan.getDeliveryQuantity(), (String)"\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            if (!PlanChangeStatusEnum.PUR_CONFIRM.getValue().equals(plan.getChangeStatus()) && !PlanChangeStatusEnum.PUR_CHANGE.getValue().equals(plan.getChangeStatus())) {
                throw new CommonException("\u65e0\u6cd5\u8bc6\u522b\u9001\u8d27\u901a\u77e5\u5355\u7684\u64cd\u4f5c");
            }
            if (!PlanChangeStatusEnum.PUR_CHANGE.getValue().equals(plan.getChangeStatus()) || (plan.getOnwayQuantity() == null || plan.getOnwayQuantity().compareTo(BigDecimal.ZERO) <= 0) && (plan.getReceivedQuantity() == null || plan.getReceivedQuantity().compareTo(BigDecimal.ZERO) <= 0)) continue;
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u5df2\u7ecf\u53d1\u8d27\uff0c\u4e0d\u80fd\u53d8\u66f4", plan.getPurOrderNo(), plan.getPurOrderItemNo()));
        }
    }
}

