/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.utils;

import com.els.base.common.ContextUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.utils.SpringContextHolder;
import com.els.liby.organization.entity.OrganizationExample;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.multipart.MultipartFile;

public class JitPlanImportUtilsCp {
    private static final Logger log = LoggerFactory.getLogger(JitPlanImportUtilsCp.class);
    static SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static int dayRowIndex = 0;
    static int timeRowIndex = 1;
    static int rowStartIndex = 2;
    static int dayCellStartIndex = 10;
    static Company purCompany = null;
    static Set<String> companySet = new HashSet<String>();
    static Set<String> materialSet = new HashSet<String>();
    static Set<String> factorySet = new HashSet<String>();

    public static List<SupDeliveryPlanItem> importJITExcelDataToMap(MultipartFile file, Company company) {
        long startTime = System.currentTimeMillis();
        log.debug("\u8868\u683c\u751f\u6210\u5f00\u59cb");
        Workbook workbook = JitPlanImportUtilsCp.getWorkbok(file);
        long endTime = System.currentTimeMillis();
        log.debug(MessageFormat.format("\u8868\u683c\u751f\u6210\u65f6\u95f4{0}", startTime - endTime));
        Sheet sheet = workbook.getSheetAt(0);
        long startTime1 = System.currentTimeMillis();
        List<List<Cell>> allRows = JitPlanImportUtilsCp.getAllRows(sheet);
        long endTime1 = System.currentTimeMillis();
        log.debug(MessageFormat.format("\u8868\u683c\u89e3\u6790\u65f6\u95f4{0}", startTime1 - endTime1));
        if (allRows.size() < 3) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Date> dateList = null;
        dateList = JitPlanImportUtilsCp.getDateList(allRows.get(dayRowIndex), allRows.get(timeRowIndex));
        if (CollectionUtils.isEmpty(dateList)) {
            throw new CommonException("\u9700\u6c42\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<SupDeliveryPlanItem> allPlanList = new ArrayList<SupDeliveryPlanItem>();
        for (int i = rowStartIndex; i < allRows.size(); ++i) {
            JitPlanImportUtilsCp.validRow(allRows.get(i), i);
            List<Cell> materialPlanRow = allRows.get(i);
            SupDeliveryPlanItem plan = JitPlanImportUtilsCp.buildPlan(materialPlanRow, company == null ? JitPlanImportUtilsCp.getPurCompany() : company);
            ArrayList<Cell> quantityCells = materialPlanRow.size() >= dayCellStartIndex ? materialPlanRow.subList(dayCellStartIndex, materialPlanRow.size()) : new ArrayList<Cell>();
            List<SupDeliveryPlanItem> planList = JitPlanImportUtilsCp.buildPlanList(plan, quantityCells, dateList);
            allPlanList.addAll(planList);
        }
        return allPlanList;
    }

    private static Company getPurCompany() {
        if (purCompany == null) {
            CompanyExample companyExample = new CompanyExample();
            companyExample.createCriteria().andCompanyCodeEqualTo("51000000");
            List list = ((CompanyService)SpringContextHolder.getOneBean(CompanyService.class)).queryAllObjByExample((IExample)companyExample);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new CommonException("\u91c7\u8d2d\u4fe1\u606f\u4e3a\u7a7a");
            }
            purCompany = (Company)list.get(0);
        }
        return purCompany;
    }

    private static List<SupDeliveryPlanItem> buildPlanList(SupDeliveryPlanItem plan, List<Cell> quantityCells, List<Date> dateList) {
        ArrayList<SupDeliveryPlanItem> planList = new ArrayList<SupDeliveryPlanItem>();
        Date today = DateUtils.truncate((Date)new Date(), (int)5);
        int size = quantityCells.size() >= dateList.size() ? dateList.size() : quantityCells.size();
        for (int i = 0; i < size; ++i) {
            Cell quantityCell = quantityCells.get(i);
            if (quantityCell == null) continue;
            quantityCell.setCellType(CellType.STRING);
            String content = quantityCell.getStringCellValue();
            if (StringUtils.isBlank((String)content)) continue;
            BigDecimal quantity = null;
            try {
                quantity = new BigDecimal(content);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'" + content + "'\u65e0\u6cd5\u8f6c\u4e3a\u6570\u5b57!");
            }
            if (dateList.get(i) == null) {
                log.warn("EVENT=JIT\u5bfc\u5165excel\uff1a\u6570\u91cf[{}],index[{}],\u7f3a\u5c11\u65e5\u671f", (Object)quantity, (Object)i);
                continue;
            }
            if (dateList.get(i).getTime() < today.getTime()) {
                log.warn("EVENT=JIT\u5bfc\u5165excel\uff1a\u8fc7\u6ee4\u5386\u53f2\u65e5\u671f[{}]", (Object)DateFormatUtils.format((Date)dateList.get(i), (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            SupDeliveryPlanItem planItem = new SupDeliveryPlanItem();
            BeanUtils.copyProperties((Object)plan, (Object)planItem);
            planItem.setDeliveryDate(dateList.get(i));
            planItem.setDeliveryQuantity(quantity);
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                planItem.setIsEnable(Constant.NO_INT);
            } else {
                planItem.setIsEnable(Constant.YES_INT);
            }
            planList.add(planItem);
        }
        return planList;
    }

    private static void validRow(List<Cell> row, int i) {
        if (CollectionUtils.isNotEmpty(row)) {
            JitPlanImportUtilsCp.vaidFactory(JitPlanImportUtilsCp.getValue(row.get(0)), i);
            JitPlanImportUtilsCp.vaidSupCompany(JitPlanImportUtilsCp.getValue(row.get(2)), i);
            JitPlanImportUtilsCp.vaidMaterial(JitPlanImportUtilsCp.getValue(row.get(6)), i);
        }
    }

    private static SupDeliveryPlanItem buildPlan(List<Cell> row, Company company) {
        String factorycode = row.size() >= 1 ? JitPlanImportUtilsCp.getValue(row.get(0)) : "";
        String factoryName = row.size() >= 2 ? JitPlanImportUtilsCp.getValue(row.get(1)) : "";
        String supCompanyName = row.size() >= 3 ? JitPlanImportUtilsCp.getValue(row.get(2)) : "";
        String supCompanySapCode = row.size() >= 4 ? JitPlanImportUtilsCp.getValue(row.get(3)) : "";
        String finishedProductCode = row.size() >= 5 ? JitPlanImportUtilsCp.getValue(row.get(4)) : "";
        String finishedProductDesc = row.size() >= 6 ? JitPlanImportUtilsCp.getValue(row.get(5)) : "";
        String materialNo = row.size() >= 7 ? JitPlanImportUtilsCp.getValue(row.get(6)) : "";
        String materialDesc = row.size() >= 8 ? JitPlanImportUtilsCp.getValue(row.get(7)) : "";
        String purRemark = row.size() >= 9 ? JitPlanImportUtilsCp.getValue(row.get(8)) : "";
        SupDeliveryPlanItem item = new SupDeliveryPlanItem();
        item.setFactoryCode(factorycode);
        item.setFactoryName(factoryName);
        item.setMaterialNo(materialNo);
        item.setMaterialDesc(materialDesc);
        item.setSupCompanyName(supCompanyName);
        item.setSupCompanySapCode(supCompanySapCode);
        item.setPurCompanySapCode(company.getCompanySapCode());
        item.setPurCompanyName(company.getCompanyName());
        item.setPurCompanySrmCode(company.getCompanyCode());
        item.setPurCompanyId(company.getId());
        item.setProjectId(company.getProjectId());
        item.setFinishedProductCode(finishedProductCode);
        item.setFinishedProductDesc(finishedProductDesc);
        item.setPurRemark(StringUtils.isNotBlank((String)purRemark) ? purRemark : "\u5bfc\u5165");
        return item;
    }

    private static List<Date> getDateList(List<Cell> dayRow, List<Cell> timeRow) {
        if (dayRow.size() < dayCellStartIndex) {
            throw new CommonException("\u65e5\u671f\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (timeRow.size() < dayCellStartIndex) {
            throw new CommonException("\u65f6\u95f4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        dayRow = dayRow.subList(dayCellStartIndex, dayRow.size());
        timeRow = timeRow.subList(dayCellStartIndex, timeRow.size());
        ArrayList<Date> dateList = new ArrayList<Date>(dayRow.size());
        for (int i = 0; i < dayRow.size(); ++i) {
            Cell dayCell = dayRow.get(i);
            dayCell.setCellType(CellType.STRING);
            String dateStr = dayCell.getStringCellValue();
            Cell timeCell = timeRow.size() <= i ? null : timeRow.get(i);
            if (timeCell == null & StringUtils.isNotBlank((String)dateStr)) {
                throw new CommonException(String.format("\u65f6\u95f4\u4e3a\u7a7a", new Object[0]));
            }
            if (timeCell == null & StringUtils.isBlank((String)dateStr)) {
                dateList.add(null);
                continue;
            }
            if (dateStr.trim().length() != 8) {
                throw new CommonException(String.format("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e:[%s]", dateStr));
            }
            timeCell.setCellType(CellType.STRING);
            String time = timeCell.getStringCellValue();
            String dateTimeStr = String.format("%s %s", dateStr, time);
            Date date = null;
            if (StringUtils.isBlank((String)dateTimeStr)) {
                dateList.add(null);
                continue;
            }
            try {
                date = DateUtils.parseDate((String)dateTimeStr, (String[])new String[]{"yyyyMMdd HHmm"});
            }
            catch (Exception e) {
                throw new CommonException(String.format("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e:[%s] [%s]", dateStr, time));
            }
            dateList.add(date);
        }
        return dateList;
    }

    private static void vaidSupCompany(String companyName, int rowNum) {
        Assert.isNotBlank((String)companyName, (String)("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (rowNum + 1) + "\u884c\u4f9b\u5e94\u5546\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        if (companySet.add(companyName)) {
            CompanyExample example = new CompanyExample();
            example.createCriteria().andCompanyNameEqualTo(companyName);
            List lists = ContextUtils.getCompanyService().queryAllObjByExample((IExample)example);
            if (lists.size() != 1) {
                throw new CommonException("\u7b2c" + (rowNum + 1) + "\u884c\u4f9b\u5e94\u5546\u7b80\u79f0<" + companyName + ">\u9519\u8bef");
            }
        }
    }

    private static void vaidMaterial(String materialCode, int rowNum) {
        Assert.isNotBlank((String)materialCode, (String)("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (rowNum + 1) + "\u884c\u7269\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        if (materialSet.add(materialCode) && !ContextUtils.getMaterialService().isExists(materialCode).booleanValue()) {
            throw new CommonException("\u7b2c" + (rowNum + 1) + "\u884c\u7269\u6599\u7f16\u7801<" + materialCode + ">\u4e0d\u5b58\u5728");
        }
    }

    private static void vaidFactory(String factoryCode, int rowNum) {
        Assert.isNotBlank((String)factoryCode, (String)("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (rowNum + 1) + "\u884c\u5de5\u5382\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        if (factorySet.add(factoryCode)) {
            OrganizationExample example = new OrganizationExample();
            example.createCriteria().andCodeEqualTo(factoryCode).andOrganizationTypeEqualTo("T001W");
            List lists = ContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)lists, (String)("\u7b2c" + (rowNum + 1) + "\u884c\u5de5\u5382\u4ee3\u7801<" + factoryCode + ">\u4e0d\u5b58\u5728"));
        }
    }

    private static List<List<Cell>> getAllRows(Sheet sheet) {
        ArrayList<List<Cell>> allRows = new ArrayList<List<Cell>>();
        for (Row row : sheet) {
            int end = row.getLastCellNum() < 0 ? 0 : row.getLastCellNum();
            ArrayList<Cell> cells = new ArrayList<Cell>(end);
            for (int i = 0; i < end; ++i) {
                cells.add(row.getCell(i));
            }
            allRows.add(cells);
        }
        return allRows;
    }

    private static String getValue(Cell cell) {
        String obj = "";
        if (cell != null) {
            switch (cell.getCellTypeEnum()) {
                case NUMERIC: {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = cell.getDateCellValue();
                        obj = sdf.format(date);
                        break;
                    }
                    DecimalFormat df = new DecimalFormat("0");
                    obj = df.format(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    obj = cell.getStringCellValue();
                    break;
                }
            }
        }
        obj = obj.replaceAll("\r|\n", "");
        return obj.trim();
    }

    public static Workbook getWorkbok(MultipartFile file) {
        HSSFWorkbook wb = null;
        try {
            InputStream in = file.getInputStream();
            wb = new HSSFWorkbook(in);
        }
        catch (Exception e) {
            try {
                InputStream in = file.getInputStream();
                wb = new XSSFWorkbook(in);
            }
            catch (Exception e1) {
                throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
        }
        return wb;
    }

    public static void main(String[] args) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        System.out.println(list);
    }
}

