/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.plan.command.dataSources.CreateDataSourcesCmd;
import com.els.base.plan.command.dataSources.ImportDataSourcesCmd;
import com.els.base.plan.entity.JitPlanDataSources;
import com.els.base.plan.entity.JitPlanDataSourcesExample;
import com.els.base.plan.service.JitPlanDataSourcesService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.excel.YesOrNoIntegerConverter;
import com.els.liby.forecast.util.ExcelFileData;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="JIT\u9001\u8d27\u901a\u77e5\u5355\u6570\u636e\u6765\u6e90")
@Controller
@RequestMapping(value={"jitPlanDataSources"})
public class JitPlanDataSourcesController {
    private static final Logger logger = LoggerFactory.getLogger(JitPlanDataSourcesController.class);
    @Resource
    protected JitPlanDataSourcesService jitPlanDataSourcesService;
    @Resource
    private OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaJIT\u9001\u8d27\u901a\u77e5\u5355\u6570\u636e\u6765\u6e90")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody JitPlanDataSources jitPlanDataSources) {
        CreateDataSourcesCmd cmd = new CreateDataSourcesCmd(jitPlanDataSources);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success((Object)jitPlanDataSources.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91JIT\u9001\u8d27\u901a\u77e5\u5355\u6570\u636e\u6765\u6e90")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody JitPlanDataSources jitPlanDataSources) {
        Assert.isNotBlank((String)jitPlanDataSources.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        jitPlanDataSources.setLastUpdateTime(new Date());
        this.jitPlanDataSourcesService.modifyObj(jitPlanDataSources);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664JIT\u9001\u8d27\u901a\u77e5\u5355\u6570\u636e\u6765\u6e90")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.createCriteria().andIdIn((List)ids);
        this.jitPlanDataSourcesService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2JIT\u9001\u8d27\u901a\u77e5\u5355\u6570\u636e\u6765\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 JitPlanDataSources", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<JitPlanDataSources>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.setPageView((PageView<JitPlanDataSources>)new PageView(pageNo, pageSize));
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        JitPlanDataSourcesExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.jitPlanDataSourcesService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5f00\u542fASPROVE")
    @RequestMapping(value={"service/openAsp"})
    @ResponseBody
    public ResponseResult<String> openAsp(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5f00\u542f\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.jitPlanDataSourcesService.openAspByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5173\u95edASPROVE")
    @RequestMapping(value={"service/coloseAsp"})
    @ResponseBody
    public ResponseResult<String> coloseAsp(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5173\u95ed\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.jitPlanDataSourcesService.coloseAspByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7excel\u5bfc\u5165JIT\u6570\u636e\u6e90\u63a7\u5236")
    @ResponseBody
    @RequestMapping(value={"service/importByExcel"})
    public ResponseResult<String> importByExcel(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        String fileName = file.getOriginalFilename();
        InputStream inputStream = file.getInputStream();
        List<TitleAndModelKey> titleAndModelKeyList = this.getTitleAndModelKeys();
        ArrayList<JitPlanDataSources> datas = new ArrayList();
        try {
            datas = ExcelUtils.importExcelDataToMap((InputStream)inputStream, (int)0, (int)1, (int)0, titleAndModelKeyList, JitPlanDataSources.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u8f6c\u6362\u5931\u8d25dataSet=%s", (Object)new Gson().toJson(datas));
            throw new CommonException(e.getMessage());
        }
        logger.info(String.format("event=\u901a\u8fc7excel\u5bfc\u5165JIT\u6570\u636e\u6e90\u63a7\u5236|file_name=%s|dataSet=%s", fileName, new Gson().toJson(datas)));
        if (CollectionUtils.isEmpty(datas)) {
            throw new CommonException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User loginUser = SpringSecurityUtils.getLoginUser();
        ImportDataSourcesCmd cmd = new ImportDataSourcesCmd(datas);
        cmd.setPurUser(loginUser);
        this.invoker.invoke(cmd);
        return ResponseResult.success((Object)"\u6210\u529f\u5bfc\u5165");
    }

    @ApiOperation(httpMethod="GET", value="\u4e0b\u8f7d\u5bfc\u5165excel\u6a21\u677f")
    @RequestMapping(value={"service/exportTemplateFile"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<String> exportTemplateFile(HttpServletResponse response) {
        try {
            String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
            this.setDownLoadHeader(response, MessageFormat.format("JIT\u6570\u636e\u6e90-{0}.xls", dateStr));
            ServletOutputStream outputStream = response.getOutputStream();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, this.getTitleAndModelKeys(), null, (String)"JIT\u6570\u636e\u6e90", null, (int)0);
            writableWorkbook.write();
            writableWorkbook.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    @ApiOperation(value="JIT\u6570\u636e\u6e90\u63a7\u5236\uff0c\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseResult<FileData> export(@RequestBody(required=false) QueryParamWapper wapper) throws ParseException, IOException, WriteException {
        List datas = new ArrayList();
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.setOrderByClause("LAST_UPDATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        datas = this.jitPlanDataSourcesService.queryAllObjByExample((IExample)example);
        List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();
        YesOrNoIntegerConverter yesNoIntConverter = new YesOrNoIntegerConverter();
        TitleAndModelKey isOpenAsp = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u542f\u52a8ASPROVE", (String)"isOpenAsp");
        isOpenAsp.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        titleAndModelKeys.add(isOpenAsp);
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, datas, (String)"JIT\u6570\u636e\u6e90", (String)MessageFormat.format("JIT\u6570\u636e\u6e90-{0}.xls", dateStr), (int)0);
        return ResponseResult.success((Object)fileData);
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u53ea\u63a5\u53d7.xls\u6587\u4ef6\u5bfc\u5165");
        }
        return file;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382\u7f16\u7801\uff08\u5fc5\u586b\uff09", (String)"factory", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382\u540d\u79f0", (String)"factoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801\uff08\u5fc5\u586b\uff09", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        return titleAndModelKeys;
    }

    private void setDownLoadHeader(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-msdownload;");
    }
}

