/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSendToPurCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class ImportSupDonePlanItemCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<SupDeliveryPlanItem> supDeliveryPlanItemList;

    public ImportSupDonePlanItemCmd(List<SupDeliveryPlanItem> planItems) {
        this.supDeliveryPlanItemList = planItems;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supDeliveryPlanItemList);
        Map<String, List<SupDeliveryPlanItem>> orderNoAndPlanList = this.supDeliveryPlanItemList.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderNo));
        Set<String> orderNoList = orderNoAndPlanList.keySet();
        orderNoList.forEach(orderNo -> this.importPlanItemForOrder((String)orderNo, (List)orderNoAndPlanList.get(orderNo)));
        return null;
    }

    private void importPlanItemForOrder(String orderNo, List<SupDeliveryPlanItem> list) {
        Map<String, List<SupDeliveryPlanItem>> orderItemNoAndPlanList = list.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderItemNo));
        ArrayList<String> orderItemNoList = new ArrayList<String>();
        orderItemNoList.addAll(orderItemNoAndPlanList.keySet());
        orderItemNoList.sort(String::compareTo);
        for (String orderItemNo : orderItemNoList) {
            List<SupDeliveryPlanItem> planItemList = orderItemNoAndPlanList.get(orderItemNo);
            this.importPlanItemForOrderItem(orderNo, orderItemNo, planItemList);
        }
    }

    private void importPlanItemForOrderItem(String orderNo, String orderItemNo, List<SupDeliveryPlanItem> planItemList) {
        List<PurDeliveryPlanItem> currentPlanItemList = this.queryPlanItem(orderNo, orderItemNo);
        Assert.isNotNull(currentPlanItemList, (String)String.format("\u8ba2\u5355\u884c[%s][%s]\u6ca1\u6709\u8ba1\u5212", orderNo, orderItemNo));
        if (DeliveryPlanUtils.isEqualBewteenPurAndSup(currentPlanItemList, planItemList)) {
            return;
        }
        List<SupDeliveryPlanItem> refusePlanList = planItemList.stream().map(planItem -> {
            SupDeliveryPlanItem temp = new SupDeliveryPlanItem();
            BeanUtils.copyProperties(currentPlanItemList.get(0), (Object)temp);
            temp.setDeliveryDate(planItem.getDeliveryDate());
            temp.setDeliveryQuantity(planItem.getDeliveryQuantity());
            temp.setChangeStatus(PlanChangeStatusEnum.SUP_CHANGE.getValue());
            temp.setChangeReason(planItem.getChangeReason());
            temp.setSupRemark(planItem.getSupRemark());
            temp.setId(null);
            return temp;
        }).collect(Collectors.toList());
        NoneJitPlanSendToPurCmd sendToPurCmd = new NoneJitPlanSendToPurCmd(refusePlanList, PlanDataSourceEnum.EXCEL);
        sendToPurCmd.copyProperties(this);
        this.context.invoke(sendToPurCmd);
    }

    private List<PurDeliveryPlanItem> queryPlanItem(String orderNo, String orderItemNo) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoEqualTo(orderNo).andPurOrderItemNoEqualTo(orderItemNo);
        return ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
    }

    private void valid(List<SupDeliveryPlanItem> planItems) {
        Assert.isNotEmpty(planItems, (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (SupDeliveryPlanItem planItem : planItems) {
            Assert.isNotBlank((String)planItem.getPurOrderNo(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)planItem.getPurOrderItemNo(), (String)"\u8ba2\u5355\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)planItem.getDeliveryDate(), (String)"\u5b9e\u9645\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)planItem.getDeliveryQuantity(), (String)"\u9001\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            if (BigDecimal.ZERO.compareTo(planItem.getDeliveryQuantity()) > 0) {
                throw new CommonException(String.format("\u8ba2\u5355[%s][%s] \u9001\u8d27\u6570\u91cf\u5c0f\u4e8e0", planItem.getPurOrderNo(), planItem.getPurOrderItemNo()));
            }
            planItem.setPurOrderItemNo(StringUtils.leftPad((String)planItem.getPurOrderItemNo(), (int)5, (String)"0"));
        }
    }
}

