/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.web.controller;

import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.command.order.sup.BatchConfirmOrRefuseOrderItemCommand;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9500\u552e\u8ba2\u5355\u884c")
@Controller
@RequestMapping(value={"supplierOrderItem"})
public class SupplierOrderItemController {
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected SupplierOrderService supplierOrderService;
    @Resource
    protected OrderCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u9500\u552e\u8ba2\u5355\u53f7\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findBySupplierOrder"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findBySupplierOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u91c7\u8d2d\u8ba2\u5355\u53f7") String orderId, @ApiParam(value="\u662f\u5426\u5b8c\u6210\u6807\u8bc6") String finishFlag) {
        if (StringUtils.isBlank((String)orderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u91c7\u8d2d\u8ba2\u5355\u53f7"});
        }
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
        criteria.andIsEnableNotEqualTo(0);
        if (finishFlag != null) {
            criteria.andFinishFlagEqualTo(finishFlag);
        }
        example.setOrderByClause("HAVE_CHANGE DESC, MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        PageView pageData = this.supplierOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u9001\u8d27\uff0c\u65b0\u5efa\u9001\u8d27\u5355\u5217\u8868")
    @RequestMapping(value={"service/findSupplierOrderItemByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParams) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsCanDeliveryNotEqualTo(Constant.NO_INT);
        if (queryParams != null) {
            for (int i = 0; i < example.getOredCriteria().size(); ++i) {
                CriteriaUtils.addCriterion((Object)example.getOredCriteria().get(i), (QueryParamWapper)queryParams);
            }
        }
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u9884\u4ed8\u6b3e\u5355\u67e5\u8be2\u754c\u9762")
    @RequestMapping(value={"service/findAdvancedPayBillByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findAdvancedPayBillByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParams) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andFinishFlagEqualTo("N").andAvailableApplyMoneyGreaterThan(BigDecimal.ZERO);
        if (queryParams != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParams);
        }
        PageView pageData = this.supplierOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\uff1a\u91c7\u7528\u539f\u6765\u65e7\u7684\u4f20\u503c\u65b9\u5f0f")
    @RequestMapping(value={"service/findSupplierOrderItemByPageForInvoice"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemByPageForInvoice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParamWapper) throws ParseException {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SUP_MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria cri = example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId());
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion((Object)cri, (QueryParamWapper)queryParamWapper);
        }
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\uff08\u91c7\u8d2d\u65b9\uff09\uff1a\u91c7\u7528\u539f\u6765\u65e7\u7684\u4f20\u503c\u65b9\u5f0f")
    @RequestMapping(value={"service/findSupplierOrderItemForPurchaseByPageForInvoice"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemForPurchaseByPageForInvoice(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParamWapper) throws ParseException {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria cri = example.createCriteria().andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andProjectIdEqualTo(ProjectUtils.getProjectId());
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion((Object)cri, (QueryParamWapper)queryParamWapper);
        }
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u884c")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u901a\u7528\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=true) QueryParamWapper wapper) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("HAVE_CHANGE DESC, MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        PageView pageData = this.supplierOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8ba2\u5355\u884c\u786e\u8ba4\u6216\u62d2\u7edd")
    @RequestMapping(value={"service/confirmOrRefuseOrderItem"})
    @ResponseBody
    public ResponseResult<String> confirmOrRefuseOrderItem(@RequestBody List<SupplierOrderItem> orderItemList) {
        Assert.isNotEmpty(orderItemList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        BatchConfirmOrRefuseOrderItemCommand command = new BatchConfirmOrRefuseOrderItemCommand(orderItemList);
        this.invoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4f9b\u5e94\u5546\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c\u660e\u7ec6")
    @RequestMapping(value={"service/findForSup"})
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findForSup(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView((PageView<SupplierOrderItem>)new PageView(pageNo, pageSize));
        example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        example.setOrderByClause("ORDER_NO DESC, ORDER_ITEM_NO ASC");
        CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        PageView page = this.supplierOrderItemService.queryObjByPage((IExample)example);
        if (CollectionUtils.isEmpty((Collection)page.getQueryResult())) {
            return ResponseResult.success((Object)page);
        }
        page.getQueryResult().forEach(orderItem -> {
            SupplierOrder order = (SupplierOrder)this.supplierOrderService.queryObjById(orderItem.getOrderId());
            orderItem.setOrder(order);
        });
        return ResponseResult.success((Object)page);
    }
}

