/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.command.SendCommand;
import com.els.base.delivery.command.ViewDeliveryOrderDetailCmd;
import com.els.base.delivery.entity.DeliveryOrder;
import java.util.List;

public class BatchSendCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<String> deliveryOrderIdList;

    public BatchSendCommand(List<String> deliveryOrderIdList) {
        this.deliveryOrderIdList = deliveryOrderIdList;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.deliveryOrderIdList, (String)"\u9001\u8d27\u5355id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (String deliveryOrderId : this.deliveryOrderIdList) {
            ViewDeliveryOrderDetailCmd viewDeliveryOrderDetailCmd = new ViewDeliveryOrderDetailCmd(deliveryOrderId);
            DeliveryOrder deliveryOrder = context.invoke(viewDeliveryOrderDetailCmd);
            SendCommand sendCommand = new SendCommand(deliveryOrder);
            sendCommand.copyProperties(this);
            context.invoke(sendCommand);
        }
        return null;
    }
}

