/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class PreviewDeliveryOrderItemByPlanCmd
extends AbstractCommand<List<DeliveryOrderItem>> {
    private static final long serialVersionUID = 1L;
    private String deliveryOrderNo;
    private List<SupDeliveryPlanItem> deliveryPlanItemList;

    public PreviewDeliveryOrderItemByPlanCmd(List<SupDeliveryPlanItem> deliveryPlanItemList) {
        this.deliveryPlanItemList = deliveryPlanItemList;
    }

    public PreviewDeliveryOrderItemByPlanCmd(List<SupDeliveryPlanItem> deliveryPlanItemList, String deliveryOrderNo) {
        this.deliveryPlanItemList = deliveryPlanItemList;
        this.deliveryOrderNo = deliveryOrderNo;
    }

    @Override
    public List<DeliveryOrderItem> execute(ICommandInvoker context) {
        this.valid(this.deliveryPlanItemList);
        this.deliveryPlanItemList.stream().sorted(this.comparePlan());
        ArrayList<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        for (SupDeliveryPlanItem supDeliverPlan : this.deliveryPlanItemList) {
            SupplierOrderItem supplierOrderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(supDeliverPlan.getPurOrderItemId());
            this.valid(supplierOrderItem);
            SupplierOrder supplierOrder = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(supDeliverPlan.getPurOrderId());
            DeliveryOrderItem deliveryOrderItem = this.convertDeliveryOrderItem(supplierOrder, supplierOrderItem, supDeliverPlan);
            items.add(deliveryOrderItem);
        }
        Set locationSet = items.stream().map(SupplierOrderItem2 -> SupplierOrderItem2.getDeliveryLocation()).collect(Collectors.toSet());
        if (locationSet.size() > 1) {
            throw new CommonException("\u9001\u8d27\u5730\u5740\u4e0d\u540c\uff0c\u4e0d\u80fd\u751f\u6210\u540c\u4e00\u5f20\u9001\u8d27\u5355");
        }
        return items;
    }

    private Comparator<? super SupDeliveryPlanItem> comparePlan() {
        return (dp1, dp2) -> {
            int compare = dp1.getDeliveryDate().compareTo(dp2.getDeliveryDate());
            if (compare != 0) {
                return compare;
            }
            compare = dp1.getPurOrderNo().compareTo(dp2.getPurOrderNo()) * -1;
            if (compare != 0) {
                return compare;
            }
            compare = dp1.getPurOrderItemNo().compareTo(dp2.getPurOrderItemNo());
            return compare;
        };
    }

    private void valid(SupplierOrderItem supplierOrderItem) {
        Assert.isNotNull((Object)supplierOrderItem, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u884c");
        if (!PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(supplierOrderItem.getOrderStatus())) {
            throw new CommonException(String.format("\u8ba2\u5355\u884c[%s][%s],\u672a\u786e\u8ba4\uff0c\u4e0d\u80fd\u5efa\u9001\u8d27\u5355", supplierOrderItem.getOrderNo(), supplierOrderItem.getOrderItemNo()));
        }
        if ("Y".equals(supplierOrderItem.getFinishFlag())) {
            throw new CommonException(String.format("\u8ba2\u5355\u884c[%s][%s],\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u5efa\u9001\u8d27\u5355", supplierOrderItem.getOrderNo(), supplierOrderItem.getOrderItemNo()));
        }
        if (Constant.NO_INT.equals(supplierOrderItem.getIsEnable())) {
            throw new CommonException(String.format("\u8ba2\u5355\u884c[%s][%s],\u5df2\u7ecf\u5220\u9664\uff0c\u4e0d\u80fd\u5efa\u9001\u8d27\u5355", supplierOrderItem.getOrderNo(), supplierOrderItem.getOrderItemNo()));
        }
    }

    private DeliveryOrderItem convertDeliveryOrderItem(SupplierOrder supplierOrder, SupplierOrderItem supplierOrderItem, SupDeliveryPlanItem supDeliverPlan) {
        Assert.isNotNull((Object)supplierOrderItem, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
        deliveryOrderItem.setSupOrderItem(supplierOrderItem);
        deliveryOrderItem.setSupDeliveryPlanItem(supDeliverPlan);
        BeanUtils.copyProperties((Object)supplierOrderItem, (Object)deliveryOrderItem);
        deliveryOrderItem.setId(null);
        deliveryOrderItem.setDeliveryPlanItemId(supDeliverPlan.getId());
        BigDecimal minDeliveryQuantity = BigDecimal.ZERO;
        minDeliveryQuantity = supDeliverPlan.getCanDeliveryQuantity().compareTo(supplierOrderItem.getCanDeliveryQuantity()) > 0 ? supplierOrderItem.getCanDeliveryQuantity() : supDeliverPlan.getCanDeliveryQuantity();
        deliveryOrderItem.setDeliveryQuantity(minDeliveryQuantity);
        deliveryOrderItem.setCanDeliveryQuantity(minDeliveryQuantity);
        deliveryOrderItem.setOnwayQuantity(supDeliverPlan.getOnwayQuantity());
        deliveryOrderItem.setQuantity(supDeliverPlan.getDeliveryQuantity());
        deliveryOrderItem.setIsJit(supDeliverPlan.getIsJit());
        BigDecimal receivedQuantity = supDeliverPlan.getReceivedQuantity();
        if (receivedQuantity != null) {
            deliveryOrderItem.setReceiptQuantity(receivedQuantity.toString());
        } else {
            deliveryOrderItem.setReceiptQuantity("0");
        }
        deliveryOrderItem.setDeliveryDate(supDeliverPlan.getDeliveryDate());
        deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_SENT.getValue());
        deliveryOrderItem.setPurCompanyId(supplierOrderItem.getPurCompanyId());
        deliveryOrderItem.setPurCompanyName(supplierOrderItem.getPurCompanyName());
        deliveryOrderItem.setPurCompanyCode(supplierOrderItem.getPurCompanySapCode());
        deliveryOrderItem.setPurUserId(supDeliverPlan.getPurPlanerId());
        deliveryOrderItem.setPurUserName(supplierOrder.getPurPlanerName());
        if (this.getSupUser() != null) {
            deliveryOrderItem.setUserId(this.getSupUser().getId());
            deliveryOrderItem.setUserName(this.getSupUser().getNickName());
        } else {
            deliveryOrderItem.setUserId(supplierOrderItem.getSupUserId());
            deliveryOrderItem.setUserName(supplierOrderItem.getSupUserName());
        }
        deliveryOrderItem.setCompanyCode(supplierOrderItem.getSupCompanySapCode());
        if (this.getSupCompany() != null) {
            deliveryOrderItem.setCompanyId(this.getSupCompany().getId());
            deliveryOrderItem.setCompanyName(this.getSupCompany().getCompanyFullName());
        } else {
            deliveryOrderItem.setCompanyId(supplierOrderItem.getSupCompanyId());
            deliveryOrderItem.setCompanyName(supplierOrderItem.getSupCompanyName());
        }
        deliveryOrderItem.setPurOrderId(supplierOrderItem.getOrderId());
        deliveryOrderItem.setPurOrderNo(supplierOrderItem.getOrderNo());
        deliveryOrderItem.setPurOrderItemId(supplierOrderItem.getId());
        deliveryOrderItem.setPurOrderItemNo(supplierOrderItem.getOrderItemNo());
        deliveryOrderItem.setFactoryCode(supplierOrderItem.getFactory());
        deliveryOrderItem.setTaxCode(supplierOrderItem.getTaxCode());
        deliveryOrderItem.setTaxAmount(supplierOrderItem.getTaxTotalPrice());
        deliveryOrderItem.setNoTaxAmount(supplierOrderItem.getUntaxTotalPrice());
        deliveryOrderItem.setTaxPrice(supplierOrderItem.getTaxUnitPrice());
        deliveryOrderItem.setMaterialDesc(supplierOrderItem.getMaterialName());
        deliveryOrderItem.setMaterialNo(supplierOrderItem.getMaterialCode());
        deliveryOrderItem.setSupplierMaterialNumber(supplierOrderItem.getSupMaterialCode());
        deliveryOrderItem.setDeliveryMaterialName(supplierOrderItem.getIndustryStandard());
        deliveryOrderItem.setDepartmentId(supplierOrderItem.getMaterialCategoryId());
        deliveryOrderItem.setDepartmentName(supplierOrderItem.getMaterialCategoryName());
        deliveryOrderItem.setWarehouseCode(supplierOrderItem.getWarehouseLocation());
        deliveryOrderItem.setWarehouseName(supplierOrderItem.getWarehouseName());
        deliveryOrderItem.setChineseName(supplierOrderItem.getIndustryStandard());
        return deliveryOrderItem;
    }

    private void valid(List<SupDeliveryPlanItem> deliveryPlanItemList) {
        for (SupDeliveryPlanItem supDeliveryPlanItem : deliveryPlanItemList) {
            if (Constant.NO_INT.equals(supDeliveryPlanItem.getSupConfirmStatus())) {
                throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355[%s][%s],\u4f9b\u5e94\u5546\u672a\u786e\u8ba4\uff0c\u65e0\u6cd5\u5efa\u9001\u8d27\u5355", supDeliveryPlanItem.getPurOrderNo(), supDeliveryPlanItem.getPurOrderItemNo()));
            }
            if (Constant.NO_INT.equals(supDeliveryPlanItem.getPurConfirmStatus())) {
                throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355[%s][%s],\u91c7\u8d2d\u65b9\u672a\u786e\u8ba4\uff0c\u65e0\u6cd5\u5efa\u9001\u8d27\u5355", supDeliveryPlanItem.getPurOrderNo(), supDeliveryPlanItem.getPurOrderItemNo()));
            }
            if (Constant.YES_INT.equals(supDeliveryPlanItem.getIsCanDelivery()) || this.isExistPlanItem(supDeliveryPlanItem, this.deliveryOrderNo)) continue;
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355[%s][%s],\u5df2\u7ecf\u53d1\u5b8c\u8d27\uff0c\u65e0\u6cd5\u5efa\u9001\u8d27\u5355", supDeliveryPlanItem.getPurOrderNo(), supDeliveryPlanItem.getPurOrderItemNo()));
        }
        Set orderNoSet = deliveryPlanItemList.stream().map(SupDeliveryPlanItem::getPurOrderNo).collect(Collectors.toSet());
        if (orderNoSet.size() > 1) {
            throw new CommonException("\u91c7\u8d2d\u8ba2\u5355\u53f7\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u751f\u6210\u540c\u4e00\u5f20\u9001\u8d27\u5355");
        }
    }

    private boolean isExistPlanItem(SupDeliveryPlanItem supDeliveryPlanItem, String deliveryOrderNo) {
        if (StringUtils.isBlank((String)deliveryOrderNo)) {
            return false;
        }
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo).andDeliveryPlanItemIdEqualTo(supDeliveryPlanItem.getId());
        List itemList = ContextUtils.getDeliveryOrderItemService().queryAllObjByExample((IExample)example);
        return CollectionUtils.isNotEmpty((Collection)itemList);
    }
}

