/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.entity.PurVoucher;
import com.els.base.delivery.entity.PurVoucherExample;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.delivery.web.vo.DeliveryOrderTypeEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.plan.command.ModifyPlanReceiveQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import com.els.base.purchase.command.order.UpdateReceiveQuantityCommand;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

public class ReceiveVoucherCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private static final String NAGATIVE_MARK = "-";
    private static final BigDecimal NAGATIVE_NUM = new BigDecimal(-1);
    private List<PurVoucher> vouchers;

    public ReceiveVoucherCommand(List<PurVoucher> vouchers) {
        this.vouchers = vouchers;
    }

    @Override
    public String execute(ICommandInvoker context) {
        if (CollectionUtils.isEmpty(this.vouchers)) {
            this.logger.warn("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u6536\u8d27\u51ed\u8bc1\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406");
            return null;
        }
        this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u6536\u5230\u51ed\u8bc1,\u5f85\u5904\u7406\u51ed\u8bc1 {} ", (Object)this.vouchers.size());
        this.vouchers.forEach(voucher -> this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u6536\u5230\u51ed\u8bc1\uff0c\u5f85\u5904\u7406\u51ed\u8bc1:vo{}-voi{}-po{}-poi{}-do{}-doi{}", new Object[]{voucher.getMaterialVoucherNo(), voucher.getMaterialVoucherItemNo(), voucher.getPurchaseOrderNo(), voucher.getPurchaseOrderItemNo(), voucher.getDeliveryOrderNo(), voucher.getDeliveryOrderItemNo()}));
        this.valid(this.vouchers);
        this.vouchers = this.distinctVoucher(this.vouchers);
        this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u8fc7\u6ee4\u91cd\u590d\u7684\u51ed\u8bc1,\u5f85\u5904\u7406\u51ed\u8bc1 {} ", (Object)this.vouchers.size());
        this.vouchers = this.filterExistVoucher(this.vouchers);
        this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u8fc7\u6ee4\u6389\u5df2\u7ecf\u5904\u7406\u8fc7\u7684\u51ed\u8bc1,\u5f85\u5904\u7406\u51ed\u8bc1 {} ", (Object)this.vouchers.size());
        this.completeVoucher(this.vouchers);
        this.vouchers.forEach(voucher -> this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u8fc7\u6ee4\u51fa\u5728\u7cfb\u7edf\u4e2d\u6709\u8ba2\u5355\u6570\u636e\u7684\u51ed\u8bc1\uff0c\u5f85\u5904\u7406\u51ed\u8bc1:vo{}-voi{}-po{}-poi{}-do{}-doi{}", new Object[]{voucher.getMaterialVoucherNo(), voucher.getMaterialVoucherItemNo(), voucher.getPurchaseOrderNo(), voucher.getPurchaseOrderItemNo(), voucher.getDeliveryOrderNo(), voucher.getDeliveryOrderItemNo()}));
        if (CollectionUtils.isEmpty(this.vouchers)) {
            return null;
        }
        List<PurchaseOrderItem> purItemList = this.queryPurOrderItemByVoucher(this.vouchers);
        try {
            this.updateReceiveQuantity(purItemList);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8ba2\u5355\u6536\u8d27\u6570\u91cf\u5f02\u5e38", (Throwable)e);
        }
        this.updateOnWayQuantity(this.vouchers);
        this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u6839\u636e\u51ed\u8bc1\uff0c\u66f4\u65b0\u5728\u9014\u6570\u91cf\u7ed3\u675f");
        return null;
    }

    public void sendToSupCompany(List<PurVoucher> voucherList1) {
        if (CollectionUtils.isNotEmpty(voucherList1)) {
            List<PurVoucher> purVoucherList = this.turnData(voucherList1);
            for (int i = 0; i < purVoucherList.size(); ++i) {
                PurVoucher purVoucher = purVoucherList.get(i);
                User supUser = ContextUtils.getCompanyUserRefService().queryMainUserOfCompany(purVoucher.getPurCompanyId());
                Message purVoucherMessage = Message.init((Object)purVoucher).setCompanyCode(purVoucher.getPurCompanySrmCode()).setBusinessTypeCode(DeliveryOrderTypeEnum.CONFIRM_TO_DELIVERY.getCode()).setSenderId("1").addReceiverId(supUser.getId()).setMsgLevel(MessageLevelEnum.HIGH);
                this.logger.info("ReceiveVoucherCommand:\u53d1\u9001\u6d88\u606f(\u6536\u8d27)start");
                MessageSendUtils.sendMessage((Message)purVoucherMessage);
                this.logger.info("ReceiveVoucherCommand:\u53d1\u9001\u6d88\u606f(\u6536\u8d27)end");
            }
        }
    }

    public List<PurVoucher> turnData(List<PurVoucher> voucherList) {
        Map<String, List<PurVoucher>> collect = voucherList.stream().collect(Collectors.groupingBy(PurVoucher::getSupCompanyId));
        ArrayList<PurVoucher> purVoucherList = new ArrayList<PurVoucher>();
        for (String key : collect.keySet()) {
            List<PurVoucher> list = collect.get(key);
            ArrayList<String> orders = new ArrayList<String>();
            for (PurVoucher vo : list) {
                if (StringUtils.isNotBlank((String)vo.getDeliveryOrderItemNo())) {
                    orders.add(vo.getDeliveryOrderNo() + "+" + vo.getDeliveryOrderItemNo());
                    continue;
                }
                orders.add(vo.getDeliveryOrderNo());
            }
            PurVoucher purVoucher = list.get(0);
            purVoucher.setDeliveryOrderNo(String.join((CharSequence)",", orders));
            purVoucherList.add(purVoucher);
        }
        return purVoucherList;
    }

    private void completeVoucher(List<PurVoucher> vouchers) {
        if (CollectionUtils.isEmpty(vouchers)) {
            return;
        }
        List toDoList = vouchers.stream().filter(purVoucher -> StringUtils.isNotBlank((String)purVoucher.getVoucherNo()) && StringUtils.isNotBlank((String)purVoucher.getVoucherProject()) && (!purVoucher.getMaterialVoucherNo().equals(purVoucher.getVoucherNo()) || !purVoucher.getMaterialVoucherItemNo().equals(purVoucher.getVoucherProject()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(toDoList)) {
            return;
        }
        List voucherNoList = toDoList.stream().map(PurVoucher::getVoucherNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        List group = Lists.partition(voucherNoList, (int)999);
        PurVoucherExample example = new PurVoucherExample();
        for (List list : group) {
            example.or().andMaterialVoucherNoIn(list);
        }
        List existVoucherList = ContextUtils.getPurVoucherService().queryAllObjByExample((IExample)example);
        for (PurVoucher toDoPurVoucher : toDoList) {
            this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u6536\u5230\u51b2\u9500\u51ed\u8bc1\uff0c\u5f85\u5904\u7406\u51ed\u8bc1:vo{}-voi{}-po{}-poi{}-vo{}-voi{}", new Object[]{toDoPurVoucher.getMaterialVoucherNo(), toDoPurVoucher.getMaterialVoucherItemNo(), toDoPurVoucher.getPurchaseOrderNo(), toDoPurVoucher.getPurchaseOrderItemNo(), toDoPurVoucher.getVoucherNo(), toDoPurVoucher.getVoucherProject()});
            String voucherNo = toDoPurVoucher.getVoucherNo();
            String voucherProject = toDoPurVoucher.getVoucherProject();
            PurVoucher existVoucher = existVoucherList.stream().filter(tmp -> tmp.getMaterialVoucherNo().equals(voucherNo) && tmp.getMaterialVoucherItemNo().equals(voucherProject)).findAny().orElse(null);
            if (existVoucher == null) {
                existVoucher = vouchers.stream().filter(tmp -> tmp.getMaterialVoucherNo().equals(voucherNo) && tmp.getMaterialVoucherItemNo().equals(voucherProject)).findAny().orElse(null);
            }
            if (existVoucher == null) continue;
            toDoPurVoucher.setDeliveryOrderNo(existVoucher.getDeliveryOrderNo());
            toDoPurVoucher.setDeliveryOrderItemNo(existVoucher.getDeliveryOrderItemNo());
        }
    }

    private List<PurchaseOrderItem> queryPurOrderItemByVoucher(List<PurVoucher> vouchers) {
        Map<String, List<PurVoucher>> voucherGroup = vouchers.stream().collect(Collectors.groupingBy(PurVoucher::getPurchaseOrderNo));
        if (voucherGroup == null || voucherGroup.isEmpty()) {
            return null;
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria();
        for (String purOrderNo : voucherGroup.keySet()) {
            List purOrderItemNoList = voucherGroup.get(purOrderNo).stream().map(PurVoucher::getPurchaseOrderItemNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            example.or().andOrderNoEqualTo(purOrderNo).andOrderItemNoIn(purOrderItemNoList);
        }
        return ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
    }

    private void updateOnWayQuantity(List<PurVoucher> vouchers) {
        List<PurVoucher> ignoreVoucher = vouchers.stream().filter(voucher -> StringUtils.isBlank((String)voucher.getDeliveryOrderNo()) || StringUtils.isBlank((String)voucher.getDeliveryOrderItemNo())).collect(Collectors.toList());
        ignoreVoucher.forEach(voucher -> this.logger.warn("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u4ee5\u4e0b\u51ed\u8bc1\u53f7\uff0c\u6ca1\u6709\u9001\u8d27\u5355\u4fe1\u606f [{}][{}] ", (Object)voucher.getMaterialVoucherNo(), (Object)voucher.getMaterialVoucherItemNo()));
        List todoVouchers = ListUtils.removeAll(vouchers, ignoreVoucher);
        this.updateOnWayQuantityByGroup(todoVouchers);
    }

    private void valid(List<PurVoucher> vouchers) {
        for (PurVoucher purVoucher : vouchers) {
            Assert.isNotBlank((String)purVoucher.getMaterialVoucherNo(), (String)"\u51ed\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)purVoucher.getMaterialVoucherItemNo(), (String)"\u51ed\u8bc1\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)purVoucher.getQuantity(), (String)"\u51ed\u8bc1\u7684\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<PurVoucher> distinctVoucher(List<PurVoucher> voucherList) {
        TreeSet<PurVoucher> voucherSet = new TreeSet<PurVoucher>((e1, e2) -> {
            if (e1.getMaterialVoucherNo().compareTo(e2.getMaterialVoucherNo()) != 0) {
                return e1.getMaterialVoucherNo().compareTo(e2.getMaterialVoucherNo());
            }
            if (e1.getMaterialVoucherItemNo().compareTo(e2.getMaterialVoucherItemNo()) != 0) {
                return e1.getMaterialVoucherItemNo().compareTo(e2.getMaterialVoucherItemNo());
            }
            return 0;
        });
        voucherSet.addAll(voucherList);
        voucherList.clear();
        voucherList.addAll(voucherSet);
        return voucherList;
    }

    private List<PurVoucher> filterExistVoucher(List<PurVoucher> vouchers) {
        List voucherNoList = vouchers.stream().map(PurVoucher::getMaterialVoucherNo).distinct().collect(Collectors.toList());
        List group = Lists.partition(voucherNoList, (int)999);
        ArrayList existList = new ArrayList();
        for (List list : group) {
            PurVoucherExample example = new PurVoucherExample();
            example.createCriteria().andMaterialVoucherNoIn(list);
            List pvInDb = ContextUtils.getPurVoucherService().queryAllObjByExample((IExample)example);
            if (CollectionUtils.isEmpty((Collection)pvInDb)) continue;
            existList.addAll(pvInDb);
        }
        return vouchers.stream().filter(voucher -> existList.stream().noneMatch(existVoucher -> existVoucher.getMaterialVoucherNo().equals(voucher.getMaterialVoucherNo()) && existVoucher.getMaterialVoucherItemNo().equals(voucher.getMaterialVoucherItemNo()))).collect(Collectors.toList());
    }

    private void updateReceiveQuantity(List<PurchaseOrderItem> purItemList) {
        UpdateReceiveQuantityCommand command = new UpdateReceiveQuantityCommand(purItemList);
        command.copyProperties(this);
        this.context.invoke(command);
        this.logger.debug("EVENT=\u6536\u8d27\u51ed\u8bc1\u5904\u7406|MSG=\u6839\u636e\u51ed\u8bc1\uff0c\u66f4\u65b0\u6536\u8d27\u6570\u91cf\u7ed3\u675f");
    }

    private void updateOnWayQuantityByGroup(List<PurVoucher> vouchers) {
        if (CollectionUtils.isEmpty(vouchers)) {
            this.logger.warn("EVENT=\u5904\u7406\u6536\u8d27\u51ed\u8bc1|MSG=\u51ed\u8bc1\u4e2d\u7684\u4e0d\u5b58\u5728\u9001\u8d27\u5355\u6570\u636e");
            return;
        }
        Map<String, List<PurVoucher>> voucherGroup = vouchers.stream().collect(Collectors.groupingBy(PurVoucher::getDeliveryOrderNo));
        String mdcId = this.getMdcId();
        ExecutorService executor = Executors.newFixedThreadPool(20);
        for (String deliveryOrderNo : voucherGroup.keySet()) {
            executor.execute(() -> {
                if (StringUtils.isNotBlank((String)mdcId)) {
                    MDC.put((String)"mdc-uuid", (String)mdcId);
                }
                try {
                    ContextUtils.getPurVoucherService().updateDeliveryOrderAndInsertVoucher(deliveryOrderNo, (List)voucherGroup.get(deliveryOrderNo));
                }
                catch (Exception e) {
                    this.logger.error("\u6839\u636e\u51ed\u8bc1\u66f4\u65b0\u9001\u8d27\u5355\u7684\u72b6\u6001\uff0c\u66f4\u65b0\u8ba2\u5355\u5728\u9014\u6570\u91cf\u5931\u8d25", (Throwable)e);
                }
            });
        }
    }

    private void updateDeliveryOrderAndInsertVoucher(String deliveryOrderNo, List<PurVoucher> vouchers) {
        this.updateDeliveryOrder(deliveryOrderNo, vouchers);
        this.insertVoucher(vouchers);
    }

    private void updateDeliveryOrder(String deliveryOrderNo, List<PurVoucher> vouchers) {
        List deliveryOrdreItemNoList = vouchers.stream().map(PurVoucher::getDeliveryOrderItemNo).distinct().collect(Collectors.toList());
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo).andDeliveryOrderItemNoIn(deliveryOrdreItemNoList);
        List deliveryOrderItemList = ContextUtils.getDeliveryOrderItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deliveryOrderItemList)) {
            this.logger.warn("EVENT=\u5904\u7406\u6536\u8d27\u51ed\u8bc1|MSG=\u51ed\u8bc1\u4e2d\u7684\u9001\u8d27\u5355\u6570\u636e\uff0c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return;
        }
        Date voucherTime = null;
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrderItemList) {
            List<PurVoucher> voucherList = vouchers.stream().filter(tmpVoucher -> deliveryOrderItem.getDeliveryOrderNo().equals(tmpVoucher.getDeliveryOrderNo()) && deliveryOrderItem.getDeliveryOrderItemNo().equals(tmpVoucher.getDeliveryOrderItemNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(voucherList)) {
                throw new CommonException("\u6570\u636e\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u6536\u8d27\u51ed\u8bc1");
            }
            voucherTime = ((PurVoucher)voucherList.get(0)).getVoucherTime();
            if (!DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrderItem.getDeliveryStatus())) {
                this.context.invoke(new ModifyPlanOnWayQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_RECEIVE, deliveryOrderItem.getDeliveryQuantity()));
                this.context.invoke(new ModifyOrderItemOnWayQuantityCmd(deliveryOrderItem.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_RECEIVE, deliveryOrderItem.getDeliveryQuantity()));
            }
            this.updateDeliveryOrderItem(deliveryOrderItem, voucherList);
            this.updateDeliveryPlanItem(deliveryOrderItem, voucherList);
        }
        List<String> planItemIdList = deliveryOrderItemList.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        this.context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        this.updateDeliveryOrder(deliveryOrderNo, voucherTime);
        vouchers.forEach(voucher -> voucher.setBillFlag(Constant.YES_INT));
    }

    private void updateDeliveryPlanItem(DeliveryOrderItem deliveryOrderItem, List<PurVoucher> voucherList) {
        if (CollectionUtils.isEmpty(voucherList)) {
            return;
        }
        BigDecimal totalReceive = BigDecimal.ZERO;
        for (PurVoucher purVoucher : voucherList) {
            BigDecimal voucherQuantity;
            BigDecimal bigDecimal = voucherQuantity = purVoucher.getQuantity() == null ? BigDecimal.ZERO : purVoucher.getQuantity();
            if (NAGATIVE_MARK.equals(purVoucher.getMark())) {
                voucherQuantity = voucherQuantity.multiply(NAGATIVE_NUM);
            }
            totalReceive = totalReceive.add(voucherQuantity);
        }
        this.context.invoke(new ModifyPlanReceiveQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), totalReceive));
    }

    private void updateDeliveryOrder(String deliveryOrderNo, Date voucherTime) {
        DeliveryOrder temp = new DeliveryOrder();
        temp.setDeliveryStatus(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        temp.setReceiveDate(voucherTime);
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo);
        ContextUtils.getDeliveryOrderService().modifyByExample(temp, example);
    }

    private void updateDeliveryOrderItem(DeliveryOrderItem deliveryOrderItem, List<PurVoucher> voucherList) {
        BigDecimal voucherReceiverQuantity = BigDecimal.ZERO;
        for (PurVoucher purVoucher : voucherList) {
            BigDecimal voucherQuantity;
            BigDecimal bigDecimal = voucherQuantity = purVoucher.getQuantity() == null ? BigDecimal.ZERO : purVoucher.getQuantity();
            if (NAGATIVE_MARK.equals(purVoucher.getMark())) {
                voucherQuantity = voucherQuantity.multiply(NAGATIVE_NUM);
            }
            voucherReceiverQuantity = voucherReceiverQuantity.add(voucherQuantity);
        }
        BigDecimal total = StringUtils.isBlank((String)deliveryOrderItem.getReceiptQuantity()) ? BigDecimal.ZERO : new BigDecimal(deliveryOrderItem.getReceiptQuantity());
        total = total.add(voucherReceiverQuantity);
        DeliveryOrderItem temp = new DeliveryOrderItem();
        temp.setId(deliveryOrderItem.getId());
        temp.setDeliveryStatus(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        temp.setReceiveDate(voucherList.get(0).getVoucherTime());
        temp.setReceiptQuantity(String.valueOf(total));
        ContextUtils.getDeliveryOrderItemService().modifyObj(temp);
    }

    private void insertVoucher(List<PurVoucher> vouchers) {
        ContextUtils.getPurVoucherService().addAll(vouchers);
    }
}

