/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ViewDeliveryOrderDetailCmd
extends AbstractCommand<DeliveryOrder> {
    private static final long serialVersionUID = 1L;
    private String deliveryOrderId;

    public ViewDeliveryOrderDetailCmd(String deliveryOrderId) {
        this.deliveryOrderId = deliveryOrderId;
    }

    @Override
    public DeliveryOrder execute(ICommandInvoker context) {
        DeliveryOrder deliveryOrder = (DeliveryOrder)ContextUtils.getDeliveryOrderService().queryObjById(this.deliveryOrderId);
        List<DeliveryOrderItem> items = ContextUtils.getDeliveryOrderItemService().queryByDeliveryOrderId(this.deliveryOrderId);
        items.forEach(item -> {
            if (StringUtils.isBlank((String)item.getDeliveryPlanItemId())) {
                throw new CommonException("\u6570\u636e\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u5efa\u9001\u8d27\u5355\u7684\u8ba1\u5212id");
            }
            SupplierOrderItem supplierOrderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(item.getPurOrderItemId());
            SupDeliveryPlanItem planItem = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(item.getDeliveryPlanItemId());
            item.setSupOrderItem(supplierOrderItem);
            item.setSupDeliveryPlanItem(planItem);
            if (planItem == null) {
                return;
            }
            if (item.getQuantity() == null) {
                item.setQuantity(planItem.getDeliveryQuantity());
            }
            if (item.getReceiptQuantity() == null) {
                item.setReceiptQuantity(planItem.getReceivedQuantity().toString());
            }
            if (item.getOnwayQuantity() == null) {
                item.setOnwayQuantity(planItem.getOnwayQuantity());
            }
            if (item.getCanDeliveryQuantity() == null) {
                item.setCanDeliveryQuantity(planItem.getCanDeliveryQuantity());
            }
        });
        List<DeliveryPackage> packages = ContextUtils.getDeliveryPackageService().queryByDeliveryOrderId(this.deliveryOrderId);
        deliveryOrder.setItems(items);
        deliveryOrder.setDeliveryPackageLists(packages);
        return deliveryOrder;
    }
}

