/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.command.ArrivedCommand;
import com.els.base.delivery.command.BatchCancelCommand;
import com.els.base.delivery.command.BatchSendCommand;
import com.els.base.delivery.command.CreateCommand;
import com.els.base.delivery.command.DeleteCommand;
import com.els.base.delivery.command.ModifyCommand;
import com.els.base.delivery.command.PreviewDeliveryOrderByPlanCmd;
import com.els.base.delivery.command.PreviewDeliveryOrderItemByPlanCmd;
import com.els.base.delivery.command.SendCommand;
import com.els.base.delivery.command.SplitJitPlanByOrderCommand;
import com.els.base.delivery.command.ViewDeliveryOrderDetailCmd;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.delivery.utils.DeliveryTypeEnum;
import com.els.base.delivery.web.vo.DeliveryOrderModifyVo;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.purchase.service.PurchaseOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u53d1\u8d27\u5355\u5934"})
@Controller
@RequestMapping(value={"deliveryOrder"})
public class DeliveryOrderController {
    @Resource
    protected OrderCommandInvoker orderComandInvoker;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected UserService userService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u8d27\uff0c\u65b0\u5efa\u9001\u8d27\u5355\uff0c\u53d1\u8d27\u3002\u53d1\u8d27\u5355\u53d1\u8d27\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u53d1\u8d27\u5355\u5b9e\u4f53\u7c7b\uff09")
    @RequestMapping(value={"service/sendDelivery"})
    @ResponseBody
    public ResponseResult<String> sendDelivery(@RequestBody DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53d1\u8d27\u5355\u6570\u636e"});
        }
        SendCommand command = new SendCommand(deliveryOrder);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u6279\u91cf\u53d1\u8d27\u3002\u53d1\u8d27\u5355\u6279\u91cf\u53d1\u8d27\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/sendDeliveryForBatch"})
    @ResponseBody
    public ResponseResult<String> sendDeliveryForBatch(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("\u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u53d1\u8d27\u5355"});
        }
        BatchSendCommand command = new BatchSendCommand(deliveryOrderIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u6279\u91cf\u4f5c\u5e9f\u53d1\u8d27\u3002\u6279\u91cf\u64a4\u9500\u53d1\u8d27\u5355\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/cancellationDeliveryForBatch"})
    @ResponseBody
    public ResponseResult<String> cancellationDeliveryForBatch(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "not_query_to_data");
        }
        BatchCancelCommand command = new BatchCancelCommand(deliveryOrderIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u8d27\uff0c\u65b0\u5efa\u9001\u8d27\u5355\uff0c\u4fdd\u5b58\u64cd\u4f5c\u3002\u53d1\u8d27\u5355\u4fdd\u5b58\uff1a\u5165\u53c2\uff08\u6574\u4e2a\u53d1\u8d27\u5355\u5b9e\u4f53\u7c7b\uff09")
    @RequestMapping(value={"service/saveDelivery"})
    @ResponseBody
    public ResponseResult<String> saveDelivery(@RequestBody DeliveryOrder deliveryOrder) {
        Assert.isNotNull((Object)deliveryOrder, (String)"\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(deliveryOrder.getItems(), (String)"\u884c\u6570\u636e\u4e0d\u5b58\u5728");
        AbstractCommand command = null;
        command = StringUtils.isNotBlank((String)deliveryOrder.getId()) ? new ModifyCommand(deliveryOrder) : new CreateCommand(deliveryOrder);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u53d1\u8d27\u5355\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", "not_query_to_data");
        }
        DeleteCommand command = new DeleteCommand(deliveryOrderIdList);
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u5217\u8868(\u4f9b\u5e94\u5546)-\u67e5\u8be2\u53d1\u8d27\u5934")
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findSupByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView((PageView<DeliveryOrder>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        String companyId = CompanyUtils.currentCompanyId();
        example.createCriteria().andCompanyIdEqualTo(companyId).andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u5217\u8868(\u91c7\u8d2d\u65b9)-\u67e5\u8be2\u53d1\u8d27\u5934")
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findPurByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView((PageView<DeliveryOrder>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        DeliveryOrderExample.Criteria cri = example.createCriteria();
        cri.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        cri.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efaJIT\u9001\u8d27\u5355\u3002\u751f\u6210\u53d1\u8d27\u5355\u6570\u636e\uff1a\u5165\u53c2\uff08\u9001\u8d27\u8ba1\u5212\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/createJitDeliveryData"})
    @ResponseBody
    public ResponseResult<DeliveryOrder> createJitDeliveryData(@RequestBody List<String> deliveryPlanItemIds) {
        Assert.isNotEmpty(deliveryPlanItemIds, (String)"\u9001\u8d27\u8ba1\u5212\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        deliveryPlanItemIds = deliveryPlanItemIds.stream().distinct().collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)deliveryPlanItemIds);
        List<SupDeliveryPlanItem> deliveryPlanItemList = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        SplitJitPlanByOrderCommand orderCommand = new SplitJitPlanByOrderCommand(deliveryPlanItemList);
        deliveryPlanItemList = this.orderComandInvoker.invoke(orderCommand);
        Assert.isNotEmpty(deliveryPlanItemList, (String)"\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        PreviewDeliveryOrderByPlanCmd command = new PreviewDeliveryOrderByPlanCmd(deliveryPlanItemList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        DeliveryOrder deliveryOrder = this.orderComandInvoker.invoke(command);
        return ResponseResult.success((Object)deliveryOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efajit\u9001\u8d27\u5355\u9884\u89c8\uff1a\u5165\u53c2\uff08\u91c7\u8d2d\u8ba2\u5355\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/orderItemToJitDeliveryData"})
    @ResponseBody
    public ResponseResult<List<DeliveryOrderItem>> orderItemToJitDeliveryData(String deliveryOrderNo, @RequestBody List<String> deliveryPlanItemIds) {
        Assert.isNotEmpty(deliveryPlanItemIds, (String)"\u6ca1\u6709\u8ba2\u8d27\u5355\u884c\u6570\u636e");
        deliveryPlanItemIds = deliveryPlanItemIds.stream().distinct().collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)deliveryPlanItemIds);
        List<SupDeliveryPlanItem> deliveryPlanItemList = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        SplitJitPlanByOrderCommand orderCommand = new SplitJitPlanByOrderCommand(deliveryPlanItemList);
        deliveryPlanItemList = this.orderComandInvoker.invoke(orderCommand);
        Assert.isNotEmpty(deliveryPlanItemList, (String)"\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        PreviewDeliveryOrderItemByPlanCmd previewItemCmd = new PreviewDeliveryOrderItemByPlanCmd(deliveryPlanItemList, deliveryOrderNo);
        previewItemCmd.setSupCompany(CompanyUtils.currentCompany());
        previewItemCmd.setSupUser(SpringSecurityUtils.getLoginUser());
        List<DeliveryOrderItem> items = this.orderComandInvoker.invoke(previewItemCmd);
        for (DeliveryOrderItem deliveryOrderItem : items) {
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrderNo);
        }
        return ResponseResult.success(items);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u975eJIT\u9001\u8d27\u5355\u3002\u751f\u6210\u53d1\u8d27\u5355\u6570\u636e\uff1a\u5165\u53c2\uff08\u9001\u8d27\u8ba1\u5212\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/createNotJitDeliveryData"})
    @ResponseBody
    public ResponseResult<DeliveryOrder> createNotJitDeliveryData(@RequestBody List<String> deliveryPlanItemIdList) {
        Assert.isNotEmpty(deliveryPlanItemIdList, (String)"\u9001\u8d27\u8ba1\u5212\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        deliveryPlanItemIdList = deliveryPlanItemIdList.stream().distinct().collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)deliveryPlanItemIdList);
        List deliveryPlanItemList = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deliveryPlanItemList) || deliveryPlanItemIdList.size() != deliveryPlanItemIdList.size()) {
            throw new CommonException("\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        List<SupDeliveryPlanItem> jitPlanItems = deliveryPlanItemList.stream().filter(planItem -> Constant.YES_INT.equals(planItem.getIsJit())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(jitPlanItems)) {
            deliveryPlanItemList.removeAll(jitPlanItems);
            jitPlanItems = this.orderComandInvoker.invoke(new SplitJitPlanByOrderCommand(jitPlanItems));
            deliveryPlanItemList.addAll(jitPlanItems);
        }
        PreviewDeliveryOrderByPlanCmd cmd = new PreviewDeliveryOrderByPlanCmd(deliveryPlanItemList);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        DeliveryOrder deliveryOrder = this.orderComandInvoker.invoke(cmd);
        return ResponseResult.success((Object)deliveryOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u975eJIT\u9001\u8d27\u5355\u9884\u89c8\uff1a\u5165\u53c2\uff08\u91c7\u8d2d\u8ba2\u5355\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/addPlanToDeliveryData"})
    @ResponseBody
    public ResponseResult<List<DeliveryOrderItem>> addPlanToDeliveryData(@RequestBody DeliveryOrderModifyVo deliveryOrderModifyVo) {
        Assert.isNotEmpty(deliveryOrderModifyVo.getDeliveryPlanItemIdList(), (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List<SupDeliveryPlanItem> allNewPlanItemList = this.getNewPlanItemInfo(deliveryOrderModifyVo);
        Assert.isNotEmpty(allNewPlanItemList, (String)"\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        List newJitPlanItem = allNewPlanItemList.stream().filter(planItem -> Constant.YES_INT.equals(planItem.getIsJit())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newJitPlanItem)) {
            PreviewDeliveryOrderItemByPlanCmd previewCmd = new PreviewDeliveryOrderItemByPlanCmd(allNewPlanItemList);
            previewCmd.setSupCompany(CompanyUtils.currentCompany());
            previewCmd.setSupUser(SpringSecurityUtils.getLoginUser());
            return ResponseResult.success(this.orderComandInvoker.invoke(previewCmd));
        }
        List<SupDeliveryPlanItem> allJitPlanItemList = new ArrayList<SupDeliveryPlanItem>();
        allJitPlanItemList.addAll(newJitPlanItem);
        List<SupDeliveryPlanItem> existJitPlanItem = this.getExistJitPlanItemInfo(deliveryOrderModifyVo);
        if (CollectionUtils.isNotEmpty(existJitPlanItem)) {
            allJitPlanItemList.addAll(existJitPlanItem);
        }
        SplitJitPlanByOrderCommand splitJitCmd = new SplitJitPlanByOrderCommand(allJitPlanItemList);
        splitJitCmd.setSupCompany(CompanyUtils.currentCompany());
        splitJitCmd.setSupUser(SpringSecurityUtils.getLoginUser());
        allJitPlanItemList = this.orderComandInvoker.invoke(splitJitCmd);
        if (CollectionUtils.isNotEmpty(existJitPlanItem)) {
            allJitPlanItemList = allJitPlanItemList.stream().filter(planItem -> existJitPlanItem.stream().noneMatch(existPlanItem -> planItem.getId().equals(existPlanItem.getId()))).collect(Collectors.toList());
        }
        List noneJitPlanList = allNewPlanItemList.stream().filter(planItem -> !Constant.YES_INT.equals(planItem.getIsJit())).collect(Collectors.toList());
        allJitPlanItemList.addAll(noneJitPlanList);
        PreviewDeliveryOrderItemByPlanCmd previewCmd = new PreviewDeliveryOrderItemByPlanCmd(allJitPlanItemList);
        previewCmd.setSupCompany(CompanyUtils.currentCompany());
        previewCmd.setSupUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(this.orderComandInvoker.invoke(previewCmd));
    }

    private List<SupDeliveryPlanItem> getNewPlanItemInfo(DeliveryOrderModifyVo deliveryOrderModifyVo) {
        List<String> deliveryPlanItemIdList = deliveryOrderModifyVo.getDeliveryPlanItemIdList();
        deliveryPlanItemIdList = deliveryPlanItemIdList.stream().distinct().collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)deliveryPlanItemIdList);
        return ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
    }

    private List<SupDeliveryPlanItem> getExistJitPlanItemInfo(DeliveryOrderModifyVo deliveryOrderModifyVo) {
        return deliveryOrderModifyVo.getDeliveryOrder().getItems().stream().map(item -> {
            SupDeliveryPlanItem planItem = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(item.getDeliveryPlanItemId());
            planItem.setDeliveryQuantity(item.getDeliveryQuantity());
            return planItem;
        }).filter(planItem -> planItem != null && Constant.YES_INT.equals(planItem.getIsJit())).collect(Collectors.toList());
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u975eJIT\u9001\u8d27\u5355\u9884\u89c8\uff1a\u5165\u53c2\uff08\u91c7\u8d2d\u8ba2\u5355\u884cid\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/orderItemToNotJitDeliveryData"})
    @ResponseBody
    public ResponseResult<List<DeliveryOrderItem>> orderItemToNotJitDeliveryData(String deliveryOrderNo, @RequestBody List<String> deliveryPlanItemIdList) {
        Assert.isNotEmpty(deliveryPlanItemIdList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        deliveryPlanItemIdList = deliveryPlanItemIdList.stream().distinct().collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)deliveryPlanItemIdList);
        List deliveryPlanItemList = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)deliveryPlanItemList, (String)"\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        if (deliveryPlanItemIdList.size() != deliveryPlanItemIdList.size()) {
            throw new CommonException("\u9001\u8d27\u901a\u77e5\u5355\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        List<SupDeliveryPlanItem> jitPlanItems = deliveryPlanItemList.stream().filter(planItem -> Constant.YES_INT.equals(planItem.getIsJit())).collect(Collectors.toList());
        deliveryPlanItemList.removeAll(jitPlanItems);
        jitPlanItems = this.orderComandInvoker.invoke(new SplitJitPlanByOrderCommand(jitPlanItems));
        deliveryPlanItemList.addAll(jitPlanItems);
        PreviewDeliveryOrderItemByPlanCmd previewItemCmd = new PreviewDeliveryOrderItemByPlanCmd(deliveryPlanItemList, deliveryOrderNo);
        previewItemCmd.setSupCompany(CompanyUtils.currentCompany());
        previewItemCmd.setSupUser(SpringSecurityUtils.getLoginUser());
        List<DeliveryOrderItem> items = this.orderComandInvoker.invoke(previewItemCmd);
        for (DeliveryOrderItem deliveryOrderItem : items) {
            deliveryOrderItem.setDeliveryOrderNo(deliveryOrderNo);
        }
        return ResponseResult.success(items);
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7id\u67e5\u8be2\u53d1\u8d27\u5355\u5934\u5386\u53f2")
    @RequestMapping(value={"service/findHisById"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u53d1\u8d27\u5355\u5934id") String id) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView((PageView<DeliveryOrder>)new PageView(pageNo, pageSize));
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("last_update_time DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5458\u67e5\u8be2\u53d1\u8d27\u5934")
    @RequestMapping(value={"service/findByPageForPurchase"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForPurchase(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView((PageView<DeliveryOrder>)new PageView(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(companyId);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4ed3\u5e93\u9001\u8d27\u5355/\u8d28\u68c0\u9001\u8d27\u5355")
    @RequestMapping(value={"service/findByPageForWarehouse"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForWarehouse(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView((PageView<DeliveryOrder>)new PageView(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(DeliveryStatusEnum.ONWAY.getValue());
        values.add(DeliveryStatusEnum.TO_FACTORY.getValue());
        values.add(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        criteria.andDeliveryStatusIn(values);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u4fee\u6539-\u901a\u8fc7\u53d1\u8d27id\u67e5\u8be2\u53d1\u8d27\u884c:")
    @RequestMapping(value={"service/findByDeliveryOrderId"})
    @ResponseBody
    public ResponseResult<DeliveryOrder> findByDeliveryOrderId(@ApiParam(value="\u53d1\u8d27\u5355\u53f7Id") String deliveryOrderId) {
        if (StringUtils.isBlank((String)deliveryOrderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u53d1\u8d27\u53f7\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u53d1\u8d27\u53f7"});
        }
        ViewDeliveryOrderDetailCmd viewDeliveryOrderDetailCmd = new ViewDeliveryOrderDetailCmd(deliveryOrderId);
        DeliveryOrder deliveryOrder = this.orderComandInvoker.invoke(viewDeliveryOrderDetailCmd);
        return ResponseResult.success((Object)deliveryOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u672a\u5230\u8d27\u8fd0\u5355")
    @RequestMapping(value={"service/findNotArrivingDeliveryByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findNotArrivingDeliveryByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrder") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView((PageView<DeliveryOrder>)new PageView(pageNo, pageSize));
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andDeliveryStatusEqualTo(DeliveryStatusEnum.ONWAY.getValue());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5230\u5382\u786e\u8ba4")
    @RequestMapping(value={"service/updateDeliveryOrderStatus", "front/updateDeliveryOrderStatus"})
    @ResponseBody
    public ResponseResult<String> updateDeliveryOrderStatus(String deliveryOrderNo) {
        if (StringUtils.isBlank((String)deliveryOrderNo)) {
            throw new CommonException("\u9001\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u9001\u8d27\u5355\u53f7"});
        }
        ArrivedCommand cmd = new ArrivedCommand(deliveryOrderNo);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.orderComandInvoker.invoke(cmd);
        return ResponseResult.success();
    }
}

