/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSendToPurCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.entity.SupplierOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;

public class ImportSupPlanForConfirmedOrderCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrder order;
    private List<SupDeliveryPlanItem> list;

    public ImportSupPlanForConfirmedOrderCmd(SupplierOrder order, List<SupDeliveryPlanItem> list) {
        this.order = order;
        this.list = list;
    }

    @Override
    public String execute(ICommandInvoker context) {
        Map<String, List<SupDeliveryPlanItem>> orderItemNoAndPlanList = this.list.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderItemNo));
        ArrayList<SupDeliveryPlanItem> itemList = new ArrayList<SupDeliveryPlanItem>();
        ArrayList<String> orderItemNoList = new ArrayList<String>();
        orderItemNoList.addAll(orderItemNoAndPlanList.keySet());
        orderItemNoList.sort(String::compareTo);
        for (String orderItemNo : orderItemNoList) {
            List<SupDeliveryPlanItem> supPlanItemList = orderItemNoAndPlanList.get(orderItemNo);
            List<PurDeliveryPlanItem> purPlanItemList = this.queryPlanItem(this.order.getOrderNo(), orderItemNo);
            Assert.isNotNull(purPlanItemList, (String)String.format("\u8ba2\u5355\u884c[%s][%s]\u6ca1\u6709\u8ba1\u5212", this.order.getOrderNo(), orderItemNo));
            if (DeliveryPlanUtils.isEqualBewteenPurAndSup(purPlanItemList, supPlanItemList)) {
                List confirmList = purPlanItemList.stream().map(plan -> {
                    SupDeliveryPlanItem temp = new SupDeliveryPlanItem();
                    BeanUtils.copyProperties((Object)plan, (Object)temp);
                    temp.setChangeStatus(PlanChangeStatusEnum.SUP_CONFIRM.getValue());
                    System.out.println(plan.getPurOrderNo() + ":" + plan.getPurOrderItemNo());
                    temp.setSupRemark(this.findPlan((PurDeliveryPlanItem)plan, supPlanItemList).getSupRemark());
                    return temp;
                }).collect(Collectors.toList());
                itemList.addAll(confirmList);
                continue;
            }
            List refusePlanList = supPlanItemList.stream().map(planItem -> {
                SupDeliveryPlanItem temp = new SupDeliveryPlanItem();
                BeanUtils.copyProperties(purPlanItemList.get(0), (Object)temp);
                temp.setDeliveryDate(planItem.getDeliveryDate());
                temp.setDeliveryQuantity(planItem.getDeliveryQuantity());
                temp.setChangeStatus(PlanChangeStatusEnum.SUP_CHANGE.getValue());
                temp.setSupRemark(planItem.getSupRemark());
                temp.setId(null);
                return temp;
            }).collect(Collectors.toList());
            itemList.addAll(refusePlanList);
        }
        NoneJitPlanSendToPurCmd sendToPurCmd = new NoneJitPlanSendToPurCmd(itemList, PlanDataSourceEnum.EXCEL);
        sendToPurCmd.copyProperties(this);
        this.context.invoke(sendToPurCmd);
        return null;
    }

    private SupDeliveryPlanItem findPlan(PurDeliveryPlanItem purPlanItem, List<SupDeliveryPlanItem> planItemList) {
        String date = DateFormatUtils.format((Date)purPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd");
        return planItemList.stream().filter(supPlanItem -> {
            System.out.println(DateFormatUtils.format((Date)supPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd") + ":" + date);
            System.out.println(supPlanItem.getDeliveryQuantity() + ":" + purPlanItem.getDeliveryQuantity());
            System.out.println(supPlanItem.getPurOrderNo() + ":" + purPlanItem.getPurOrderNo());
            System.out.println(supPlanItem.getPurOrderItemNo() + ":" + purPlanItem.getPurOrderItemNo());
            return DateFormatUtils.format((Date)supPlanItem.getDeliveryDate(), (String)"yyyy-MM-dd").equals(date) && supPlanItem.getDeliveryQuantity().compareTo(purPlanItem.getDeliveryQuantity()) == 0 && supPlanItem.getPurOrderNo().equals(purPlanItem.getPurOrderNo()) && supPlanItem.getPurOrderItemNo().equals(purPlanItem.getPurOrderItemNo());
        }).findAny().get();
    }

    private List<PurDeliveryPlanItem> queryPlanItem(String orderNo, String orderItemNo) {
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderNoEqualTo(orderNo).andPurOrderItemNoEqualTo(orderItemNo);
        return ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
    }
}

