/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.purchase.command.log.CreateOperationLogCommand;
import com.els.base.purchase.command.order.pur.SendOrderCommand;
import com.els.base.purchase.command.order.pur.ViewPurOrderDetailCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.utils.IsRefuseStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderOperationTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class BatchSendOrderCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<String> orderIdList;
    private List<PurchaseOrder> orderList;

    public BatchSendOrderCommand(List<String> orderIdList) {
        this.orderIdList = orderIdList;
        this.orderList = new ArrayList<PurchaseOrder>(orderIdList.size());
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid();
        for (PurchaseOrder order : this.orderList) {
            this.changeOrderStatus(order);
            SendOrderCommand orderCommand = new SendOrderCommand(order.getId());
            orderCommand.copyProperties(this);
            context.invoke(orderCommand);
            CreateOperationLogCommand createLogCmd = new CreateOperationLogCommand(order, PurchaseOrderOperationTypeEnum.SENT_TO_SUP);
            createLogCmd.copyProperties(this);
            context.invoke(createLogCmd);
        }
        return null;
    }

    private void changeOrderStatus(PurchaseOrder purchaseOrder) {
        PurchaseOrder tempPurchaseOrder = new PurchaseOrder();
        tempPurchaseOrder.setId(purchaseOrder.getId());
        tempPurchaseOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
        ContextUtils.getPurchaseOrderService().modifyObj(tempPurchaseOrder);
        List itemList = purchaseOrder.getItems().stream().filter(item -> PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(item.getOrderStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        for (PurchaseOrderItem purchaseOrderItem : itemList) {
            PurchaseOrderItem newPurItem = new PurchaseOrderItem();
            newPurItem.setOrderStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            newPurItem.setIsRefuseDeliveredDate(IsRefuseStatusEnum.NO_REFUSE.getValue());
            newPurItem.setIsRefusePrice(IsRefuseStatusEnum.NO_REFUSE.getValue());
            newPurItem.setIsRefuseQuantity(IsRefuseStatusEnum.NO_REFUSE.getValue());
            newPurItem.setId(purchaseOrderItem.getId());
            if (IsRefuseStatusEnum.REFUSE.getValue().equals(purchaseOrderItem.getIsRefusePrice())) {
                newPurItem.setIsOfficialPrice(Constant.YES_INT);
            }
            ContextUtils.getPurchaseOrderItemService().modifyObj(newPurItem);
        }
    }

    private void valid() {
        Assert.isNotEmpty(this.orderIdList, (String)"\u8ba2\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        this.orderList = this.orderIdList.stream().distinct().map(orderId -> this.context.invoke(new ViewPurOrderDetailCommand((String)orderId))).collect(Collectors.toList());
        for (PurchaseOrder order : this.orderList) {
            if (!PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue().equals(order.getOrderSendStatus()) && !PurchaseOrderSendStatusEnum.SENDED.getValue().equals(order.getOrderSendStatus()) || PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(order.getOrderStatus()) || PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue().equals(order.getOrderStatus())) continue;
            String errorMsg = String.format("\u91c7\u8d2d\u65b9\u8ba2\u5355[%s]\u5df2\u7ecf\u53d1\u9001,\u8bf7\u52ff\u91cd\u590d\u53d1\u9001", order.getOrderNo());
            throw new CommonException(errorMsg);
        }
    }
}

