/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.command.nonejit.pur.NoneJitPlanInOrderSendToSupCmd;
import com.els.base.purchase.command.change.SendChangeCommand;
import com.els.base.purchase.command.order.pur.ViewPurOrderDetailCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.BusinessTypeEnum;
import com.els.base.purchase.utils.ChangeTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class SendOrderCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder order;
    private String orderId;

    public SendOrderCommand(String orderId) {
        this.orderId = orderId;
        Assert.isNotBlank((String)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u4e3a\u7a7a");
    }

    public SendOrderCommand(PurchaseOrder order) {
        this.order = order;
    }

    @Override
    public String execute(ICommandInvoker context) {
        if (this.order == null && StringUtils.isNotBlank((String)this.orderId)) {
            this.order = this.initOrder(this.orderId);
        }
        this.valid(this.order);
        this.init(this.order);
        this.updateOrder(this.order);
        this.sendToSupCompany(this.order);
        this.sendOrderChange(this.order);
        this.sendPlanItem(this.order);
        return null;
    }

    private PurchaseOrder initOrder(String orderId) {
        ViewPurOrderDetailCommand command = new ViewPurOrderDetailCommand(orderId);
        command.copyProperties(this);
        return this.context.invoke(command);
    }

    private void sendPlanItem(PurchaseOrder order) {
        NoneJitPlanInOrderSendToSupCmd cmd = new NoneJitPlanInOrderSendToSupCmd(order);
        cmd.copyProperties(this);
        this.context.invoke(cmd);
    }

    private void sendToSupCompany(PurchaseOrder order) {
        SupplierOrder supOrder = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(order.getId());
        if (supOrder == null) {
            this.addNewSupplierOrder(order);
            this.sendMsg(this.order, BusinessTypeEnum.PO_NEW_SEND.getCode());
        } else {
            this.modifyOldSupplierOrder(order);
            this.sendMsg(this.order, BusinessTypeEnum.PO_CHANGED_SEND.getCode());
        }
    }

    private void modifyOldSupplierOrder(PurchaseOrder order) {
        SupplierOrder supOrder = this.createSupplierOrder(order);
        ContextUtils.getSupplierOrderService().modifyObj(supOrder);
        for (PurchaseOrderItem purOrderItem : order.getItems()) {
            SupplierOrderItem supplierOrderItem = this.createSupplierOrderItem(purOrderItem, supOrder);
            SupplierOrderItem temp = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(supplierOrderItem.getId());
            if (temp == null) {
                ContextUtils.getSupplierOrderItemService().addObj(supplierOrderItem);
                continue;
            }
            ContextUtils.getSupplierOrderItemService().modifyObj(supplierOrderItem);
        }
    }

    private void sendOrderChange(PurchaseOrder order) {
        SendChangeCommand sendChangeCmd = new SendChangeCommand(order.getId());
        sendChangeCmd.copyProperties(this);
        this.context.invoke(sendChangeCmd);
    }

    private void addNewSupplierOrder(PurchaseOrder order) {
        SupplierOrder supOrder = this.createSupplierOrder(order);
        ContextUtils.getSupplierOrderService().addObj(supOrder);
        for (PurchaseOrderItem purOrderItem : order.getItems()) {
            SupplierOrderItem supplierOrderItem = this.createSupplierOrderItem(purOrderItem, supOrder);
            ContextUtils.getSupplierOrderItemService().addObj(supplierOrderItem);
        }
    }

    private void sendMsg(PurchaseOrder purchaseOrder, String businessType) {
        if (!this.isChange(this.order)) {
            return;
        }
        Message msg = Message.init((Object)purchaseOrder).setCompanyCode(purchaseOrder.getPurCompanySrmCode()).setBusinessTypeCode(businessType).setSenderId(purchaseOrder.getPurUserId()).addReceiverId(purchaseOrder.getSupUserId()).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private SupplierOrder createSupplierOrder(PurchaseOrder purOrder) {
        SupplierOrder supOrder = new SupplierOrder();
        Date now = new Date();
        BeanUtils.copyProperties((Object)purOrder, (Object)supOrder);
        supOrder.setLastUpdateTime(now);
        return supOrder;
    }

    private SupplierOrderItem createSupplierOrderItem(PurchaseOrderItem purOrderItem, SupplierOrder supOrder) {
        SupplierOrderItem supplierOrderItem = new SupplierOrderItem();
        BeanUtils.copyProperties((Object)purOrderItem, (Object)supplierOrderItem);
        supplierOrderItem.setSupUserId(supOrder.getSupUserId());
        supplierOrderItem.setSupUserName(supOrder.getSupUserName());
        supplierOrderItem.setSupCompanyId(supOrder.getSupCompanyId());
        supplierOrderItem.setSupCompanyName(supOrder.getSupCompanyName());
        supplierOrderItem.setPurUserId(supOrder.getPurUserId());
        supplierOrderItem.setPurUserName(supOrder.getPurUserName());
        supplierOrderItem.setPurCompanyId(supOrder.getPurCompanyId());
        supplierOrderItem.setPurCompanyName(supOrder.getPurCompanyName());
        supplierOrderItem.setSupCompanySapCode(supOrder.getSupCompanySapCode());
        supplierOrderItem.setUpdateTime(supOrder.getLastUpdateTime());
        return supplierOrderItem;
    }

    private void updateOrder(PurchaseOrder order) {
        ContextUtils.getPurchaseOrderService().modifyObj(order);
        for (PurchaseOrderItem orderItem : order.getItems()) {
            ContextUtils.getPurchaseOrderItemService().modifyObj(orderItem);
        }
    }

    private void init(PurchaseOrder order) {
        if (this.getPurUser() != null) {
            order.setPurUserId(this.getPurUser().getId());
            order.setPurUserName(this.getPurUser().getNickName());
        }
        order.setSendTime(new Date());
        if (StringUtils.isNotBlank((String)order.getSupCompanyId())) {
            User user = ContextUtils.getCompanyUserRefService().queryMainUserOfCompany(order.getSupCompanyId());
            order.setSupUserId(user != null ? user.getId() : null);
            order.setSupUserName(user != null ? user.getNickName() : null);
        }
        if (this.isChange(order)) {
            if (PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue().equals(order.getOrderSendStatus()) || PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue().equals(order.getOrderSendStatus())) {
                order.setOrderSendStatus(PurchaseOrderSendStatusEnum.UPDATE_SENDED.getValue());
            } else {
                order.setOrderSendStatus(PurchaseOrderSendStatusEnum.SENDED.getValue());
            }
        }
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.createCriteria().andOrderNoEqualTo(order.getOrderNo()).andSupCompanyIdEqualTo(order.getSupCompanyId());
        List items = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)items, (String)String.format("\u8ba2\u5355[%s]\u884c\u4e0d\u5b58\u5728", order.getOrderNo()));
        for (PurchaseOrderItem purchaseOrderItem : items) {
            purchaseOrderItem.setPurUserId(order.getPurUserId());
            purchaseOrderItem.setPurUserName(order.getPurUserName());
            purchaseOrderItem.setSupUserId(order.getSupUserId());
            purchaseOrderItem.setSupUserName(order.getSupUserName());
        }
        order.setItems(items);
    }

    private boolean isChange(PurchaseOrder order) {
        boolean isChange = order.getItems().stream().anyMatch(item -> !ChangeTypeEnum.OLD_ITEM.getValue().equals(item.getHaveChange()));
        return isChange;
    }

    private void valid(PurchaseOrder order) {
        Assert.isNotBlank((String)order.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)order.getOrderNo(), (String)"\u8ba2\u5355\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(order.getItems(), (String)"\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

