/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.SupplierOrderMapper;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.service.PurchaseOrderService;
import com.els.base.purchase.service.SupplierOrderItemService;
import com.els.base.purchase.service.SupplierOrderService;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="supplierOrderService")
public class SupplierOrderServiceImpl
implements SupplierOrderService {
    @Resource
    protected SupplierOrderMapper supplierOrderMapper;
    @Resource
    protected SupplierOrderItemService supplierOrderItemService;
    @Resource
    protected PurchaseOrderService purchaseOrderService;
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;

    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void addObj(SupplierOrder t) {
        this.supplierOrderMapper.insertSelective(t);
    }

    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplierOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void modifyObj(SupplierOrder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.supplierOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public SupplierOrder queryObjById(String id) {
        return this.supplierOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public List<SupplierOrder> queryAllObjByExample(SupplierOrderExample example) {
        return this.supplierOrderMapper.selectByExample(example);
    }

    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrder> queryObjByPage(SupplierOrderExample example) {
        PageView<SupplierOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public String insertHis(String orderId, String cause) {
        String hisOrderId = UUIDGenerator.generateUUID();
        this.supplierOrderMapper.insertHis(hisOrderId, orderId, cause, new Date());
        return hisOrderId;
    }

    @Override
    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void updateBySupplierOrder(SupplierOrder record, SupplierOrderExample example) {
        this.supplierOrderMapper.updateByExampleSelective(record, example);
    }

    @Override
    public void isHaveNewOrder(String orderId) {
        Assert.isNotBlank((String)orderId, (String)"\u91c7\u8d2d\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseOrder purchaseOrder = (PurchaseOrder)this.purchaseOrderService.queryObjById(orderId);
        Assert.isNotNull((Object)purchaseOrder, (String)"\u91c7\u8d2d\u65b9\u5df2\u5220\u9664\u8be5\u8ba2\u5355");
        if (purchaseOrder.getOrderSendStatus() == PurchaseOrderSendStatusEnum.UPDATE_NOTSEND.getValue()) {
            throw new CommonException("\u6b64\u8ba2\u5355\u5ba2\u6237\u5df2\u53d8\u66f4\uff0c\u6682\u65f6\u4e0d\u53ef\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u53d1\u9001\u6700\u65b0\u8ba2\u5355");
        }
    }

    @Override
    public PageView<SupplierOrder> findByPageForAvaliableOrder(SupplierOrderExample example) {
        PageView<SupplierOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderMapper.selectVisableOrderByExampleByPage(example));
        return pageView;
    }

    @Override
    public boolean isSameType(Set<String> orderIdList) {
        boolean boo = true;
        ArrayList idList = new ArrayList();
        CollectionUtils.addAll(idList, orderIdList.iterator());
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andIdIn((List)idList);
        List<SupplierOrder> list = this.queryAllObjByExample(example);
        String type = null;
        for (SupplierOrder order : list) {
            if (type == null) {
                type = order.getOrderType();
                continue;
            }
            if (type.equals(order.getOrderType())) continue;
            return false;
        }
        return boo;
    }

    @Override
    @Cacheable(value={"supplierOrder"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierOrder> queryAllHisOrderByExample(SupplierOrderExample example) {
        PageView<SupplierOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    public void test() {
    }

    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void deleteByExample(SupplierOrderExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.supplierOrderMapper.deleteByExample(example);
    }

    @CacheEvict(value={"supplierOrder"}, allEntries=true)
    public void addAll(List<SupplierOrder> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.supplierOrderMapper.insertBatch(list);
    }
}

