/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.utils;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.purchase.utils.ConfirmOrderStatusConverter;
import com.els.base.purchase.utils.SendStatusConverter;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.excel.YesOrNoIntegerConverter;
import com.els.base.utils.excel.YesOrNoStringConverter;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class ExcelFileDataUtils {
    public static FileData createExcelFileOutputStream(List<TitleAndModelKey> titleAndModelKeys, List<? extends Object> list, String sheetTitle, String headTitle, int i) throws IOException, WriteException, ParseException {
        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileData.setProjectId(ProjectUtils.getProjectId());
        fileData.setCompanyId(CompanyUtils.currentCompanyId());
        fileData.setFileName(MessageFormat.format(headTitle + "-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream outputStream = new FileOutputStream(fileData.toFile());
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)sheetTitle, null, (int)i);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return fileData;
    }

    public static List<TitleAndModelKey> createTitleAndModelKeysForPur() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        ConfirmOrderStatusConverter converter = new ConfirmOrderStatusConverter();
        YesOrNoIntegerConverter yesNoIntConverter = new YesOrNoIntegerConverter();
        YesOrNoStringConverter yesNoStringConverter = new YesOrNoStringConverter();
        SendStatusConverter sendStatusConverter = new SendStatusConverter();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"order.orderNo"));
        TitleAndModelKey sendTime = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u5e03\u65e5\u671f", (String)"order.sendTime");
        sendTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(sendTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0b\u5355\u8d1f\u8d23\u4eba", (String)"order.purPlanerName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u7c7b\u522b", (String)"order.orderType"));
        TitleAndModelKey orderSendStatus = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u5e03\u72b6\u6001", (String)"order.orderSendStatus");
        orderSendStatus.setToStrConverter((ObjToStrConverter)sendStatusConverter);
        titleAndModelKeys.add(orderSendStatus);
        TitleAndModelKey orderStatus = ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u72b6\u6001", (String)"order.orderStatus");
        orderStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(orderStatus);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"order.supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"order.supCompanyName"));
        TitleAndModelKey orderDate = ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u51ed\u8bc1\u65e5\u671f", (String)"order.orderDate");
        orderDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(orderDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"order.purCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u522b", (String)"order.currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"order.supRemark"));
        TitleAndModelKey auditStatus = ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6279\u72b6\u6001", (String)"order.auditStatus");
        auditStatus.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        titleAndModelKeys.add(auditStatus);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba", (String)"order.supplierPerson"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7535\u8bdd", (String)"order.supplierTel"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4f20\u771f", (String)"order.supplierFax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"order.payTerms"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6\u63cf\u8ff0", (String)"order.payTermsDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u5458", (String)"order.purUserName"));
        TitleAndModelKey freeFlag = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u514d\u8d39", (String)"order.freeFlag");
        freeFlag.setDefaultValue("\u5426");
        freeFlag.setToStrConverter((ObjToStrConverter)yesNoStringConverter);
        titleAndModelKeys.add(freeFlag);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u9879\u76ee", (String)"orderItem.orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5730\u5740", (String)"orderItem.deliveryLocation"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5907\u6ce8", (String)"orderItem.supRemark"));
        TitleAndModelKey deliveredDate = ExcelUtils.createTitleAndModelKey((String)"\u4ea4\u8d27\u65e5\u671f", (String)"orderItem.deliveredDate");
        deliveredDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(deliveredDate);
        TitleAndModelKey isRefusePrice = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u62d2\u7edd\u4ef7\u683c", (String)"orderItem.isRefusePrice");
        isRefusePrice.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        titleAndModelKeys.add(isRefusePrice);
        TitleAndModelKey isRefuseQuantity = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u62d2\u7edd\u6570\u91cf", (String)"orderItem.isRefuseQuantity");
        isRefuseQuantity.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        titleAndModelKeys.add(isRefuseQuantity);
        TitleAndModelKey isRefuseDeliveredDate = ExcelUtils.createTitleAndModelKey((String)"\u662f\u5426\u62d2\u7edd\u4ea4\u671f", (String)"orderItem.isRefuseDeliveredDate");
        isRefuseDeliveredDate.setToStrConverter((ObjToStrConverter)yesNoIntConverter);
        titleAndModelKeys.add(isRefuseDeliveredDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7", (String)"orderItem.purReqNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u53f7", (String)"orderItem.purReqItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"orderItem.materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"orderItem.materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u6570\u91cf", (String)"orderItem.quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u672c\u5355\u4f4d", (String)"orderItem.orderUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b58\u5e93\u5730\u70b9", (String)"orderItem.warehouseLocation"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387%", (String)"orderItem.taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387\u63cf\u8ff0", (String)"orderItem.taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u603b\u4ef7", (String)"orderItem.totalPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u6536\u8d27\u6570\u91cf", (String)"orderItem.receivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5728\u9014\u6570\u91cf", (String)"orderItem.onwayQuantity"));
        return titleAndModelKeys;
    }
}

