/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.delivery.dao.DeliveryPackageMapper;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.entity.DeliveryPackageExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryPackageService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryPackageService")
public class DeliveryPackageServiceImpl
implements DeliveryPackageService {
    @Resource
    protected DeliveryPackageMapper deliveryPackageMapper;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;

    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void addObj(DeliveryPackage t) {
        this.deliveryPackageMapper.insertSelective(t);
    }

    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryPackageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void modifyObj(DeliveryPackage t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.deliveryPackageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public DeliveryPackage queryObjById(String id) {
        return this.deliveryPackageMapper.selectByPrimaryKey(id);
    }

    public List<DeliveryPackage> queryAllObjByExample(DeliveryPackageExample example) {
        return this.deliveryPackageMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryPackage> queryObjByPage(DeliveryPackageExample example) {
        PageView<DeliveryPackage> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPackageMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    @Transactional
    public void save(List<DeliveryPackage> deliveryPackageList) {
        Assert.isNotEmpty(deliveryPackageList, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e");
        deliveryPackageList.forEach(deliveryPackage -> {
            Assert.isNotBlank((String)deliveryPackage.getDeliveryOrderId(), (String)"\u9001\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)deliveryPackage.getDeliveryQuantity(), (String)"\u5305\u88c5\u660e\u7ec6\u6bcf\u4ef6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)deliveryPackage.getPackageQuantity(), (String)"\u5305\u88c5\u660e\u7ec6\u4e2d\u5305\u88c5\u4ef6\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)deliveryPackage.getTotalQuantity(), (String)"\u5305\u88c5\u660e\u7ec6\u4e2d\u603b\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            deliveryPackage.setCreateTime(new Date());
            deliveryPackage.setId(UUIDGenerator.generateUUID());
        });
        this.deliveryPackageMapper.insertBatch(deliveryPackageList);
    }

    @Override
    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void deleteByExample(DeliveryPackageExample deliveryPackageExample) {
        if (deliveryPackageExample == null || CollectionUtils.isEmpty(deliveryPackageExample.getOredCriteria())) {
            return;
        }
        this.deliveryPackageMapper.deleteByExample(deliveryPackageExample);
    }

    @Override
    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryPackage> queryByDeliveryOrderItemId(String deliveryOrderItemId) {
        DeliveryPackageExample example = new DeliveryPackageExample();
        example.createCriteria().andDeliveryOrderItemIdEqualTo(deliveryOrderItemId);
        return this.deliveryPackageMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"deliveryPackage"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryPackage> queryByDeliveryOrderId(String deliveryOrderId) {
        DeliveryPackageExample example = new DeliveryPackageExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrderId);
        return this.deliveryPackageMapper.selectByExample(example);
    }

    @CacheEvict(value={"deliveryPackage"}, allEntries=true)
    public void addAll(List<DeliveryPackage> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.deliveryPackageMapper.insertBatch(list);
    }
}

