/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.command.BatchCancelDeliveryItemCommand;
import com.els.base.delivery.command.DownloadExcelCommand;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.utils.DeliveryStatusConverter;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.delivery.utils.ExcelFileDataUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.file.service.IFileManager;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u53d1\u8d27\u884c"})
@Controller
@RequestMapping(value={"deliveryOrderItem"})
public class DeliveryOrderItemController {
    Logger logger = LoggerFactory.getLogger(DeliveryOrderItemController.class);
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected OrderCommandInvoker orderComandInvoker;
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u67e5\u8be2\u6240\u6709\u7684\u9001\u8d27\u901a\u77e5\u5355\u660e\u7ec6")
    @RequestMapping(value={"service/findByPagForPur"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findByPagForPur(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem,\u539f\u578b\u56fe") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView((PageView<DeliveryOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("DELIVERY_ORDER_NO DESC, DELIVERY_ORDER_ITEM_NO ASC");
        DeliveryOrderItemExample.Criteria cri = example.createCriteria();
        cri.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andDeliveryStatusNotEqualTo(DeliveryStatusEnum.UN_SENT.getValue());
        User loginUser = SpringSecurityUtils.getLoginUser();
        List departList = this.departmentService.queryDepartmentsOfUser(loginUser.getId());
        if (CollectionUtils.isNotEmpty((Collection)departList)) {
            List ids = departList.stream().map(Department::getId).distinct().collect(Collectors.toList());
            cri.andDepartIdIn(ids);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u6240\u6709\u7684\u9001\u8d27\u901a\u77e5\u5355\u660e\u7ec6")
    @RequestMapping(value={"service/findByPagForSup"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findByPagForSup(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem,\u539f\u578b\u56fe") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView((PageView<DeliveryOrderItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("DELIVERY_ORDER_NO DESC, DELIVERY_ORDER_ITEM_NO ASC");
        example.createCriteria().andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u53d1\u8d27\u53f7\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u884c:")
    @RequestMapping(value={"service/findByDeliveryOrder"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findByDeliveryOrder(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u53d1\u8d27\u5355\u53f7Id") String deliveryOrderId) {
        if (StringUtils.isBlank((String)deliveryOrderId)) {
            throw new CommonException("\u67e5\u8be2\u5931\u8d25,\u53d1\u8d27\u53f7\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u53d1\u8d27\u53f7"});
        }
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView((PageView<DeliveryOrderItem>)new PageView(pageNo, pageSize));
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andDeliveryOrderIdEqualTo(deliveryOrderId);
        PageView pageData = this.deliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7id\u67e5\u8be2\u53d1\u8d27\u5355\u884c\u5386\u53f2")
    @RequestMapping(value={"service/findHisById"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findHisById(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u53d1\u8d27\u5355\u884cid") String id) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView((PageView<DeliveryOrderItem>)new PageView(pageNo, pageSize));
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("last_update_time DESC");
        PageView<DeliveryOrderItem> pageData = this.deliveryOrderItemService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868")
    @RequestMapping(value={"service/queryDeliveryOrderItemForLogisticByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> queryDeliveryOrderItemForLogisticByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem,\u539f\u578b\u56fe") @RequestBody(required=false) QueryParamWapper wapper) {
        this.logger.info("\u8fdb\u5165\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868");
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView((PageView<DeliveryOrderItem>)new PageView(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868\uff08\u91c7\u8d2d\u65b9\uff09")
    @RequestMapping(value={"service/queryDeliveryOrderItemForPurchaseByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> queryDeliveryOrderItemForPurchaseByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem,\u539f\u578b\u56fe") @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView((PageView<DeliveryOrderItem>)new PageView(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryOrderItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868\uff08\u91c7\u8d2d\u65b9\uff09")
    @RequestMapping(value={"service/exportDeliveryOrderItemForPurchase"})
    @ResponseBody
    public ResponseResult<FileData> exportDeliveryOrderItemForPurchase(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderItem") @RequestBody(required=false) QueryParamWapper wapper) throws IOException, RowsExceededException, WriteException, ParseException {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List list = this.deliveryOrderItemService.queryAllObjByExample((IExample)example);
        IFileManager fileManager = FileManagerFactory.getFileManager();
        FileData excelFile = new FileData();
        excelFile.setProjectId(projectId);
        excelFile.setCompanyId(CompanyUtils.currentCompanyId());
        excelFile.setFileName(String.format("\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868-%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd")));
        excelFile.setFileSuffix("xls");
        excelFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        excelFile.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        OutputStream outputStream = fileManager.createOutputStream(excelFile);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, (List)list, (String)"\u7269\u6d41\u8fdb\u5ea6\u62a5\u8868", (String)"", (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return ResponseResult.success((Object)excelFile);
    }

    private List<TitleAndModelKey> createExcelHeader() {
        DateConverter dateConverter = new DateConverter("yyyy-MM-dd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5355\u53f7", (String)"deliveryOrderNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee", (String)"deliveryOrderItemNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5305\u88c5\u4ef6\u6570\t", (String)"packQuantity", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"purOrderNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u9879", (String)"purOrderItemNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u6599\u53f7", (String)"supplierMaterialNumber", (boolean)true));
        TitleAndModelKey deliveryDate = ExcelUtils.createTitleAndModelKey((String)"\u4ea4\u8d27\u65e5\u671f", (String)"deliveryDate", (boolean)true);
        deliveryDate.setToStrConverter((ObjToStrConverter)dateConverter);
        deliveryDate.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKeys.add(deliveryDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u6570\u91cf", (String)"deliveryQuantity", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u522b", (String)"currency", (boolean)true));
        TitleAndModelKey deliveryStatus = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u8d27\u72b6\u6001", (String)"deliveryStatus", (boolean)true);
        deliveryStatus.setToObjConverter((StrToObjConverter)new DeliveryStatusConverter());
        deliveryStatus.setToStrConverter((ObjToStrConverter)new DeliveryStatusConverter());
        titleAndModelKeys.add(deliveryStatus);
        TitleAndModelKey createTime = ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u65b9\u51fa\u5382\u65f6\u95f4\t", (String)"createTime", (boolean)true);
        createTime.setToStrConverter((ObjToStrConverter)dateConverter);
        createTime.setToObjConverter((StrToObjConverter)dateConverter);
        titleAndModelKeys.add(createTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"FGE\u95e8\u5c97\u65f6\u95f4", (String)"gateScan", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed3\u5e93\u6536\u8d27\u65f6\u95f4", (String)"warehouseScan", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u65b9\u6536\u8d27\u5de5\u5382", (String)"factoryCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6536\u8d27\u5de5\u5382\u540d\u79f0", (String)"factoryName", (boolean)true));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u8d27\u5355\u7ba1\u7406-\u6279\u91cf\u4f5c\u5e9f\u53d1\u8d27\u3002\u6279\u91cf\u64a4\u9500\u53d1\u8d27\u5355\uff1a\u5165\u53c2\uff08\u53d1\u8d27\u5355\u5934id\u6570\u7ec4\uff09")
    @RequestMapping(value={"service/cancelDeliveryItem"})
    @ResponseBody
    public ResponseResult<String> cancelDeliveryItem(@RequestBody List<String> deliveryOrderItemIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderItemIdList)) {
            throw new CommonException("\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "not_query_to_data");
        }
        BatchCancelDeliveryItemCommand command = new BatchCancelDeliveryItemCommand(deliveryOrderItemIdList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderComandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6536\u8d27")
    @RequestMapping(value={"service/receivingItem"})
    @ResponseBody
    public ResponseResult<String> receivingItem(@RequestBody DeliveryOrderItem item) {
        Assert.isNotNull((Object)item, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6536\u8d27\u5931\u8d25");
        Assert.isNotNull((Object)item.getReceivedQuantity(), (String)"\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)item.getReceivedDate(), (String)"\u6536\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        this.deliveryOrderItemService.receiving(item, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(value="\u91c7\u8d2d\u65b9\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        DeliveryOrderItemExample orderItemExample = new DeliveryOrderItemExample();
        orderItemExample.setOrderByClause("DELIVERY_ORDER_NO DESC, DELIVERY_ORDER_ITEM_NO ASC");
        DeliveryOrderItemExample.Criteria criteria = orderItemExample.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        List orderItems = null;
        if (CollectionUtils.isEmpty(ids)) {
            orderItems = this.deliveryOrderItemService.queryAllObjByExample((IExample)orderItemExample);
            Assert.isNotEmpty((Collection)orderItems, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            criteria.andIdIn((List)ids);
            orderItems = this.deliveryOrderItemService.queryAllObjByExample((IExample)orderItemExample);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.orderComandInvoker.invoke(new DownloadExcelCommand(orderItems));
        FileData fileData = ExcelFileDataUtils.createExcelFileOutputStream(titleAndModelKeys, orderItems, "\u9001\u8d27\u5355\u660e\u7ec6\u6570\u636e", "\u9001\u8d27\u5355\u660e\u7ec6\u6570\u636e", 0);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelSup"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelSup(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        DeliveryOrderItemExample orderItemExample = new DeliveryOrderItemExample();
        orderItemExample.setOrderByClause("DELIVERY_ORDER_NO DESC, DELIVERY_ORDER_ITEM_NO ASC");
        DeliveryOrderItemExample.Criteria criteria = orderItemExample.createCriteria();
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        List orderItems = null;
        if (CollectionUtils.isEmpty(ids)) {
            criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            orderItems = this.deliveryOrderItemService.queryAllObjByExample((IExample)orderItemExample);
            Assert.isNotEmpty((Collection)orderItems, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            criteria.andIdIn((List)ids);
            orderItems = this.deliveryOrderItemService.queryAllObjByExample((IExample)orderItemExample);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.orderComandInvoker.invoke(new DownloadExcelCommand(orderItems));
        FileData fileData = ExcelFileDataUtils.createExcelFileOutputStream(titleAndModelKeys, orderItems, "\u9001\u8d27\u5355\u660e\u7ec6\u6570\u636e", "\u9001\u8d27\u5355\u660e\u7ec6\u6570\u636e", 0);
        return ResponseResult.success((Object)fileData);
    }
}

