/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.MaterialFileNotice;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSendToPurCmd;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.purchase.command.order.sup.ConfirmOrderItemCommand;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderChangeExample;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.entity.SupplierOrderItemExample;
import com.els.base.purchase.utils.BusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ConfirmTheWholeOrderCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private SupplierOrder supplierOrder;

    public ConfirmTheWholeOrderCommand(SupplierOrder order) {
        this.supplierOrder = order;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supplierOrder);
        List<SupplierOrderItem> items = this.getOrderItems();
        this.confirmOrderHeder(this.supplierOrder);
        this.confirmOrderItems(items, this.supplierOrder);
        this.confirmOrderChange(this.supplierOrder);
        this.confirmPlan(this.supplierOrder);
        this.backupOrder(this.supplierOrder);
        this.sendMessage();
        this.supplierOrder.setItems(items);
        return null;
    }

    private void vaildMaterialFileConfirmStatus(List<SupplierOrderItem> items) {
        List materialCodes = items.stream().map(SupplierOrderItem::getMaterialCode).distinct().collect(Collectors.toList());
        List list = ContextUtils.getMaterialFileNoticeService().selectUnConfirmByMaterialCodes(materialCodes, this.supplierOrder.getSupCompanyId());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String codes = list.stream().map(MaterialFileNotice::getMaterialCode).distinct().collect(Collectors.joining(","));
            throw new CommonException(String.format("\u8ba2\u5355\u53f7\uff1a%s\u5b58\u5728\u672a\u786e\u8ba4\u7684\u7269\u6599\u6587\u6863\uff1a%s", this.supplierOrder.getOrderNo(), codes));
        }
    }

    private List<SupplierOrderItem> getOrderItems() {
        SupplierOrderItemExample exampleItem = new SupplierOrderItemExample();
        exampleItem.createCriteria().andSupCompanyIdEqualTo(this.supplierOrder.getSupCompanyId()).andOrderIdEqualTo(this.supplierOrder.getId());
        return ContextUtils.getSupplierOrderItemService().queryAllObjByExample((IExample)exampleItem);
    }

    private void confirmPlan(SupplierOrder supplierOrder) {
        if (CollectionUtils.isNotEmpty(supplierOrder.getPlanItemList())) {
            this.confirmPlanByDetail(supplierOrder);
        } else {
            this.confirmWholePlan(supplierOrder);
        }
    }

    private void confirmWholePlan(SupplierOrder supplierOrder) {
        ContextUtils.getPurDeliveryPlanItemService().confirmAllPlan(supplierOrder.getId());
        ContextUtils.getSupDeliveryPlanItemService().confirmAllPlan(supplierOrder.getId());
        PurDeliveryPlanItemExample purExample = new PurDeliveryPlanItemExample();
        purExample.createCriteria().andPurOrderIdEqualTo(supplierOrder.getId());
        PurDeliveryPlanItem purItem = new PurDeliveryPlanItem();
        if (this.getSupUser() != null) {
            purItem.setSupUserId(this.getSupUser().getId());
            purItem.setSupUserName(this.getSupUser().getNickName());
        }
        purItem.setConfirmTime(new Date());
        purItem.setPurOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        purItem.setChangeStatus(PlanChangeStatusEnum.SUP_CONFIRM.getValue());
        purItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        purItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purItem, purExample);
        SupDeliveryPlanItemExample supExample = new SupDeliveryPlanItemExample();
        supExample.createCriteria().andPurOrderIdEqualTo(supplierOrder.getId());
        SupDeliveryPlanItem supItem = new SupDeliveryPlanItem();
        if (this.getSupUser() != null) {
            supItem.setSupUserId(this.getSupUser().getId());
            supItem.setSupUserName(this.getSupUser().getNickName());
        }
        supItem.setConfirmTime(new Date());
        supItem.setPurOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        supItem.setChangeStatus(PlanChangeStatusEnum.SUP_CONFIRM.getValue());
        supItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        supItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supItem, supExample);
    }

    private void confirmPlanByDetail(SupplierOrder supplierOrder) {
        for (SupDeliveryPlanItem purItem : supplierOrder.getPlanItemList()) {
            purItem.setPurOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            purItem.setChangeStatus(PlanChangeStatusEnum.SUP_CONFIRM.getValue());
            purItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            purItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            purItem.setConfirmTime(new Date());
            if (this.getSupUser() != null) {
                purItem.setSupUserId(this.getSupUser().getId());
                purItem.setSupUserName(this.getSupUser().getNickName());
            }
            if (!StringUtils.isBlank((String)purItem.getSupRemark())) continue;
            purItem.setSupRemark("");
        }
        NoneJitPlanSendToPurCmd planSendToPurCmd = new NoneJitPlanSendToPurCmd(supplierOrder.getPlanItemList(), PlanDataSourceEnum.UI);
        planSendToPurCmd.copyProperties(this);
        this.context.invoke(planSendToPurCmd);
    }

    private void confirmOrderChange(SupplierOrder supplierOrder) {
        PurchaseOrderChangeExample changeExample = new PurchaseOrderChangeExample();
        changeExample.createCriteria().andOrderIdEqualTo(supplierOrder.getId());
        PurchaseOrderChange change = new PurchaseOrderChange();
        change.setConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        ContextUtils.getPurchaseOrderChangeService().modifyByExample(change, changeExample);
    }

    private void confirmOrderItems(List<SupplierOrderItem> supplierOrderItems, SupplierOrder supplierOrder) {
        if (CollectionUtils.isNotEmpty(supplierOrder.getItems())) {
            this.setSupRemark(supplierOrderItems, supplierOrder.getItems());
        }
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            ConfirmOrderItemCommand command = new ConfirmOrderItemCommand(supplierOrderItem, supplierOrder);
            command.copyProperties(this);
            this.context.invoke(command);
        }
    }

    private void setSupRemark(List<SupplierOrderItem> targetItems, List<SupplierOrderItem> sourceItems) {
        for (SupplierOrderItem supplierOrderItem : targetItems) {
            String supRemark = sourceItems.stream().filter(source -> supplierOrderItem.getId().equals(source.getId())).findAny().orElseThrow(() -> new CommonException("\u63d0\u4ea4\u7684\u8ba2\u5355\u884c\u6570\u636e\u5f02\u5e38")).getSupRemark();
            supplierOrderItem.setSupRemark(supRemark);
        }
    }

    private void confirmOrderHeder(SupplierOrder supplierOrder) {
        SupplierOrder tmpSupplierOrder = new SupplierOrder();
        tmpSupplierOrder.setId(supplierOrder.getId());
        tmpSupplierOrder.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        tmpSupplierOrder.setSupRemark(supplierOrder.getSupRemark());
        tmpSupplierOrder.setLastUpdateTime(new Date());
        tmpSupplierOrder.setReplyTime(new Date());
        if (this.getSupUser() != null) {
            tmpSupplierOrder.setSupUserName(this.getSupUser().getNickName());
            tmpSupplierOrder.setSupUserId(this.getSupUser().getId());
        }
        ContextUtils.getSupplierOrderService().modifyObj(tmpSupplierOrder);
        PurchaseOrder record = new PurchaseOrder();
        record.setId(supplierOrder.getId());
        record.setSupRemark(supplierOrder.getSupRemark());
        record.setOrderStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        record.setLastUpdateTime(new Date());
        record.setReplyTime(new Date());
        if (this.getSupUser() != null) {
            record.setSupUserId(this.getSupUser().getId());
            record.setSupUserName(this.getSupUser().getNickName());
        }
        ContextUtils.getPurchaseOrderService().modifyObj(record);
    }

    private void backupOrder(SupplierOrder supplierOrder) {
        String purOrderHisId = ContextUtils.getPurchaseOrderService().insertHis(supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        ContextUtils.getPurchaseOrderItemService().insertHisByOrderId(purOrderHisId, supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        String supOrderHisId = ContextUtils.getSupplierOrderService().insertHis(supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        ContextUtils.getSupplierOrderItemService().insertHisByOrderId(supOrderHisId, supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
        ContextUtils.getSupDeliveryPlanItemService().insertHisByOrderId(supOrderHisId, supplierOrder.getId(), "\u8ba2\u5355\u5934\u786e\u8ba4");
    }

    private void sendMessage() {
        Message message = Message.init((Object)this.supplierOrder).setCompanyCode(this.supplierOrder.getSupCompanySrmCode()).addReceiverId(this.supplierOrder.getPurPlanerId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(BusinessTypeEnum.PO_CONFIRM.getCode());
        if (this.getSupUser() != null) {
            message.setSenderId(this.getSupUser().getId());
        }
        MessageSendUtils.sendMessage((Message)message);
    }

    private void valid(SupplierOrder order) {
        if (order.getSupRemark() != null && order.getSupRemark().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        if (CollectionUtils.isNotEmpty(order.getItems())) {
            for (SupplierOrderItem item : order.getItems()) {
                Assert.isNotBlank((String)item.getId(), (String)"\u8ba2\u5355\u884cID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        Assert.isNotBlank((String)this.supplierOrder.getId(), (String)"\u91c7\u8d2d\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        SupplierOrder temp = (SupplierOrder)ContextUtils.getSupplierOrderService().queryObjById(order.getId());
        if (!PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(temp.getOrderStatus())) {
            throw new CommonException(String.format("\u8ba2\u5355[%s]\u5df2\u56de\u7b7e\uff0c\u4e0d\u7528\u91cd\u590d\u786e\u8ba4", temp.getOrderNo()));
        }
        ContextUtils.getSupplierOrderService().isHaveNewOrder(this.supplierOrder.getId());
    }
}

