/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.catalogue.service.impl;

import com.els.base.catalogue.dao.PurchaseCatalogueHeadMapper;
import com.els.base.catalogue.entity.PurchaseCatalogueHead;
import com.els.base.catalogue.entity.PurchaseCatalogueHeadExample;
import com.els.base.catalogue.service.PurchaseCatalogueHeadService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseCatalogueHeadService")
public class PurchaseCatalogueHeadServiceImpl
implements PurchaseCatalogueHeadService {
    @Resource
    protected PurchaseCatalogueHeadMapper purchaseCatalogueHeadMapper;

    @Override
    @CacheEvict(value={"purchaseCatalogueHead"}, allEntries=true)
    public int updateByExampleSelective(PurchaseCatalogueHead record, PurchaseCatalogueHeadExample example) {
        return this.purchaseCatalogueHeadMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"purchaseCatalogueHead"}, allEntries=true)
    public void addObj(PurchaseCatalogueHead t) {
        this.purchaseCatalogueHeadMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseCatalogueHead"}, allEntries=true)
    public void addAll(List<PurchaseCatalogueHead> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseCatalogueHeadMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseCatalogueHead"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseCatalogueHeadMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseCatalogueHead"}, allEntries=true)
    public void deleteByExample(PurchaseCatalogueHeadExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseCatalogueHeadMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseCatalogueHead"}, allEntries=true)
    public void modifyObj(PurchaseCatalogueHead t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseCatalogueHeadMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseCatalogueHead"}, keyGenerator="redisKeyGenerator")
    public PurchaseCatalogueHead queryObjById(String id) {
        return this.purchaseCatalogueHeadMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseCatalogueHead"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseCatalogueHead> queryAllObjByExample(PurchaseCatalogueHeadExample example) {
        return this.purchaseCatalogueHeadMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseCatalogueHead"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseCatalogueHead> queryObjByPage(PurchaseCatalogueHeadExample example) {
        PageView<PurchaseCatalogueHead> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseCatalogueHeadMapper.selectByExampleByPage(example));
        return pageView;
    }
}

