/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.common.OrderCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.dao.PurVoucherMapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.entity.PurVoucher;
import com.els.base.delivery.entity.PurVoucherExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.service.PurVoucherService;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.plan.command.ModifyPlanReceiveQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurVoucherService")
public class PurVoucherServiceImpl
implements PurVoucherService {
    private static final Logger logger = LoggerFactory.getLogger(PurVoucherServiceImpl.class);
    private static final String NAGATIVE_MARK = "-";
    private static final BigDecimal NAGATIVE_NUM = new BigDecimal(-1);
    @Resource(name="orderComandInvoker")
    protected OrderCommandInvoker context;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected PurVoucherMapper purVoucherMapper;

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void addObj(PurVoucher t) {
        this.purVoucherMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void addAll(List<PurVoucher> vouchers) {
        if (CollectionUtils.isEmpty(vouchers)) {
            return;
        }
        vouchers.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        List group = Lists.partition(vouchers, (int)30);
        for (List list : group) {
            this.purVoucherMapper.insertBatch(list);
        }
    }

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purVoucherMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void modifyObj(PurVoucher t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purVoucherMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purVoucher"}, keyGenerator="redisKeyGenerator")
    public PurVoucher queryObjById(String id) {
        return this.purVoucherMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purVoucher"}, keyGenerator="redisKeyGenerator")
    public List<PurVoucher> queryAllObjByExample(PurVoucherExample example) {
        return this.purVoucherMapper.selectByExample(example);
    }

    @Cacheable(value={"purVoucher"}, keyGenerator="redisKeyGenerator")
    public PageView<PurVoucher> queryObjByPage(PurVoucherExample example) {
        PageView<PurVoucher> pageView = example.getPageView();
        pageView.setQueryResult(this.purVoucherMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"purVoucher"}, allEntries=true)
    public void deleteByExample(PurVoucherExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purVoucherMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"purVoucher"}, allEntries=true)
    @Transactional
    public void updateDeliveryOrderAndInsertVoucher(String deliveryOrderNo, List<PurVoucher> vouchers) {
        List<PurVoucher> successVoucher = this.updateDeliveryOrder(deliveryOrderNo, vouchers);
        if (CollectionUtils.isEmpty(successVoucher)) {
            logger.warn("\u6709\u6548\u7684\u53ef\u5904\u7406\u6536\u8d27\u51ed\u8bc1\u4e3a\u7a7a");
            return;
        }
        successVoucher.forEach(voucher -> voucher.setBillFlag(Constant.YES_INT));
        this.addAll(successVoucher);
    }

    private List<PurVoucher> updateDeliveryOrder(String deliveryOrderNo, List<PurVoucher> totalVoucher) {
        List deliveryOrdreItemNoList = totalVoucher.stream().map(PurVoucher::getDeliveryOrderItemNo).distinct().collect(Collectors.toList());
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo).andDeliveryOrderItemNoIn(deliveryOrdreItemNoList);
        List deliveryOrderItemList = this.deliveryOrderItemService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)deliveryOrderItemList)) {
            logger.warn("EVENT=\u5904\u7406\u6536\u8d27\u51ed\u8bc1|MSG=\u51ed\u8bc1\u4e2d\u7684\u9001\u8d27\u5355\u6570\u636e\uff0c\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            return null;
        }
        ArrayList<PurVoucher> totalFailVoucher = new ArrayList<PurVoucher>();
        ArrayList<DeliveryOrderItem> failDeliveryOrderItem = new ArrayList<DeliveryOrderItem>();
        Date voucherTime = null;
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrderItemList) {
            List<PurVoucher> voucherList = totalVoucher.stream().filter(tmpVoucher -> deliveryOrderItem.getDeliveryOrderNo().equals(tmpVoucher.getDeliveryOrderNo()) && deliveryOrderItem.getDeliveryOrderItemNo().equals(tmpVoucher.getDeliveryOrderItemNo())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(voucherList)) {
                logger.warn(String.format("\u9001\u8d27\u5355[%s][%s]\u6536\u8d27\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u5408\u9002\u7684\u6536\u8d27\u51ed\u8bc1.", deliveryOrderItem.getDeliveryOrderNo(), deliveryOrderItem.getDeliveryOrderItemNo()));
                failDeliveryOrderItem.add(deliveryOrderItem);
                continue;
            }
            List<PurVoucher> failVoucher = voucherList.stream().filter(purVoucher -> !deliveryOrderItem.getPurOrderNo().equals(purVoucher.getPurchaseOrderNo()) || !deliveryOrderItem.getPurOrderItemNo().equals(purVoucher.getPurchaseOrderItemNo())).collect(Collectors.toList());
            totalFailVoucher.addAll(failVoucher);
            if (CollectionUtils.isNotEmpty(failVoucher)) {
                voucherList.removeAll(failVoucher);
                failVoucher.forEach(purVoucher -> logger.warn(String.format("\u9001\u8d27\u5355[%s][%s]\u6536\u8d27\u5931\u8d25\u3002\u6536\u8d27\u51ed\u8bc1[%s][%s]\u6536\u8d27\u5931\u8d25,\u8ba2\u5355\u6570\u636e\u4e0d\u4e00\u81f4\u3002\u51ed\u8bc1\u8ba2\u5355\u6570\u636e[%s][%s]\uff0c\u4e0e\u9001\u8d27\u5355\u8ba2\u5355\u6570\u636e[%s][%s]", deliveryOrderNo, deliveryOrderItem.getDeliveryOrderItemNo(), purVoucher.getMaterialVoucherNo(), purVoucher.getMaterialVoucherItemNo(), purVoucher.getPurchaseOrderNo(), purVoucher.getPurchaseOrderItemNo(), deliveryOrderItem.getPurOrderNo(), deliveryOrderItem.getPurOrderItemNo())));
            }
            if (CollectionUtils.isEmpty(voucherList)) {
                logger.warn(String.format("\u9001\u8d27\u5355[%s][%s]\u6536\u8d27\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u5408\u9002\u7684\u6536\u8d27\u51ed\u8bc1.", deliveryOrderItem.getDeliveryOrderNo(), deliveryOrderItem.getDeliveryOrderItemNo()));
                failDeliveryOrderItem.add(deliveryOrderItem);
                continue;
            }
            voucherTime = ((PurVoucher)voucherList.get(0)).getVoucherTime();
            if (!DeliveryStatusEnum.ALL_RECEIVED.getValue().equals(deliveryOrderItem.getDeliveryStatus()) && Constant.YES_INT.equals(deliveryOrderItem.getIsEnable())) {
                this.context.invoke(new ModifyPlanOnWayQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_RECEIVE, deliveryOrderItem.getDeliveryQuantity()));
                this.context.invoke(new ModifyOrderItemOnWayQuantityCmd(deliveryOrderItem.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_RECEIVE, deliveryOrderItem.getDeliveryQuantity()));
            }
            this.updateDeliveryOrderItem(deliveryOrderItem, voucherList);
            this.updateDeliveryPlanItem(deliveryOrderItem, voucherList);
            String voucherStr = voucherList.stream().map(v -> v.getMaterialVoucherNo() + NAGATIVE_MARK + v.getMaterialVoucherItemNo()).collect(Collectors.joining(","));
            logger.warn(String.format("\u9001\u8d27\u5355[%s][%s]\u6536\u8d27\u5b8c\u6210,\u5904\u7406\u6536\u8d27\u51ed\u8bc1: %s.", deliveryOrderItem.getDeliveryOrderNo(), deliveryOrderItem.getDeliveryOrderItemNo(), voucherStr));
        }
        if (CollectionUtils.isNotEmpty(totalFailVoucher)) {
            totalVoucher.removeAll(totalFailVoucher);
        }
        if (CollectionUtils.isEmpty(totalVoucher)) {
            logger.warn(String.format("\u9001\u8d27\u5355[%s]\u6536\u8d27\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u5408\u9002\u7684\u6536\u8d27\u51ed\u8bc1.", deliveryOrderNo));
            return totalVoucher;
        }
        if (CollectionUtils.isNotEmpty(failDeliveryOrderItem)) {
            deliveryOrderItemList.removeAll(failDeliveryOrderItem);
        }
        List<String> planItemIdList = deliveryOrderItemList.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        this.context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        this.updateDeliveryOrder(deliveryOrderNo, voucherTime);
        return totalVoucher;
    }

    private void updateDeliveryOrderItem(DeliveryOrderItem deliveryOrderItem, List<PurVoucher> voucherList) {
        BigDecimal voucherReceiverQuantity = BigDecimal.ZERO;
        for (PurVoucher purVoucher : voucherList) {
            BigDecimal voucherQuantity;
            BigDecimal bigDecimal = voucherQuantity = purVoucher.getQuantity() == null ? BigDecimal.ZERO : purVoucher.getQuantity();
            if (NAGATIVE_MARK.equals(purVoucher.getMark())) {
                voucherQuantity = voucherQuantity.multiply(NAGATIVE_NUM);
            }
            voucherReceiverQuantity = voucherReceiverQuantity.add(voucherQuantity);
        }
        BigDecimal total = StringUtils.isBlank((String)deliveryOrderItem.getReceiptQuantity()) ? BigDecimal.ZERO : new BigDecimal(deliveryOrderItem.getReceiptQuantity());
        total = total.add(voucherReceiverQuantity);
        DeliveryOrderItem temp = new DeliveryOrderItem();
        temp.setId(deliveryOrderItem.getId());
        temp.setDeliveryStatus(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        temp.setReceiveDate(voucherList.get(0).getVoucherTime());
        temp.setReceiptQuantity(String.valueOf(total));
        this.deliveryOrderItemService.modifyObj(temp);
    }

    private void updateDeliveryPlanItem(DeliveryOrderItem deliveryOrderItem, List<PurVoucher> voucherList) {
        if (CollectionUtils.isEmpty(voucherList)) {
            return;
        }
        BigDecimal totalReceive = BigDecimal.ZERO;
        for (PurVoucher purVoucher : voucherList) {
            BigDecimal voucherQuantity;
            BigDecimal bigDecimal = voucherQuantity = purVoucher.getQuantity() == null ? BigDecimal.ZERO : purVoucher.getQuantity();
            if (NAGATIVE_MARK.equals(purVoucher.getMark())) {
                voucherQuantity = voucherQuantity.multiply(NAGATIVE_NUM);
            }
            totalReceive = totalReceive.add(voucherQuantity);
        }
        this.context.invoke(new ModifyPlanReceiveQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), totalReceive));
    }

    private void updateDeliveryOrder(String deliveryOrderNo, Date voucherTime) {
        DeliveryOrder temp = new DeliveryOrder();
        temp.setDeliveryStatus(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        temp.setReceiveDate(voucherTime);
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrderNo);
        this.deliveryOrderService.modifyByExample(temp, example);
    }
}

