/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.dataSources;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.plan.entity.JitPlanDataSources;
import com.els.base.plan.entity.JitPlanDataSourcesExample;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.els.liby.organization.utils.OrganizationTypeEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ImportDataSourcesCmd
extends AbstractCommand {
    private List<JitPlanDataSources> jitPlanDataSourcesList;

    public ImportDataSourcesCmd(List<JitPlanDataSources> jitPlanDataSourcesList) {
        this.jitPlanDataSourcesList = jitPlanDataSourcesList;
    }

    public Object execute(ICommandInvoker context) {
        this.jitPlanDataSourcesList = this.jitPlanDataSourcesList.stream().distinct().collect(Collectors.toList());
        this.jitPlanDataSourcesList.stream().forEach(jitPlanDataSources -> {
            this.vaild((JitPlanDataSources)jitPlanDataSources);
            this.init((JitPlanDataSources)jitPlanDataSources);
        });
        try {
            ContextUtils.getJitPlanDataSourcesService().addAll(this.jitPlanDataSourcesList);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        return null;
    }

    private void init(JitPlanDataSources jitPlanDataSources) {
        this.vaildAndInitFactory(jitPlanDataSources);
        this.vaildAndInitMasterial(jitPlanDataSources);
        jitPlanDataSources.setCreateTime(new Date());
        jitPlanDataSources.setLastUpdateTime(new Date());
        jitPlanDataSources.setCreateUserId(this.getPurUser().getId());
        jitPlanDataSources.setCreateUserName(this.getPurUser().getNickName());
        jitPlanDataSources.setIsOpenAsp(Constant.YES_INT);
    }

    private void vaildAndInitFactory(JitPlanDataSources jitPlanDataSources) {
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andCodeEqualTo(jitPlanDataSources.getFactory()).andOrganizationTypeEqualTo(OrganizationTypeEnum.FACTORY.getValue());
        List list = ContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)list, (String)("\u5de5\u5382\u7f16\u7801\uff1a" + jitPlanDataSources.getFactory() + "\u4e0d\u5b58\u5728"));
        jitPlanDataSources.setFactoryName(((Organization)list.get(0)).getDescription());
    }

    private void vaildAndInitMasterial(JitPlanDataSources jitPlanDataSources) {
        Material material = ContextUtils.getMaterialService().queryObjByCode(jitPlanDataSources.getMaterialCode());
        Assert.isNotNull((Object)material, (String)("\u7269\u6599\u7f16\u7801\uff1a" + jitPlanDataSources.getMaterialCode() + "\u4e0d\u5b58\u5728"));
        jitPlanDataSources.setMaterialName(material.getDescription());
    }

    private void vaild(JitPlanDataSources jitPlanDataSources) {
        Assert.isNotBlank((String)jitPlanDataSources.getFactory(), (String)"\u5de5\u5382\u7f16\u7801\u4e3a\u7a7a");
        Assert.isNotBlank((String)jitPlanDataSources.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.createCriteria().andFactoryEqualTo(jitPlanDataSources.getFactory()).andMaterialCodeEqualTo(jitPlanDataSources.getMaterialCode());
        List list = ContextUtils.getJitPlanDataSourcesService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\u5de5\u5382\uff1a").append(jitPlanDataSources.getFactory()).append("\u3001").append("\u7269\u6599\uff1a").append(jitPlanDataSources.getMaterialCode()).append("\uff1b").append("\u5df2\u5b58\u5728");
            throw new CommonException(buffer.toString());
        }
    }
}

