/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.plan.entity.DeliveryPlanExample;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class CleanJitPlanCommand
extends AbstractCommand {
    private String materialCode;
    private String factoryCode;
    private Date arrayTime;
    private List<String> ids;

    public CleanJitPlanCommand(String materialCode, String factoryCode) {
        this.materialCode = materialCode;
        this.factoryCode = factoryCode;
    }

    public CleanJitPlanCommand(String materialCode, String factoryCode, Date arrayTime) {
        this.materialCode = materialCode;
        this.factoryCode = factoryCode;
        this.arrayTime = arrayTime;
    }

    public CleanJitPlanCommand(List<String> ids) {
        this.ids = ids;
    }

    public Object execute(ICommandInvoker context) {
        if (CollectionUtils.isNotEmpty(this.ids)) {
            this.deletePlan(this.ids);
        } else {
            List planList;
            List<String> planIds;
            DeliveryPlanExample example = new DeliveryPlanExample();
            DeliveryPlanExample.Criteria criteria = example.createCriteria();
            criteria.andMaterialCodeEqualTo(this.materialCode).andFactoryCodeEqualTo(this.factoryCode).andIsLockNotEqualTo("F").andUsedStatusEqualTo("N");
            if (this.arrayTime != null) {
                criteria.andArryvalTimeEqualTo(this.arrayTime);
            }
            if (CollectionUtils.isNotEmpty(planIds = (planList = ContextUtils.getDeliveryPlanService().queryAllObjByExample((IExample)example)).stream().map(deliveryPlan -> deliveryPlan.getId()).collect(Collectors.toList()))) {
                this.deletePlan(planIds);
            }
        }
        return null;
    }

    private void deletePlan(List<String> ids) {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.createCriteria().andIdIn((List)ids);
        ContextUtils.getDeliveryPlanService().deleteByExample((IExample)example);
    }
}

