/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.entity.DeliveryChangePlan;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.PlanItemImTypeEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;

public class CreateJitChangeRecordCmd
extends AbstractCommand {
    private List<SupDeliveryPlanItem> planItems;

    public CreateJitChangeRecordCmd(List<SupDeliveryPlanItem> planItems) {
        this.planItems = planItems;
    }

    public Object execute(ICommandInvoker context) {
        if (CollectionUtils.isEmpty(this.planItems)) {
            return null;
        }
        for (SupDeliveryPlanItem item : this.planItems) {
            SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
            example.createCriteria().andMaterialNoEqualTo(item.getMaterialNo()).andFactoryCodeEqualTo(item.getFactoryCode()).andDeliveryDateEqualTo(item.getDeliveryDate()).andIsEnableEqualTo(Constant.YES_INT);
            List items = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
            if (item.getIsEnable().equals(Constant.NO_INT) && CollectionUtils.isNotEmpty((Collection)items)) {
                this.insertJitPlanLog((SupDeliveryPlanItem)items.get(0), BigDecimal.ZERO, PlanItemImTypeEnum.PLAN_ITEM_DELETE.getValue());
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                BigDecimal quantity = ((SupDeliveryPlanItem)items.get(0)).getDeliveryQuantity();
                if (item.getDeliveryQuantity().compareTo(quantity) == 0) continue;
                this.insertJitPlanLog(item, quantity, PlanItemImTypeEnum.PLAN_ITEM_MODITY.getValue());
                continue;
            }
            this.insertJitPlanLog(item, BigDecimal.ZERO, PlanItemImTypeEnum.PLAN_ITEM_CREATE.getValue());
        }
        this.buildMsg(this.planItems);
        return null;
    }

    private void insertJitPlanLog(SupDeliveryPlanItem item, BigDecimal quantity, String type) {
        DeliveryChangePlan changePlanItem = new DeliveryChangePlan();
        BeanUtils.copyProperties((Object)item, (Object)changePlanItem);
        changePlanItem.setId(UUIDGenerator.generateUUID());
        changePlanItem.setDeliveryPlanItemId(item.getId());
        changePlanItem.setMaterialCode(item.getMaterialNo());
        changePlanItem.setMaterialDescride(item.getMaterialDesc());
        changePlanItem.setOriginQuantity(quantity == null ? BigDecimal.ZERO : quantity);
        changePlanItem.setChangeQuantity(quantity == null ? item.getDeliveryQuantity() : quantity);
        changePlanItem.setOriginDeliveryDate(item.getDeliveryDate());
        changePlanItem.setCreateTime(new Date());
        changePlanItem.setChangeType(type);
        ContextUtils.getDeliveryChangePlanService().addObj(changePlanItem);
    }

    private void buildMsg(List<SupDeliveryPlanItem> planItems) {
        Map<String, List<SupDeliveryPlanItem>> purCompany = planItems.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurCompanySapCode));
        purCompany.values().forEach(purValues -> {
            Map<String, List<SupDeliveryPlanItem>> supCompany = purValues.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getSupCompanySapCode));
            supCompany.forEach((supCompanySapCode, supValues) -> {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("purCompanyName", ((SupDeliveryPlanItem)supValues.get(0)).getPurCompanyName());
                StringBuffer updateMsg = new StringBuffer();
                StringBuffer deleteMsg = new StringBuffer();
                Map<Integer, List<SupDeliveryPlanItem>> isEnableMap = supValues.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getIsEnable));
                isEnableMap.forEach((isEnable, isEnbaleValues) -> {
                    if (isEnable.equals(Constant.NO_INT)) {
                        deleteMsg.append("\u5220\u9664\u4e86");
                        this.getMsg(deleteMsg, (List<SupDeliveryPlanItem>)isEnbaleValues);
                    } else {
                        updateMsg.append("\u66f4\u65b0\u4e86");
                        this.getMsg(updateMsg, (List<SupDeliveryPlanItem>)isEnbaleValues);
                    }
                });
                if (StringUtils.isNotBlank((String)updateMsg.toString())) {
                    updateMsg.append("\uff1b");
                }
                data.put("msg", updateMsg.append(deleteMsg).toString());
                this.sendMsg((Map<String, String>)data, ((SupDeliveryPlanItem)supValues.get(0)).getPurCompanySrmCode(), (String)supCompanySapCode);
            });
        });
    }

    private void getMsg(StringBuffer msg, List<SupDeliveryPlanItem> isEnbaleValues) {
        msg.append(isEnbaleValues.size());
        msg.append("\u6761JIT\u9001\u8d27\u901a\u77e5\u5355\uff08\u9001\u8d27\u65e5\u671f/\u7269\u6599\u7f16\u53f7/\u6570\u91cf\uff09\uff1a");
        List list = isEnbaleValues.stream().map(item -> DateFormatUtils.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd hh:mm") + "/" + item.getMaterialNo() + "/" + item.getDeliveryQuantity()).collect(Collectors.toList());
        msg.append(list.toString());
    }

    private void sendMsg(Map<String, String> data, String purCompanySrmCode, String supCompanySapCode) {
        User loginUser = this.getPurUser();
        Message msg = Message.init(data).setCompanyCode(purCompanySrmCode).setBusinessTypeCode(PlanItemImTypeEnum.PLAN_ITEM_MSG.getValue()).setSenderId(loginUser == null ? "20180705030515-30df16cdc1154995b" : loginUser.getId()).setMsgLevel(MessageLevelEnum.HIGH).addReceiverIdList(this.getSupCompanyRef(supCompanySapCode));
        MessageSendUtils.sendMessage((Message)msg);
    }

    private List<String> getSupCompanyRef(String supSapCode) {
        return ContextUtils.getCompanyUserRefService().queryUserOfcompanySapCode(supSapCode);
    }
}

