/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.jit.plan;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.Material;
import com.els.base.plan.command.jit.CompositeDataCommand;
import com.els.base.plan.command.jit.plan.ImportJitPlanCommand;
import com.els.base.plan.entity.DeliveryPlan;
import com.els.base.plan.entity.DeliveryPlanExample;
import com.els.base.plan.entity.JITDemandMergeExample;
import com.els.base.plan.entity.JITLeadTime;
import com.els.base.plan.entity.JITLeadTimeExample;
import com.els.base.plan.entity.JITMaterialDemand;
import com.els.base.plan.entity.JITSupRef;
import com.els.base.plan.entity.JitPlanDataSources;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.JitPlanUtils;
import com.els.liby.organization.entity.Organization;
import com.els.liby.organization.entity.OrganizationExample;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateJitPlanByApsCmd
extends AbstractCommand<List<JITMaterialDemand>> {
    private static final Logger logger = LoggerFactory.getLogger(CreateJitPlanByApsCmd.class);
    private static final BigDecimal TEMP = new BigDecimal("3600000");
    private static final String LOCK = "F";
    List<JITMaterialDemand> demands = this.getMaterialDemand();

    @Override
    public List<JITMaterialDemand> execute(ICommandInvoker context) {
        this.valid(this.demands);
        this.initDemandTime(this.demands);
        this.initArryvalTime(this.demands);
        Lists.partition(this.demands, (int)100).forEach(demandList -> ContextUtils.getJitMaterialDemandService().addAll((List)demandList));
        List<DeliveryPlan> deliveryPlanLists = JitPlanUtils.mergeDemands(this.demands);
        deliveryPlanLists = deliveryPlanLists.stream().filter(deliveryPlan -> !this.isLockPlan((DeliveryPlan)deliveryPlan)).collect(Collectors.toList());
        deliveryPlanLists = this.DistributeSup(deliveryPlanLists, context);
        List excitedDistributeSupPlans = deliveryPlanLists.stream().filter(plan -> CollectionUtils.isNotEmpty(plan.getPlanItemList())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(excitedDistributeSupPlans)) {
            List supDeliveryPlanItems = excitedDistributeSupPlans.stream().map(DeliveryPlan::getPlanItemList).reduce(new ArrayList(), (all, item) -> {
                all.addAll(item);
                return all;
            });
            ImportJitPlanCommand command = new ImportJitPlanCommand(supDeliveryPlanItems, true);
            context.invoke(command);
        }
        deliveryPlanLists.removeAll(excitedDistributeSupPlans);
        if (CollectionUtils.isNotEmpty(deliveryPlanLists)) {
            this.doNotExcitedDistributeSupPlans(deliveryPlanLists);
        }
        return this.demands;
    }

    private List<DeliveryPlan> DistributeSup(List<DeliveryPlan> deliveryPlanLists, ICommandInvoker context) {
        ArrayList<DeliveryPlan> plans = new ArrayList<DeliveryPlan>();
        ArrayListMultimap<String, DeliveryPlan> maps = this.groubyFactoryAndMaterial(deliveryPlanLists);
        for (String key : maps.keySet()) {
            List planItems = maps.get((Object)key);
            planItems.sort(Comparator.comparing(DeliveryPlan::getArryvalTime));
            this.Distribute(planItems, context);
            plans.addAll(planItems);
        }
        return plans;
    }

    private ArrayListMultimap<String, DeliveryPlan> groubyFactoryAndMaterial(List<DeliveryPlan> deliveryPlanLists) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        for (DeliveryPlan plan : deliveryPlanLists) {
            String key = plan.getFactoryCode() + "," + plan.getMaterialCode();
            arrayListMultiMap.put((Object)key, (Object)plan);
        }
        return arrayListMultiMap;
    }

    private void valid(List<JITMaterialDemand> demands) {
        demands.stream().forEach(jitMaterialDemand -> {
            Assert.isNotBlank((String)jitMaterialDemand.getFactoryCode(), (String)"\u5de5\u5382\u4ee3\u7801\u4e3a\u7a7a");
            Assert.isNotBlank((String)jitMaterialDemand.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            Assert.isNotBlank((String)jitMaterialDemand.getConsumeMunber().toString(), (String)"\u6d88\u8017\u6570\u91cf\u4e3a\u7a7a");
            Assert.isNotBlank((String)jitMaterialDemand.getConsumeTime().toString(), (String)"\u6d88\u8017\u95f4\u4e3a\u7a7a");
            jitMaterialDemand.setCreateTime(new Date());
        });
    }

    private void initDemandTime(List<JITMaterialDemand> demands) {
        for (JITMaterialDemand j : demands) {
            BigDecimal leadTime = this.currentLeadTime(j.getMaterialCode(), j.getFactoryCode());
            if (leadTime == null) {
                j.setDemandTime(j.getConsumeTime());
                continue;
            }
            j.setDemandTime(new Date(j.getConsumeTime().getTime() - (long)leadTime.multiply(TEMP).intValue()));
        }
    }

    public void initArryvalTime(List<JITMaterialDemand> demands) {
        ArrayListMultimap arrayListMultiMap = ArrayListMultimap.create();
        demands.stream().forEach(jitMaterialDemand -> {
            String key = jitMaterialDemand.getFactoryCode();
            arrayListMultiMap.put((Object)key, jitMaterialDemand);
        });
        Set keySet = arrayListMultiMap.keySet();
        keySet.stream().forEach(key -> {
            List demandGroup = arrayListMultiMap.get(key);
            JITDemandMergeExample example = new JITDemandMergeExample();
            example.setOrderByClause(" TO_CHAR(START_TIME, 'hh24:mi:ss') ASC");
            example.createCriteria().andFactoryCodeEqualTo((String)key);
            List mergeList = ContextUtils.getJitDemandMergeService().queryAllObjByExample((IExample)example);
            demandGroup.stream().forEach(j -> JitPlanUtils.initArryValTimeAndLockByMerge(mergeList, j));
        });
    }

    private boolean isLockPlan(DeliveryPlan plan) {
        DeliveryPlanExample example = new DeliveryPlanExample();
        example.createCriteria().andMaterialCodeEqualTo(plan.getMaterialCode()).andFactoryCodeEqualTo(plan.getFactoryCode()).andArryvalTimeEqualTo(plan.getArryvalTime()).andIsEnableEqualTo(Constant.YES_INT).andIsLockEqualTo(LOCK);
        List planList = ContextUtils.getDeliveryPlanService().queryAllObjByExample((IExample)example);
        return CollectionUtils.isNotEmpty((Collection)planList);
    }

    private List<JITMaterialDemand> getMaterialDemand() {
        ArrayList<JITMaterialDemand> demandList = new ArrayList();
        List<Map<String, Object>> lists = ContextUtils.getJitMaterialDemandService().getApsMaterial();
        List<JitPlanDataSources> openList = ContextUtils.getJitPlanDataSourcesService().getOpenList();
        Assert.isNotEmpty(lists, (String)"\u83b7\u53d6APS\u7269\u6599\u9700\u6c42\u6570\u636e\uff1a\u65e0\u6570\u636e");
        logger.info("EVENT=\u83b7\u53d6APS\u7269\u6599\u9700\u6c42\u6570\u636e|DATA=%1$s", (Object)new Gson().toJson(lists));
        Assert.isNotEmpty(openList, (String)"\u65e0\u5f00\u542fASPROVE\u6570\u636e\u6e90\u7684\u6570\u636e");
        demandList = this.getEntityDemand(lists);
        if (CollectionUtils.isNotEmpty(openList)) {
            demandList = demandList.stream().filter(demand -> openList.stream().anyMatch(open -> open.getFactory().equals(demand.getFactoryCode()) && open.getMaterialCode().equals(demand.getMaterialCode()))).collect(Collectors.toList());
            Assert.isNotEmpty(demandList, (String)"\u65e0\u5bf9\u5e94\u5f00\u542fASPROVE\u6570\u636e\u6e90\u7684\u6570\u636e");
        }
        demandList = this.init(demandList);
        Assert.isNotEmpty(demandList, (String)"\u65e0JIT\u7269\u6599");
        logger.info("ASPROVE\u6570\u636e\u8f6c\u5316\u521d\u59cb\u5316\u5b8c\u6210");
        return demandList;
    }

    private List<JITMaterialDemand> init(List<JITMaterialDemand> objectList) {
        Map<String, List<JITMaterialDemand>> groupbyMaterial = objectList.stream().collect(Collectors.groupingBy(JITMaterialDemand::getMaterialCode));
        Optional<List> demandList = groupbyMaterial.entrySet().parallelStream().map(map -> {
            String materialCode = (String)map.getKey();
            Material material = ContextUtils.getMaterialService().queryObjByCode(materialCode);
            if (material != null) {
                ((List)map.getValue()).parallelStream().forEach(value -> {
                    value.setMaterialDescribe(material.getDescription());
                    value.setUnit(material.getBasicUnit());
                    value.setPurOrderNumberRouding(material.getPurOrderNumberRouding());
                    value.setMaterialGroup(material.getMaterialGroup());
                    value.setExternalMaterialGroup(material.getExternalMaterialGroup());
                });
                return this.groubyFactory((List)map.getValue(), materialCode);
            }
            return null;
        }).filter(demand -> demand != null).reduce((x, y) -> {
            x.addAll(y);
            return x;
        });
        if (demandList != null && demandList.isPresent()) {
            return demandList.get();
        }
        return null;
    }

    private List<JITMaterialDemand> groubyFactory(List<JITMaterialDemand> list, String materialCode) {
        Map<String, List<JITMaterialDemand>> groupbyFactory = list.stream().collect(Collectors.groupingBy(JITMaterialDemand::getFactoryCode));
        Optional<List> demandList = groupbyFactory.entrySet().parallelStream().map(map -> {
            String factoryName = this.getFactoryName((String)map.getKey());
            if (factoryName != null) {
                String jitItem = ContextUtils.getMaterialService().getMaterialJitItem(materialCode, (String)map.getKey());
                if (StringUtils.isNotBlank((String)jitItem) && "1".equals(jitItem)) {
                    ((List)map.getValue()).stream().forEach(value -> value.setFactoryName(factoryName));
                    return (List)map.getValue();
                }
                return null;
            }
            return null;
        }).filter(demand -> demand != null).reduce((x, y) -> {
            x.addAll(y);
            return x;
        });
        if (demandList != null && demandList.isPresent()) {
            return demandList.get();
        }
        return null;
    }

    private List<JITMaterialDemand> getEntityDemand(List<Map<String, Object>> lists) {
        List<JITMaterialDemand> demands = lists.parallelStream().map(map -> {
            JITMaterialDemand demand = new JITMaterialDemand();
            demand.setMaterialCode(map.get("ITEMCODE") + "");
            demand.setFactoryCode(map.get("FACTORY") + "");
            demand.setConsumeMunber((BigDecimal)map.get("QTY"));
            demand.setConsumeTime((Date)map.get("INVLET"));
            demand.setWayType((BigDecimal)map.get("INVTYPE"));
            return demand;
        }).collect(Collectors.toList());
        return demands;
    }

    private String getFactoryName(String factoryCode) {
        OrganizationExample example = new OrganizationExample();
        example.createCriteria().andCodeEqualTo(factoryCode).andOrganizationTypeEqualTo("T001W");
        List organizationList = ContextUtils.getOrganizationService().queryAllObjByExample((IExample)example);
        if (organizationList.size() > 0) {
            return ((Organization)organizationList.get(0)).getDescription();
        }
        return null;
    }

    private BigDecimal currentLeadTime(String materialCode, String factoryCode) {
        JITLeadTimeExample example = new JITLeadTimeExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode).andFactoryCodeEqualTo(factoryCode);
        List lists = ContextUtils.getJitLeadTimeService().queryAllObjByExample((IExample)example);
        if (lists.size() == 0) {
            example.clear();
            example.createCriteria().andFactoryCodeEqualTo(factoryCode).andMaterialCodeIsNull();
            List factoryLists = ContextUtils.getJitLeadTimeService().queryAllObjByExample((IExample)example);
            if (factoryLists.size() == 0) {
                return null;
            }
            return ((JITLeadTime)factoryLists.get(0)).getTotalTime();
        }
        return ((JITLeadTime)lists.get(0)).getTotalTime();
    }

    private void Distribute(List<DeliveryPlan> plans, ICommandInvoker context) {
        CompositeDataCommand command = new CompositeDataCommand(plans.get(0).getMaterialCode(), plans.get(0).getFactoryCode(), null);
        List<JITSupRef> dataList = context.invoke(command);
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        List<JITSupRef> jitSupRefList = dataList.stream().filter(jitSupRef -> jitSupRef.getCumulativeUndistributeMun() != null && jitSupRef.getCumulativeUndistributeMun().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        for (DeliveryPlan plan : plans) {
            if (jitSupRefList.size() == 1) {
                this.DistributeSupByOne(plan, (JITSupRef)jitSupRefList.get(0));
                continue;
            }
            if ((jitSupRefList = jitSupRefList.stream().filter(jitSupRef -> jitSupRef.getQuota() != null).collect(Collectors.toList())).size() <= 0) continue;
            this.DistributeGreaterSupByMore(jitSupRefList, plan);
        }
    }

    private void doNotExcitedDistributeSupPlans(List<DeliveryPlan> deliveryPlanLists) {
        deliveryPlanLists.stream().forEach(plan -> {
            DeliveryPlanExample example = new DeliveryPlanExample();
            example.createCriteria().andMaterialCodeEqualTo(plan.getMaterialCode()).andFactoryCodeEqualTo(plan.getFactoryCode()).andArryvalTimeEqualTo(plan.getArryvalTime()).andIsEnableEqualTo(Constant.YES_INT);
            List planList = ContextUtils.getDeliveryPlanService().queryAllObjByExample((IExample)example);
            if (CollectionUtils.isNotEmpty((Collection)planList) && plan.getConsumeMunber().compareTo(((DeliveryPlan)planList.get(0)).getConsumeMunber()) > 0) {
                this.modifyPlanById(plan.getId(), plan.getConsumeMunber());
            } else {
                ContextUtils.getDeliveryPlanService().addObj((Serializable)plan);
            }
        });
    }

    private void modifyPlanById(String id, BigDecimal consumeMunber) {
        DeliveryPlan deliveryPlan = new DeliveryPlan();
        deliveryPlan.setIsAllocated(Constant.NO_INT);
        deliveryPlan.setId(id);
        deliveryPlan.setConsumeMunber(consumeMunber);
        ContextUtils.getDeliveryPlanService().modifyObj(deliveryPlan);
        ContextUtils.getSupDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), consumeMunber);
        ContextUtils.getPurDeliveryPlanItemService().updateConsumeMunber(deliveryPlan.getId(), consumeMunber);
    }

    private void DistributeSupByOne(DeliveryPlan plan, JITSupRef jitSupRef) {
        BigDecimal undistributeMun;
        BigDecimal bigDecimal = undistributeMun = jitSupRef.getCumulativeUndistributeMun() == null ? BigDecimal.ZERO : jitSupRef.getCumulativeUndistributeMun();
        if (undistributeMun.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        SupDeliveryPlanItem item = JitPlanUtils.initSupDeliveryPlanItem(plan, jitSupRef);
        if (plan.getConsumeMunber().compareTo(undistributeMun) > 0) {
            item.setDeliveryQuantity(jitSupRef.getCumulativeUndistributeMun());
            jitSupRef.setCumulativeUndistributeMun(BigDecimal.ZERO);
        } else {
            item.setDeliveryQuantity(plan.getConsumeMunber());
            jitSupRef.setCumulativeUndistributeMun(undistributeMun.subtract(plan.getConsumeMunber()));
        }
        ArrayList<SupDeliveryPlanItem> lists = new ArrayList<SupDeliveryPlanItem>();
        lists.add(item);
        plan.setStatus(Constant.YES_INT);
        plan.setDeliveryDate(new Date());
        plan.setPlanItemList(lists);
    }

    private void DistributeGreaterSupByMore(List<JITSupRef> jitSupRefList, DeliveryPlan plan) {
        BigDecimal consumeMunber = plan.getConsumeMunber();
        ArrayList<SupDeliveryPlanItem> lists = new ArrayList<SupDeliveryPlanItem>();
        for (JITSupRef jitSupRef : jitSupRefList) {
            SupDeliveryPlanItem item;
            BigDecimal undistributeMun = jitSupRef.getCumulativeUndistributeMun() == null ? BigDecimal.ZERO : jitSupRef.getCumulativeUndistributeMun();
            if (undistributeMun.compareTo(BigDecimal.ZERO) == 0) continue;
            if (this.isLessThanDistribution(plan, consumeMunber)) {
                item = this.DistributeLessSupByMore(consumeMunber, undistributeMun, jitSupRef, plan);
                if (item == null) continue;
                lists.add(item);
                continue;
            }
            item = JitPlanUtils.initSupDeliveryPlanItem(plan, jitSupRef);
            BigDecimal quota = new BigDecimal(item.getQuota());
            BigDecimal quantity = consumeMunber.multiply(quota).divide(BigDecimal.valueOf(100L), 0, 0);
            BigDecimal deliveryQuantity = this.getDeliveryQuantity(quantity, plan.getPurOrderNumberRouding());
            if (BigDecimal.ZERO.equals(quota) || BigDecimal.ZERO.equals(deliveryQuantity)) continue;
            if (deliveryQuantity.compareTo(undistributeMun) < 0) {
                item.setDeliveryQuantity(deliveryQuantity);
                jitSupRef.setCumulativeUndistributeMun(jitSupRef.getCumulativeUndistributeMun().subtract(plan.getConsumeMunber()));
            } else {
                item.setDeliveryQuantity(jitSupRef.getCumulativeUndistributeMun());
                jitSupRef.setCumulativeUndistributeMun(BigDecimal.ZERO);
            }
            lists.add(item);
        }
        plan.setStatus(Constant.NO_INT);
        plan.setPlanItemList(lists);
    }

    private boolean isLessThanDistribution(DeliveryPlan plan, BigDecimal consumeMunber) {
        return false;
    }

    private SupDeliveryPlanItem DistributeLessSupByMore(BigDecimal consumeMunber, BigDecimal undistributeMun, JITSupRef jitSupRef, DeliveryPlan plan) {
        if ((consumeMunber = this.getDeliveryQuantity(consumeMunber, plan.getPurOrderNumberRouding())).compareTo(undistributeMun) < 0) {
            SupDeliveryPlanItem item = JitPlanUtils.initSupDeliveryPlanItem(plan, jitSupRef);
            item.setDeliveryQuantity(consumeMunber);
            jitSupRef.setCumulativeUndistributeMun(jitSupRef.getCumulativeUndistributeMun().subtract(plan.getConsumeMunber()));
            return item;
        }
        return null;
    }

    private BigDecimal getDeliveryQuantity(BigDecimal quantity, String rouding) {
        BigDecimal num;
        BigDecimal numberRouding;
        if (StringUtils.isNotBlank((String)rouding) && (numberRouding = new BigDecimal(rouding)).compareTo(BigDecimal.ZERO) > 0 && (num = quantity.divideAndRemainder(numberRouding)[1]).compareTo(BigDecimal.ZERO) > 0) {
            quantity = numberRouding.multiply(quantity.divide(numberRouding, 0, 0).add(BigDecimal.ONE));
        }
        return quantity;
    }
}

