/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.PurchaseOrder;

public class NoneJitPlanInOrderSendToSupCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private PurchaseOrder purchaseOrder;

    public NoneJitPlanInOrderSendToSupCmd(PurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.purchaseOrder);
        PurDeliveryPlanItem item = new PurDeliveryPlanItem();
        item.setSendStatus("Y");
        item.setChangeStatus(PlanChangeStatusEnum.PUR_CHANGE.getValue());
        item.setPurOrderStatus(this.purchaseOrder.getOrderStatus());
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        example.createCriteria().andPurOrderIdEqualTo(this.purchaseOrder.getId());
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(item, example);
        ContextUtils.getSupDeliveryPlanItemService().deleteByOrderId(this.purchaseOrder.getId());
        ContextUtils.getSupDeliveryPlanItemService().addByPurDeliveryPlanItem(this.purchaseOrder.getId());
        return null;
    }

    private void valid(PurchaseOrder purchaseOrder) {
        Assert.isNotNull((Object)purchaseOrder, (String)"\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)purchaseOrder.getId(), (String)"\u91c7\u8d2d\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

