/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class NoneJitPlanPurRefuseCmd
extends AbstractCommand<List<PurDeliveryPlanItem>> {
    private static final long serialVersionUID = 1L;
    private List<PurDeliveryPlanItem> planList;

    public NoneJitPlanPurRefuseCmd(List<PurDeliveryPlanItem> planList) {
        this.planList = planList;
    }

    @Override
    public List<PurDeliveryPlanItem> execute(ICommandInvoker context) {
        this.valid(this.planList);
        List<PurDeliveryPlanItem> noneJitPlanLis = this.planList.stream().filter(plan -> !Constant.YES_INT.equals(plan.getIsJit())).collect(Collectors.toList());
        return this.refuseNoneJitPlanList(noneJitPlanLis);
    }

    private void valid(List<PurDeliveryPlanItem> planList) {
        Assert.isNotEmpty(planList, (String)"\u4ea4\u8d27\u8ba1\u5212\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (PurDeliveryPlanItem plan : planList) {
            Assert.isNotBlank((String)plan.getPurOrderNo(), (String)"\u8ba2\u5355\u5934\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemNo(), (String)"\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemId(), (String)"\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
            if (PlanChangeStatusEnum.PUR_CHANGE.getValue().equals(plan.getChangeStatus())) continue;
            throw new CommonException(String.format("\u4ea4\u8d27\u8ba1\u5212 [%s][%s] \u786e\u8ba4\u7684\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38", plan.getPurOrderNo(), plan.getPurOrderItemNo()));
        }
        Map<String, List<PurDeliveryPlanItem>> group = planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderNo));
        PurDeliveryPlanItemExample example = new PurDeliveryPlanItemExample();
        group.keySet().forEach(orderNo -> {
            List itemNoList = ((List)group.get(orderNo)).stream().map(PurDeliveryPlanItem::getPurOrderItemNo).collect(Collectors.toList());
            example.or().andPurOrderNoEqualTo((String)orderNo).andPurOrderItemNoIn(itemNoList).andIsJitEqualTo(Constant.YES_INT);
        });
        List tmpPlanList = ContextUtils.getPurDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)tmpPlanList)) {
            throw new CommonException(String.format("\u65e0\u6cd5\u53d8\u66f4JIT\u7269\u6599\u7684\u9001\u8d27\u901a\u77e5\u5355,[%s][%s]", ((PurDeliveryPlanItem)tmpPlanList.get(0)).getPurOrderNo(), ((PurDeliveryPlanItem)tmpPlanList.get(0)).getPurOrderItemNo()));
        }
    }

    private List<PurDeliveryPlanItem> refuseNoneJitPlanList(List<PurDeliveryPlanItem> planList) {
        Map<String, List<PurDeliveryPlanItem>> orderNoAndPlanList = planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderNo));
        Set<String> orderNoSet = orderNoAndPlanList.keySet();
        for (String orderNo : orderNoSet) {
            this.refuseNoneJitPlanList(orderNo, orderNoAndPlanList.get(orderNo));
        }
        return planList;
    }

    private List<PurDeliveryPlanItem> refuseNoneJitPlanList(String orderNo, List<PurDeliveryPlanItem> planList) {
        Map<String, List<PurDeliveryPlanItem>> orderItemNoAndPlanList = planList.stream().collect(Collectors.groupingBy(PurDeliveryPlanItem::getPurOrderItemNo));
        Set<String> orderItemNoSet = orderItemNoAndPlanList.keySet();
        for (String orderItemNo : orderItemNoSet) {
            List<PurDeliveryPlanItem> noneJitPlanLis = orderItemNoAndPlanList.get(orderItemNo);
            PurchaseOrderItem orderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(noneJitPlanLis.get(0).getPurOrderItemId());
            this.refuseForOrderItem(orderItem, noneJitPlanLis);
        }
        return planList;
    }

    private List<PurDeliveryPlanItem> refuseForOrderItem(PurchaseOrderItem orderItem, List<PurDeliveryPlanItem> planItemList) {
        SupDeliveryPlanItemExample supPlanEx = new SupDeliveryPlanItemExample();
        supPlanEx.createCriteria().andPurOrderItemIdEqualTo(orderItem.getId()).andIsCanDeliveryEqualTo(Constant.YES_INT);
        List supPlanList = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)supPlanEx);
        if (DeliveryPlanUtils.isEqualBewteenPurAndSup(planItemList, supPlanList)) {
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355[%s][%s]\u7684\u53d8\u66f4\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u5e76\u6ca1\u6709\u53d8\u5316", orderItem.getOrderNo(), orderItem.getOrderItemNo()));
        }
        for (PurDeliveryPlanItem newItem : planItemList) {
            newItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            newItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            newItem.setChangeStatus(PlanChangeStatusEnum.PUR_CHANGE.getValue());
            newItem.setConfirmTime(null);
            newItem.setPurOrderItemId(orderItem.getId());
            newItem.setPurPlanerId(orderItem.getPurPlanerId());
            newItem.setPurUserId(this.getPurUser().getId());
            newItem.setPurUserName(this.getPurUser().getNickName());
        }
        return planItemList;
    }

    private PurchaseOrderItem getOrderItem(String orderNo, String orderItemNo) {
        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        PurchaseOrderItemExample.Criteria cri = example.createCriteria().andOrderNoEqualTo(orderNo).andOrderItemNoEqualTo(orderItemNo);
        if (this.getPurCompany() != null) {
            cri.andProjectIdEqualTo(this.getPurCompany().getProjectId());
        }
        List itemList = ContextUtils.getPurchaseOrderItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)itemList, (String)String.format("\u8ba2\u5355\u884c\u9879\u76ee\u4e0d\u5b58\u5728[%s][%s]", orderNo, orderItemNo));
        return (PurchaseOrderItem)itemList.get(0);
    }

    private boolean isHaveToEmptyConfirmDeliveryDate(List<SupDeliveryPlanItem> supPlanList, PurDeliveryPlanItem purPlanItem) {
        if (purPlanItem == null) {
            return true;
        }
        SupDeliveryPlanItem planItem = supPlanList.stream().filter(supPlanItem -> supPlanItem.getId().equals(purPlanItem.getId())).findAny().orElse(null);
        if (planItem == null) {
            return true;
        }
        return PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(planItem.getPurConfirmStatus()) && PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(planItem.getSupConfirmStatus());
    }
}

