/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.command.nonejit.sup.ImportSupForUnConfirmOrderCmd;
import com.els.base.plan.command.nonejit.sup.ImportSupPlanForConfirmedOrderCmd;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.purchase.entity.SupplierOrder;
import com.els.base.purchase.entity.SupplierOrderExample;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ImportSupToDoPlanItemCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<SupDeliveryPlanItem> supDeliveryPlanItemList;

    public ImportSupToDoPlanItemCmd(List<SupDeliveryPlanItem> planItems) {
        this.supDeliveryPlanItemList = planItems;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.supDeliveryPlanItemList);
        Map<String, List<SupDeliveryPlanItem>> orderNoAndPlanList = this.supDeliveryPlanItemList.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderNo));
        Set<String> orderNoList = orderNoAndPlanList.keySet();
        orderNoList.forEach(orderNo -> this.importPlanItemForOrder((String)orderNo, (List)orderNoAndPlanList.get(orderNo)));
        return null;
    }

    private void importPlanItemForOrder(String orderNo, List<SupDeliveryPlanItem> list) {
        AbstractCommand cmd;
        SupplierOrder order = this.queryByOrdreNo(orderNo);
        if (PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue().equals(order.getOrderStatus()) || PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue().equals(order.getOrderStatus())) {
            throw new CommonException(String.format("\u8ba2\u5355[%s]\u5df2\u7ecf\u56de\u7b7e\u7ed9\u91c7\u8d2d\u65b9\uff0c\u8bf7\u5728\u91c7\u8d2d\u65b9\u56de\u590d\u540e\u518d\u53d8\u66f4", orderNo));
        }
        if (PurchaseOrderConfirmStatusEnum.CONFIRM.getValue().equals(order.getOrderStatus())) {
            cmd = new ImportSupPlanForConfirmedOrderCmd(order, list);
            cmd.copyProperties(this);
            this.context.invoke(cmd);
        }
        if (PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue().equals(order.getOrderStatus())) {
            cmd = new ImportSupForUnConfirmOrderCmd(order, list);
            cmd.copyProperties(this);
            this.context.invoke(cmd);
        }
    }

    private SupplierOrder queryByOrdreNo(String orderNo) {
        SupplierOrderExample example = new SupplierOrderExample();
        example.createCriteria().andOrderNoEqualTo(orderNo);
        List orderList = ContextUtils.getSupplierOrderService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)orderList, (String)String.format("\u8ba2\u5355[%s]\u4e0d\u5b58\u5728", orderNo));
        return (SupplierOrder)orderList.get(0);
    }

    private void valid(List<SupDeliveryPlanItem> planItems) {
        Assert.isNotEmpty(planItems, (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        for (SupDeliveryPlanItem planItem : planItems) {
            Assert.isNotBlank((String)planItem.getPurOrderNo(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)planItem.getPurOrderItemNo(), (String)"\u8ba2\u5355\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)planItem.getDeliveryDate(), (String)"\u5b9e\u9645\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)planItem.getDeliveryQuantity(), (String)"\u9001\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            if (BigDecimal.ZERO.compareTo(planItem.getDeliveryQuantity()) > 0) {
                throw new CommonException(String.format("\u8ba2\u5355[%s][%s] \u9001\u8d27\u6570\u91cf\u5c0f\u4e8e0", planItem.getPurOrderNo(), planItem.getPurOrderItemNo()));
            }
            planItem.setPurOrderItemNo(StringUtils.leftPad((String)planItem.getPurOrderItemNo(), (int)5, (String)"0"));
        }
    }
}

