/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.ChangeReasonEnum;
import com.els.base.plan.utils.OperateTypeEnum;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class NoneJitPlanSupConfirmCmd
extends AbstractCommand<List<SupDeliveryPlanItem>> {
    private static final long serialVersionUID = 1L;
    private OperateTypeEnum operateType;
    private String orderItemId;
    private List<SupDeliveryPlanItem> planList;

    public NoneJitPlanSupConfirmCmd(List<SupDeliveryPlanItem> planList) {
        this.planList = planList;
        this.operateType = OperateTypeEnum.OPERATE_FROM_PLAN_LIST;
    }

    @Override
    public List<SupDeliveryPlanItem> execute(ICommandInvoker context) {
        switch (this.operateType) {
            case OPERATE_FROM_ORDER: {
                return this.confirmForOrderItem(this.orderItemId);
            }
            case OPERATE_FROM_PLAN_LIST: {
                return this.confirmForPlanList(this.planList);
            }
        }
        throw new CommonException("\u4e0d\u652f\u6301\u8be5\u4ea4\u8d27\u8ba1\u5212\u7684\u786e\u8ba4\u64cd\u4f5c");
    }

    private List<SupDeliveryPlanItem> confirmForPlanList(List<SupDeliveryPlanItem> planItemList) {
        Assert.isNotEmpty(planItemList, (String)"\u4ea4\u8d27\u8ba1\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (SupDeliveryPlanItem plan : planItemList) {
            Assert.isNotBlank((String)plan.getId(), (String)"\u4ea4\u8d27\u8ba1\u5212Id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderId(), (String)"\u8ba2\u5355\u5934\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getPurOrderItemId(), (String)"\u8ba2\u5355\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)plan.getChangeReason(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8d23\u4efb\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
            if (PlanChangeStatusEnum.SUP_CONFIRM.getValue().equals(plan.getChangeStatus())) continue;
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u786e\u8ba4\u7684\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38", plan.getPurOrderNo(), plan.getPurOrderItemNo()));
        }
        List noneJitIdList = planItemList.stream().map(SupDeliveryPlanItem::getId).collect(Collectors.toList());
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        List<Integer> refuseStatus = Arrays.asList(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue(), PurchaseOrderConfirmStatusEnum.PART_REFUSE.getValue());
        example.createCriteria().andPurOrderStatusIn((List)refuseStatus).andIdIn(noneJitIdList);
        List unConfirmPlan = ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)unConfirmPlan)) {
            String errMsg = String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s]\u5df2\u53d1\u9001\uff0c\u65e0\u6cd5\u91cd\u590d\u53d1\u9001", ((SupDeliveryPlanItem)unConfirmPlan.get(0)).getPurOrderNo(), ((SupDeliveryPlanItem)unConfirmPlan.get(0)).getPurOrderItemNo());
            throw new CommonException(errMsg);
        }
        Date now = new Date();
        for (SupDeliveryPlanItem tmpSupPlan : planItemList) {
            tmpSupPlan.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            tmpSupPlan.setSupUserName(this.getSupUser().getId());
            tmpSupPlan.setSupUserName(this.getSupUser().getNickName());
            tmpSupPlan.setConfirmTime(now);
            if (!ChangeReasonEnum.PUR.getValue().equals(tmpSupPlan.getChangeReason())) continue;
            tmpSupPlan.setConfirmDeliveryDate(tmpSupPlan.getDeliveryDate());
        }
        return planItemList;
    }

    private List<SupDeliveryPlanItem> confirmForOrderItem(String orderItemId) {
        Assert.isNotBlank((String)orderItemId, (String)"\u91c7\u8d2d\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        SupDeliveryPlanItemExample supPlanItemEx = new SupDeliveryPlanItemExample();
        supPlanItemEx.createCriteria().andPurOrderItemIdEqualTo(orderItemId);
        Date now = new Date();
        SupDeliveryPlanItem supPlanItem = new SupDeliveryPlanItem();
        supPlanItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        supPlanItem.setSupUserId(this.getSupUser().getId());
        supPlanItem.setSupUserName(this.getSupUser().getNickName());
        supPlanItem.setConfirmTime(now);
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(supPlanItem, supPlanItemEx);
        PurDeliveryPlanItemExample purPlanItemEx = new PurDeliveryPlanItemExample();
        purPlanItemEx.createCriteria().andPurOrderItemIdEqualTo(orderItemId);
        PurDeliveryPlanItem purPlanItem = new PurDeliveryPlanItem();
        purPlanItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        purPlanItem.setSupUserId(this.getSupUser().getId());
        purPlanItem.setSupUserName(this.getSupUser().getNickName());
        purPlanItem.setConfirmTime(now);
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(purPlanItem, purPlanItemEx);
        return null;
    }
}

