/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.plan.dao.DeliveryPlanItemLogMapper;
import com.els.base.plan.entity.DeliveryPlanItemLog;
import com.els.base.plan.entity.DeliveryPlanItemLogExample;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.service.DeliveryPlanItemLogService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeliveryPlanItemLogService")
public class DeliveryPlanItemLogServiceImpl
implements DeliveryPlanItemLogService {
    @Resource
    protected DeliveryPlanItemLogMapper deliveryPlanItemLogMapper;

    @CacheEvict(value={"deliveryPlanItemLog"}, allEntries=true)
    public void addObj(DeliveryPlanItemLog t) {
        this.deliveryPlanItemLogMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"deliveryPlanItemLog"}, allEntries=true)
    public void addAll(List<DeliveryPlanItemLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.deliveryPlanItemLogMapper.insertBatch(list);
    }

    @CacheEvict(value={"deliveryPlanItemLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryPlanItemLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryPlanItemLog"}, allEntries=true)
    public void deleteByExample(DeliveryPlanItemLogExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.deliveryPlanItemLogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"deliveryPlanItemLog"}, allEntries=true)
    public void modifyObj(DeliveryPlanItemLog t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.deliveryPlanItemLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryPlanItemLog"}, keyGenerator="redisKeyGenerator")
    public DeliveryPlanItemLog queryObjById(String id) {
        return this.deliveryPlanItemLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"deliveryPlanItemLog"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryPlanItemLog> queryAllObjByExample(DeliveryPlanItemLogExample example) {
        return this.deliveryPlanItemLogMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryPlanItemLog"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryPlanItemLog> queryObjByPage(DeliveryPlanItemLogExample example) {
        PageView<DeliveryPlanItemLog> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPlanItemLogMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void createPlanItem(PurDeliveryPlanItem planItem) {
    }

    @Override
    public void changePlanItem(PurDeliveryPlanItem origin, PurDeliveryPlanItem target, String changeReson) {
    }
}

