/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.dao.JitPlanDataSourcesMapper;
import com.els.base.plan.entity.JitPlanDataSources;
import com.els.base.plan.entity.JitPlanDataSourcesExample;
import com.els.base.plan.service.JitPlanDataSourcesService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultJitPlanDataSourcesService")
public class JitPlanDataSourcesServiceImpl
implements JitPlanDataSourcesService {
    @Resource
    protected JitPlanDataSourcesMapper jitPlanDataSourcesMapper;

    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void addObj(JitPlanDataSources t) {
        this.jitPlanDataSourcesMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void addAll(List<JitPlanDataSources> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.jitPlanDataSourcesMapper.insertBatch(list);
    }

    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void deleteObjById(String id) {
        this.jitPlanDataSourcesMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void deleteByExample(JitPlanDataSourcesExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.jitPlanDataSourcesMapper.deleteByExample(example);
    }

    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void modifyObj(JitPlanDataSources t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.jitPlanDataSourcesMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"jitPlanDataSources"}, keyGenerator="redisKeyGenerator")
    public JitPlanDataSources queryObjById(String id) {
        return this.jitPlanDataSourcesMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"jitPlanDataSources"}, keyGenerator="redisKeyGenerator")
    public List<JitPlanDataSources> queryAllObjByExample(JitPlanDataSourcesExample example) {
        return this.jitPlanDataSourcesMapper.selectByExample(example);
    }

    @Cacheable(value={"jitPlanDataSources"}, keyGenerator="redisKeyGenerator")
    public PageView<JitPlanDataSources> queryObjByPage(JitPlanDataSourcesExample example) {
        PageView<JitPlanDataSources> pageView = example.getPageView();
        pageView.setQueryResult(this.jitPlanDataSourcesMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void openAspByIds(List<String> ids) {
        JitPlanDataSources sources = new JitPlanDataSources();
        sources.setIsOpenAsp(Constant.YES_INT);
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.createCriteria().andIdIn((List)ids);
        this.jitPlanDataSourcesMapper.updateByExampleSelective(sources, example);
    }

    @Override
    @CacheEvict(value={"jitPlanDataSources"}, allEntries=true)
    public void coloseAspByIds(List<String> ids) {
        JitPlanDataSources sources = new JitPlanDataSources();
        sources.setIsOpenAsp(Constant.NO_INT);
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.createCriteria().andIdIn((List)ids);
        this.jitPlanDataSourcesMapper.updateByExampleSelective(sources, example);
    }

    @Override
    @Cacheable(value={"jitPlanDataSources"}, keyGenerator="redisKeyGenerator")
    public List<JitPlanDataSources> getOpenList() {
        JitPlanDataSourcesExample example = new JitPlanDataSourcesExample();
        example.createCriteria().andIsOpenAspEqualTo(Constant.YES_INT);
        return this.jitPlanDataSourcesMapper.selectByExample(example);
    }
}

