/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.dao.SupDeliveryPlanItemMapper;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.service.SupDeliveryPlanItemService;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupDeliveryPlanItemService")
public class SupDeliveryPlanItemServiceImpl
implements SupDeliveryPlanItemService {
    @Resource
    protected SupDeliveryPlanItemMapper supDeliveryPlanItemMapper;

    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void addObj(SupDeliveryPlanItem t) {
        this.supDeliveryPlanItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void addAll(List<SupDeliveryPlanItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.supDeliveryPlanItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supDeliveryPlanItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void modifyObj(SupDeliveryPlanItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.supDeliveryPlanItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supDeliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public SupDeliveryPlanItem queryObjById(String id) {
        return this.supDeliveryPlanItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supDeliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public List<SupDeliveryPlanItem> queryAllObjByExample(SupDeliveryPlanItemExample example) {
        return this.supDeliveryPlanItemMapper.selectByExample(example);
    }

    @Cacheable(value={"supDeliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public PageView<SupDeliveryPlanItem> queryObjByPage(SupDeliveryPlanItemExample example) {
        PageView<SupDeliveryPlanItem> pageView = example.getPageView();
        pageView.setQueryResult(this.supDeliveryPlanItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void deleteByOrderId(String orderId) {
        Assert.isNotBlank((String)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderIdEqualTo(orderId);
        this.supDeliveryPlanItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void addByPurDeliveryPlanItem(String orderId) {
        Assert.isNotBlank((String)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        this.supDeliveryPlanItemMapper.insertBatchByPurDeliveryPlanItem(orderId);
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void insertHisByOrderId(String supOrderHisId, String orderId, String cause) {
        this.supDeliveryPlanItemMapper.insertHisByOrderId(supOrderHisId, orderId, cause, new Date());
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public List<SupDeliveryPlanItem> queryAllHisOrderItemByExample(SupDeliveryPlanItemExample example) {
        return this.supDeliveryPlanItemMapper.selectHisByExample(example);
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void confirmAllPlan(String orderId) {
        this.supDeliveryPlanItemMapper.updateConfirmStatusAndDeliveryDate(orderId, new Date());
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void modifyByExample(SupDeliveryPlanItem supPlanItem, SupDeliveryPlanItemExample supPlanItemEx) {
        this.supDeliveryPlanItemMapper.updateByExampleSelective(supPlanItem, supPlanItemEx);
    }

    @Override
    @Cacheable(value={"supDeliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public List<SupDeliveryPlanItem> queryByOrderId(String purOrderId) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        example.setOrderByClause("PUR_ORDER_ITEM_NO ASC, DELIVERY_DATE ASC");
        return this.supDeliveryPlanItemMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void confirmAllPlanByOrderItem(String orderItemId) {
        this.supDeliveryPlanItemMapper.updateConfirmStatusAndDeliveryDateByOrderItemId(orderItemId, new Date());
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void deleteByExample(SupDeliveryPlanItemExample supPlanItemExample) {
        this.supDeliveryPlanItemMapper.deleteByExample(supPlanItemExample);
    }

    @Override
    public BigDecimal getdistributedNum(String companySapCode, String materialCode, String factoryCode, List<String> ids) {
        List<SupDeliveryPlanItem> list;
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andMaterialNoEqualTo(materialCode).andFactoryCodeEqualTo(factoryCode).andSupCompanySapCodeEqualTo(companySapCode).andUsedStatusIn((List)Arrays.asList(DeliveryPlanUesdStatusEnum.UN_USED.getValue(), DeliveryPlanUesdStatusEnum.PART_USED.getValue()));
        if (CollectionUtils.isNotEmpty(ids)) {
            criteria.andIdNotIn((List)ids);
        }
        if (CollectionUtils.isEmpty(list = this.supDeliveryPlanItemMapper.selectByExample(example))) {
            return BigDecimal.ZERO;
        }
        BigDecimal num = BigDecimal.ZERO;
        for (SupDeliveryPlanItem item : list) {
            if (DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(item.getUsedStatus())) {
                num = num.add(item.getDeliveryQuantity());
            }
            if (!DeliveryPlanUesdStatusEnum.PART_USED.getValue().equals(item.getUsedStatus())) continue;
            num = num.add(item.getCanDeliveryQuantity());
        }
        return num;
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public BigDecimal getCoverNum(String companySapCode, String materialCode, String factoryCode, List<Date> dateList) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT).andMaterialNoEqualTo(materialCode).andFactoryCodeEqualTo(factoryCode).andSupCompanySapCodeEqualTo(companySapCode).andUsedStatusIn((List)Lists.newArrayList((Object[])new String[]{DeliveryPlanUesdStatusEnum.UN_USED.getValue(), DeliveryPlanUesdStatusEnum.PART_USED.getValue(), DeliveryPlanUesdStatusEnum.ALL_USED.getValue()})).andDeliveryDateIn((List)dateList);
        List<SupDeliveryPlanItem> list = this.supDeliveryPlanItemMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return BigDecimal.ZERO;
        }
        BigDecimal num = list.stream().map(SupDeliveryPlanItem::getDeliveryQuantity).reduce((x, y) -> x.add((BigDecimal)y)).get();
        return num;
    }

    @Override
    @CacheEvict(value={"supDeliveryPlanItem"}, allEntries=true)
    public void addOnwayQuantity(String planItemId, BigDecimal quantity) {
        int result = this.supDeliveryPlanItemMapper.addOnwayQuantity(planItemId, quantity);
        if (result <= 0) {
            throw new CommonException("\u8ba1\u5212\u7684\u5728\u9014\u6570\u91cf\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
    }

    @Override
    @Cacheable(value={"supDeliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public BigDecimal calculateCanDeliveryQuantity(String planItemId) {
        SupDeliveryPlanItem plan = this.supDeliveryPlanItemMapper.selectByPrimaryKey(planItemId);
        BigDecimal onwayQuantity = plan.getOnwayQuantity();
        BigDecimal receiveQuantity = plan.getReceivedQuantity();
        if (onwayQuantity == null) {
            onwayQuantity = BigDecimal.ZERO;
        }
        if (receiveQuantity == null) {
            receiveQuantity = BigDecimal.ZERO;
        }
        return plan.getDeliveryQuantity().subtract(onwayQuantity).subtract(receiveQuantity);
    }

    @Override
    @Cacheable(value={"supDeliveryPlanItem"}, keyGenerator="redisKeyGenerator")
    public void addReceiveQuantity(String planItemId, BigDecimal quantity) {
        this.supDeliveryPlanItemMapper.addReceiveQuantity(planItemId, quantity);
    }

    @Override
    public void updateConsumeMunber(String planId, BigDecimal quantity) {
        this.supDeliveryPlanItemMapper.updateConsumeMunber(planId, quantity);
    }
}

