/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.plan.entity.JITLeadTime;
import com.els.base.plan.entity.JITLeadTimeExample;
import com.els.base.plan.service.JITLeadTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"JIT\u63d0\u524d\u671f"})
@Controller
@RequestMapping(value={"jITLeadTime"})
public class JITLeadTimeController {
    @Resource
    protected JITLeadTimeService jITLeadTimeService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaJIT\u63d0\u524d\u671f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody JITLeadTime jITLeadTime) {
        User loginUser = SpringSecurityUtils.getLoginUser();
        jITLeadTime.setCreateTime(new Date());
        jITLeadTime.setCreateUserId(loginUser.getId());
        jITLeadTime.setCreateUserName(loginUser.getNickName());
        jITLeadTime.setUpdateTime(new Date());
        jITLeadTime.setUpdateUserId(loginUser.getId());
        jITLeadTime.setUpdateUserName(loginUser.getNickName());
        this.jITLeadTimeService.addObj(jITLeadTime);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91JIT\u63d0\u524d\u671f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody JITLeadTime jITLeadTime) {
        Assert.isNotBlank((String)jITLeadTime.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        User loginUser = SpringSecurityUtils.getLoginUser();
        jITLeadTime.setUpdateTime(new Date());
        jITLeadTime.setUpdateUserId(loginUser.getId());
        jITLeadTime.setUpdateUserName(loginUser.getNickName());
        this.jITLeadTimeService.modifyObj(jITLeadTime);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664JIT\u63d0\u524d\u671f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> codes) {
        Assert.isNotEmpty(codes, (String)"\u5220\u9664\u5931\u8d25,\u6807\u8bc6\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.jITLeadTimeService.deleteObjByCodes(codes);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2JIT\u63d0\u524d\u671f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 JITLeadTime", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<JITLeadTime>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        JITLeadTimeExample example = new JITLeadTimeExample();
        example.setOrderByClause("UPDATE_TIME ASC");
        example.setPageView((PageView<JITLeadTime>)new PageView(pageNo, pageSize));
        JITLeadTimeExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.jITLeadTimeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u63d0\u524d\u671f\u4fe1\u606f")
    @RequestMapping(value={"service/getLeadTimeByMaterialAndFactoryCode"})
    @ResponseBody
    public ResponseResult<JITLeadTime> getLeadTimeByMaterialAndFactoryCode(@RequestParam(required=true) String material, @RequestParam(required=true) String factoryCode) {
        JITLeadTimeExample example = new JITLeadTimeExample();
        example.createCriteria().andMaterialCodeEqualTo(material).andFactoryCodeEqualTo(factoryCode);
        return ResponseResult.success((Object)this.jITLeadTimeService.queryObjByExample(example));
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eID\u83b7\u53d6\u63d0\u524d\u671f\u4fe1\u606f")
    @RequestMapping(value={"service/getLeadTimeById"})
    @ResponseBody
    public ResponseResult<JITLeadTime> getLeadTimeByMaterialAndFactoryCode(@RequestParam(required=true) String id) {
        return ResponseResult.success((Object)this.jITLeadTimeService.queryObjById(id));
    }
}

