/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseUserCart;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.utils.SpringContextHolder;
import java.util.List;
import java.util.stream.Collectors;

public class UserCartToPurchaseRequestCmd
extends BaseCommand<String> {
    List<PurchaseUserCart> purchaseUserCarts;

    public List<PurchaseUserCart> getPurchaseUserCarts() {
        return this.purchaseUserCarts;
    }

    public void setPurchaseUserCarts(List<PurchaseUserCart> purchaseUserCarts) {
        this.purchaseUserCarts = purchaseUserCarts;
    }

    public UserCartToPurchaseRequestCmd(List<PurchaseUserCart> purchaseUserCarts) {
        this.purchaseUserCarts = purchaseUserCarts;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.purchaseUserCarts);
        this.fill(this.purchaseUserCarts);
        this.process(this.purchaseUserCarts);
        return null;
    }

    private void process(List<PurchaseUserCart> purchaseUserCarts) {
        List productIds = purchaseUserCarts.stream().map(PurchaseUserCart::getProductId).collect(Collectors.toList());
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn(productIds);
        PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
        List purchaseProducts = purchaseProductService.queryAllObjByExample((IExample)example);
    }

    private void fill(List<PurchaseUserCart> purchaseUserCarts) {
    }

    private void check(List<PurchaseUserCart> purchaseUserCarts) {
        Assert.isNotEmpty(purchaseUserCarts, (String)"\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        for (PurchaseUserCart purchaseUserCart : purchaseUserCarts) {
            Assert.isNotBlank((String)purchaseUserCart.getProductId(), (String)"\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

