/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseProductImageMapper;
import com.els.base.product.entity.PurchaseProductImage;
import com.els.base.product.entity.PurchaseProductImageExample;
import com.els.base.product.service.PurchaseProductImageService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseProductImageService")
public class PurchaseProductImageServiceImpl
implements PurchaseProductImageService {
    @Resource
    protected PurchaseProductImageMapper purchaseProductImageMapper;

    @CacheEvict(value={"purchaseProductImage"}, allEntries=true)
    public void addObj(PurchaseProductImage t) {
        this.purchaseProductImageMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProductImage"}, allEntries=true)
    public void addAll(List<PurchaseProductImage> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductImageMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProductImage"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductImageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProductImage"}, allEntries=true)
    public void deleteByExample(PurchaseProductImageExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductImageMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProductImage"}, allEntries=true)
    public void modifyObj(PurchaseProductImage t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductImageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProductImage"}, keyGenerator="redisKeyGenerator")
    public PurchaseProductImage queryObjById(String id) {
        return this.purchaseProductImageMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProductImage"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProductImage> queryAllObjByExample(PurchaseProductImageExample example) {
        return this.purchaseProductImageMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProductImage"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProductImage> queryObjByPage(PurchaseProductImageExample example) {
        PageView<PurchaseProductImage> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductImageMapper.selectByExampleByPage(example));
        return pageView;
    }
}

