/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.dao.PurchaseProductMapper;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseProductService")
public class PurchaseProductServiceImpl
implements PurchaseProductService,
ITaskListener {
    @Resource
    protected PurchaseProductMapper purchaseProductMapper;

    @Override
    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public int countByExample(PurchaseProductExample example) {
        return this.purchaseProductMapper.countByExample(example);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank((String)businessId)) {
            return;
        }
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdEqualTo(event.getBusinessId());
        PurchaseProduct purchaseProduct = new PurchaseProduct();
        purchaseProduct.setId(businessId);
        if (event.isFinished() && event.isPass()) {
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
        } else if (event.isFinished() && !event.isPass()) {
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_REFUSE.getValue());
        }
        this.purchaseProductMapper.updateByExampleSelective(purchaseProduct, example);
    }

    @Override
    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(PurchaseProduct record, PurchaseProductExample example) {
        return this.purchaseProductMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void addObj(PurchaseProduct t) {
        this.purchaseProductMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void addAll(List<PurchaseProduct> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void deleteByExample(PurchaseProductExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void modifyObj(PurchaseProduct t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public PurchaseProduct queryObjById(String id) {
        return this.purchaseProductMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProduct> queryAllObjByExample(PurchaseProductExample example) {
        return this.purchaseProductMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProduct> queryObjByPage(PurchaseProductExample example) {
        PageView<PurchaseProduct> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductMapper.selectByExampleByPage(example));
        return pageView;
    }
}

