/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseUserOrderItemMapper;
import com.els.base.product.entity.PurchaseUserOrderItem;
import com.els.base.product.entity.PurchaseUserOrderItemExample;
import com.els.base.product.service.PurchaseUserOrderItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseUserOrderItemService")
public class PurchaseUserOrderItemServiceImpl
implements PurchaseUserOrderItemService {
    @Resource
    protected PurchaseUserOrderItemMapper purchaseUserOrderItemMapper;

    @CacheEvict(value={"purchaseUserOrderItem"}, allEntries=true)
    public void addObj(PurchaseUserOrderItem t) {
        this.purchaseUserOrderItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseUserOrderItem"}, allEntries=true)
    public void addAll(List<PurchaseUserOrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseUserOrderItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseUserOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseUserOrderItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseUserOrderItem"}, allEntries=true)
    public void deleteByExample(PurchaseUserOrderItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseUserOrderItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseUserOrderItem"}, allEntries=true)
    public void modifyObj(PurchaseUserOrderItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseUserOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseUserOrderItem"}, keyGenerator="redisKeyGenerator")
    public PurchaseUserOrderItem queryObjById(String id) {
        return this.purchaseUserOrderItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseUserOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseUserOrderItem> queryAllObjByExample(PurchaseUserOrderItemExample example) {
        return this.purchaseUserOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseUserOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseUserOrderItem> queryObjByPage(PurchaseUserOrderItemExample example) {
        PageView<PurchaseUserOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseUserOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

